/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.core.model.llm;

import com.kms.katalon.ai.core.model.llm.ImageFormat;
import com.kms.katalon.ai.core.model.llm.UserInput;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class InlineImageInput
extends UserInput {
    private String data;
    private ImageFormat format;

    public InlineImageInput() {
        super(UserInput.UserInputType.INLINE_IMAGE);
    }

    private InlineImageInput(String data, ImageFormat format) {
        this();
        this.data = data;
        this.format = format;
    }

    public static InlineImageInput of(String data, ImageFormat format) {
        if (StringUtils.isBlank((CharSequence)data)) {
            throw new IllegalArgumentException("InlineImageInput data must not be blank");
        }
        if (format == null) {
            throw new IllegalArgumentException("InlineImageInput format is required");
        }
        return new InlineImageInput(data, format);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public ImageFormat getFormat() {
        return this.format;
    }

    public void setFormat(ImageFormat format) {
        this.format = format;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void that;
        if (this == o) {
            return true;
        }
        if (!(o instanceof InlineImageInput)) {
            return false;
        }
        InlineImageInput inlineImageInput = (InlineImageInput)o;
        return Objects.equals(this.data, that.data) && this.format == that.format;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.data, this.format});
    }

    public static class Builder {
        private String data;
        private ImageFormat format;

        public Builder data(String data) {
            this.data = data;
            return this;
        }

        public Builder format(ImageFormat format) {
            this.format = format;
            return this;
        }

        public InlineImageInput build() {
            return InlineImageInput.of(this.data, this.format);
        }
    }
}

