/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.core.registry;

import com.kms.katalon.ai.core.registry.ToolProcessingAction;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public final class ToolDefinition {
    private final String toolName;
    private final Set<ToolProcessingAction> actions;
    private final boolean diffComputationEnabled;
    private final boolean compareMetadata;

    private ToolDefinition(Builder builder) {
        this.toolName = Objects.requireNonNull(builder.toolName, "toolName");
        this.actions = Collections.unmodifiableSet(EnumSet.copyOf(builder.actions));
        this.diffComputationEnabled = builder.diffComputationEnabled;
        this.compareMetadata = builder.compareMetadata;
    }

    public String getToolName() {
        return this.toolName;
    }

    public Set<ToolProcessingAction> getActions() {
        return this.actions;
    }

    public boolean requiresSnapshot() {
        return this.actions.contains((Object)ToolProcessingAction.CAPTURE_SNAPSHOT);
    }

    public boolean isDiffComputationEnabled() {
        return this.diffComputationEnabled;
    }

    public boolean isCompareMetadata() {
        return this.compareMetadata;
    }

    public static Builder builder(String toolName) {
        return new Builder(toolName);
    }

    public static final class Builder {
        private final String toolName;
        private final EnumSet<ToolProcessingAction> actions = EnumSet.noneOf(ToolProcessingAction.class);
        private boolean diffComputationEnabled = false;
        private boolean compareMetadata = false;

        private Builder(String toolName) {
            this.toolName = toolName;
        }

        public Builder addAction(ToolProcessingAction action) {
            if (action != null) {
                this.actions.add(action);
            }
            return this;
        }

        public Builder actions(Set<ToolProcessingAction> actions) {
            if (actions != null) {
                this.actions.addAll(actions);
            }
            return this;
        }

        public Builder diffComputationEnabled() {
            this.diffComputationEnabled = true;
            return this;
        }

        public Builder compareMetadata() {
            this.compareMetadata = true;
            return this;
        }

        public ToolDefinition build() {
            return new ToolDefinition(this);
        }
    }
}

