/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.core.registry;

import com.kms.katalon.ai.core.registry.ToolDefinition;
import com.kms.katalon.ai.core.registry.ToolProcessingAction;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class ToolRegistry {
    private final Map<String, ToolDefinition> definitions = this.registerDefaults();

    public Optional<ToolDefinition> find(String toolName) {
        if (toolName == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.definitions.get(toolName));
    }

    public Map<String, ToolDefinition> getAll() {
        return this.definitions;
    }

    private Map<String, ToolDefinition> registerDefaults() {
        LinkedHashMap map = new LinkedHashMap();
        Set<String> updateScriptTools = Set.of("updateTestCaseScript", "updateBddFeatureFile", "updateCustomKeyword");
        updateScriptTools.forEach(tool -> ToolRegistry.register(map, ToolDefinition.builder(tool).addAction(ToolProcessingAction.CAPTURE_SNAPSHOT).addAction(ToolProcessingAction.TRACK_MODIFICATION).diffComputationEnabled().build()));
        Set<String> createEntityTools = Set.of("createTestCase", "createTestSuite", "createTestSuiteCollection", "createDynamicTestSuite", "createWebTestObject", "createMobileTestObject", "createWindowsTestObject", "createRestWebServiceTestObject", "createSoapWebServiceTestObject", "createInternalTestData", "createBddFeatureFile", "createCustomKeyword");
        createEntityTools.forEach(tool -> ToolRegistry.register(map, ToolDefinition.builder(tool).addAction(ToolProcessingAction.TRACK_MODIFICATION).build()));
        Set<String> updateEntityTools = Set.of("updateTestCase", "updateTestSuite", "updateTestSuiteCollection", "updateDynamicTestSuite", "updateWebTestObject", "updateMobileTestObject", "updateWindowsTestObject", "updateRestWebServiceTestObject", "updateSoapWebServiceTestObject", "updateInternalTestData");
        updateEntityTools.forEach(tool -> ToolRegistry.register(map, ToolDefinition.builder(tool).addAction(ToolProcessingAction.CAPTURE_SNAPSHOT).addAction(ToolProcessingAction.TRACK_MODIFICATION).compareMetadata().build()));
        return Collections.unmodifiableMap(map);
    }

    private static void register(Map<String, ToolDefinition> map, ToolDefinition definition) {
        map.put(definition.getToolName(), definition);
    }
}

