/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.groovy.reference;

import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.reference.EntityReferenceIndexService;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.util.ExecutionTimeTracker;
import com.kms.katalon.util.collections.Pair;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class TestArtifactScriptRefactor {
    private FolderEntity.FolderType parentType;
    private EntityType entityType;
    private String entityId;
    private boolean hasRightBracket;
    private boolean hasRightQuote;
    private boolean hasRightDoubleQuote;
    private boolean isFolder;

    public TestArtifactScriptRefactor(FolderEntity.FolderType parentType, String entityId, boolean hasRightBracket, boolean hasRightQuote, boolean hasRightDoubleQuote) {
        this(parentType, null, entityId, hasRightBracket, hasRightQuote, hasRightDoubleQuote, false);
    }

    public TestArtifactScriptRefactor(FolderEntity.FolderType parentType, String entityId, boolean hasRightBracket, boolean hasRightQuote, boolean hasRightDoubleQuote, boolean isFolder) {
        this(parentType, null, entityId, hasRightBracket, hasRightQuote, hasRightDoubleQuote, isFolder);
    }

    public TestArtifactScriptRefactor(FolderEntity.FolderType parentType, EntityType entityType, String entityId, boolean hasRightBracket, boolean hasRightQuote, boolean hasRightDoubleQuote, boolean isFolder) {
        this.parentType = parentType;
        this.entityType = entityType;
        this.entityId = entityId;
        this.hasRightBracket = hasRightBracket;
        this.hasRightQuote = hasRightQuote;
        this.hasRightDoubleQuote = hasRightDoubleQuote;
        this.isFolder = isFolder;
    }

    public FolderEntity.FolderType getParentType() {
        return this.parentType;
    }

    public String getEntityId() {
        return this.entityId;
    }

    private String getReferencePrefixByEntityType() {
        if (this.entityType == null) {
            return "";
        }
        switch (this.entityType) {
            case WEBELEMENT: {
                return "findTestObject";
            }
            case WINDOWSELEMENT: {
                return "findWindowsObject";
            }
        }
        return "";
    }

    private String getReferencePrefix() {
        String prefix = this.getReferencePrefixByEntityType();
        if (!prefix.isEmpty()) {
            return prefix;
        }
        switch (this.parentType) {
            case DATAFILE: {
                return "findTestData";
            }
            case TESTCASE: {
                return "findTestCase";
            }
            case WEBELEMENT: {
                return "findTestObject";
            }
            case CHECKPOINT: {
                return "findCheckpoint";
            }
        }
        return "";
    }

    private String getRelativeId(String s) {
        int firstSeparatorIdx = s.indexOf("/");
        if (firstSeparatorIdx < 0) {
            return s;
        }
        return s.substring(firstSeparatorIdx + 1, s.length());
    }

    private String buildParentheses(String s) {
        return "(" + s + (this.hasRightBracket ? ")" : "");
    }

    private String buildQuote(String s) {
        return "'" + s + (this.hasRightQuote ? "'" : "");
    }

    private String buildDoubleQuotes(String s) {
        return "\"" + s + (this.hasRightDoubleQuote ? "\"" : "");
    }

    public List<String> getReferenceStrings() {
        ArrayList<String> referenceString = new ArrayList<String>();
        referenceString.add(this.getQuotedReferencesRelativeId());
        referenceString.add(this.getQuotedReferencesEntityId());
        referenceString.add(this.getDoubleQuotedReferenceStringsRelativeId());
        referenceString.add(this.getDoubleQuotedReferenceStringsEntityId());
        return referenceString;
    }

    private String getQuotedReferencesRelativeId() {
        String prefix = this.getReferencePrefix();
        String relativeId = this.getRelativeId(this.entityId);
        return prefix + this.buildParentheses(this.buildQuote(relativeId));
    }

    private String getQuotedReferencesEntityId() {
        String prefix = this.getReferencePrefix();
        return prefix + this.buildParentheses(this.buildQuote(this.entityId));
    }

    private String getDoubleQuotedReferenceStringsRelativeId() {
        String prefix = this.getReferencePrefix();
        String relativeId = this.getRelativeId(this.entityId);
        return prefix + this.buildParentheses(this.buildDoubleQuotes(relativeId));
    }

    private String getDoubleQuotedReferenceStringsEntityId() {
        String prefix = this.getReferencePrefix();
        return prefix + this.buildParentheses(this.buildDoubleQuotes(this.entityId));
    }

    private void replaceScriptFile(IFile file, Charset charset, List<Pair<String, String>> replacements, String requiredSubString) throws IOException, CoreException {
        String scriptContent;
        Path path = Paths.get(file.getLocation().toOSString(), new String[0]);
        String originalContent = scriptContent = Files.readString(path, charset);
        if (!scriptContent.contains(requiredSubString)) {
            return;
        }
        for (Pair<String, String> pair : replacements) {
            scriptContent = StringUtils.replace((String)scriptContent, (String)((String)pair.getLeft()), (String)((String)pair.getRight()));
        }
        if (originalContent.equals(scriptContent)) {
            return;
        }
        Files.writeString(path, (CharSequence)scriptContent, charset, new OpenOption[0]);
        file.refreshLocal(0, null);
    }

    private String getScriptContent(IFile file) throws IOException, CoreException {
        Charset charset = Charset.forName("UTF-8");
        Path path = Paths.get(file.getLocation().toOSString(), new String[0]);
        return Files.readString(path, charset);
    }

    public boolean hasReferenceInScript(IFile scriptFile) throws IOException, CoreException {
        String scriptContent = this.getScriptContent(scriptFile);
        for (String potentialRef : this.getReferenceStrings()) {
            if (!scriptContent.contains(potentialRef)) continue;
            return true;
        }
        return false;
    }

    public List<IFile> findReferrers(List<IFile> files) throws IOException, CoreException {
        ArrayList<IFile> referrers = new ArrayList<IFile>();
        for (IFile scriptFile : files) {
            if (!this.hasReferenceInScript(scriptFile)) continue;
            referrers.add(scriptFile);
        }
        return referrers;
    }

    public List<IFile> findReferrersInScriptsAndVariables(ProjectEntity projectEntity) throws IOException, CoreException {
        ArrayList<IFile> files = new ArrayList<IFile>();
        files.addAll(GroovyUtil.getAllScriptFiles(projectEntity));
        files.addAll(GroovyUtil.getAllGlobalVariableFiles(projectEntity));
        files.addAll(GroovyUtil.getAllTestCaseFiles(projectEntity));
        return this.findReferrers(files);
    }

    public List<IFile> findReferrersInTestCaseScripts(ProjectEntity projectEntity) throws IOException, CoreException {
        return this.findReferrers(GroovyUtil.getAllTestCaseScripts(projectEntity));
    }

    public void updateReferenceForProject(String newScript, ProjectEntity projectEntity) throws IOException, CoreException {
        this.updateReferenceForTestCaseFolder(newScript, projectEntity);
        this.updateReferenceForTestListeners(newScript, projectEntity);
        switch (this.parentType) {
            case TESTCASE: {
                this.updateReferenceForTestSuitesFolder(newScript, projectEntity);
                this.updateReferenceForCustomKeywords(newScript, projectEntity);
                this.updateReferenceForStepDefinitions(newScript, projectEntity);
                break;
            }
            case WEBELEMENT: {
                this.updateReferenceForTestSuitesFolder(newScript, projectEntity);
                this.updateReferenceForCustomKeywords(newScript, projectEntity);
                this.updateReferenceForStepDefinitions(newScript, projectEntity);
                break;
            }
            case DATAFILE: {
                this.updateReferenceForTestSuitesFolder(newScript, projectEntity);
                this.updateReferenceForCustomKeywords(newScript, projectEntity);
                this.updateReferenceForStepDefinitions(newScript, projectEntity);
                break;
            }
            case CHECKPOINT: {
                this.updateReferenceForTestSuitesFolder(newScript, projectEntity);
                this.updateReferenceForCustomKeywords(newScript, projectEntity);
                this.updateReferenceForStepDefinitions(newScript, projectEntity);
                break;
            }
        }
    }

    private void updateReferenceForTestListeners(String newScript, ProjectEntity projectEntity) throws IOException, CoreException {
        this.updateReferences(newScript, GroovyUtil.getAllTestListenerScripts(projectEntity));
    }

    public void updateReferenceForTestCaseFolder(String newScript, ProjectEntity projectEntity) throws IOException, CoreException {
        List<IFile> allScriptFiles = GroovyUtil.getAllTestCaseScripts(projectEntity);
        List<IFile> finalScriptFiles = !EntityReferenceIndexService.getInstance().isReady() ? allScriptFiles : this.searchIFilesToUpdateReferenceFromIndexCache(allScriptFiles);
        String taskName = "Update entity references in test case groovy scripts (" + finalScriptFiles.size() + " file(s))";
        ExecutionTimeTracker.getInstance().start(taskName);
        this.updateReferences(newScript, finalScriptFiles);
        ExecutionTimeTracker.getInstance().stop(taskName);
    }

    private List<IFile> searchIFilesToUpdateReferenceFromIndexCache(List<IFile> allScriptFiles) {
        ArrayList<IFile> finalScriptFiles = new ArrayList<IFile>();
        if (!this.isFolder) {
            finalScriptFiles.addAll(EntityReferenceIndexService.getInstance().searchIFilesReferencingEntityId(this.entityId, allScriptFiles));
            finalScriptFiles.addAll(EntityReferenceIndexService.getInstance().searchIFilesReferencingEntityId(this.getRelativeId(this.entityId), allScriptFiles));
        } else {
            finalScriptFiles.addAll(EntityReferenceIndexService.getInstance().searchIFilesReferencingEntityIdPrefix(this.entityId, allScriptFiles));
            finalScriptFiles.addAll(EntityReferenceIndexService.getInstance().searchIFilesReferencingEntityIdPrefix(this.getRelativeId(this.entityId), allScriptFiles));
        }
        return new ArrayList<IFile>(new LinkedHashSet(finalScriptFiles));
    }

    public void updateReferenceForCustomKeywords(String newScript, ProjectEntity projectEntity) throws IOException, CoreException {
        this.updateReferences(newScript, GroovyUtil.getAllCustomKeywordsScripts(projectEntity));
    }

    private void updateReferenceForTestSuitesFolder(String newScript, ProjectEntity projectEntity) throws IOException, CoreException {
        List<IFile> allScriptFiles = GroovyUtil.getAllTestSuiteScripts(projectEntity);
        List<IFile> finalScriptFiles = !EntityReferenceIndexService.getInstance().isReady() ? allScriptFiles : this.searchIFilesToUpdateReferenceFromIndexCache(allScriptFiles);
        String taskName = "Update entity references in test suite groovy scripts (" + finalScriptFiles.size() + " file(s))";
        ExecutionTimeTracker.getInstance().start(taskName);
        this.updateReferences(newScript, finalScriptFiles);
        ExecutionTimeTracker.getInstance().stop(taskName);
    }

    private void updateReferenceForStepDefinitions(String newScript, ProjectEntity projectEntity) throws IOException, CoreException {
        this.updateReferences(newScript, GroovyUtil.getAllStepDefinitionScripts(projectEntity));
    }

    private List<Pair<String, String>> buildReferenceReplacementPairs(String newEntityId, String referencePrefix) {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        String oldEntityId = this.entityId;
        String oldRelativeId = this.getRelativeId(oldEntityId);
        String newRelativeId = this.getRelativeId(newEntityId);
        result.add(new Pair((Object)(referencePrefix + this.buildParentheses(this.buildQuote(oldRelativeId))), (Object)(referencePrefix + this.buildParentheses(this.buildQuote(newRelativeId)))));
        result.add(new Pair((Object)(referencePrefix + this.buildParentheses(this.buildQuote(oldEntityId))), (Object)(referencePrefix + this.buildParentheses(this.buildQuote(newEntityId)))));
        result.add(new Pair((Object)(referencePrefix + this.buildParentheses(this.buildDoubleQuotes(oldRelativeId))), (Object)(referencePrefix + this.buildParentheses(this.buildDoubleQuotes(newRelativeId)))));
        result.add(new Pair((Object)(referencePrefix + this.buildParentheses(this.buildDoubleQuotes(oldEntityId))), (Object)(referencePrefix + this.buildParentheses(this.buildDoubleQuotes(newEntityId)))));
        return result;
    }

    public void updateReferences(String newScript, List<IFile> files) throws IOException, CoreException {
        if (files == null || files.isEmpty()) {
            return;
        }
        List<Pair<String, String>> replacementListForNonWebElement = this.buildReferenceReplacementPairs(newScript, this.getReferencePrefix());
        List<Pair<String, String>> replacementListForWebElement = this.buildReferenceReplacementPairs(newScript, "findTestObject");
        replacementListForWebElement.addAll(this.buildReferenceReplacementPairs(newScript, "findWindowsObject"));
        Charset charset = Charset.forName("UTF-8");
        String relativeEntityId = this.getRelativeId(this.entityId);
        for (IFile scriptFile : files) {
            if (this.isFolder && this.parentType == FolderEntity.FolderType.WEBELEMENT) {
                this.replaceScriptFile(scriptFile, charset, replacementListForWebElement, relativeEntityId);
                continue;
            }
            this.replaceScriptFile(scriptFile, charset, replacementListForNonWebElement, relativeEntityId);
        }
    }

    public void removeReferences(List<IFile> files) throws IOException, CoreException {
        this.updateReferences(GlobalStringConstants.NULL, files);
    }

    public static TestArtifactScriptRefactor createForTestDataEntity(String testDataId) {
        return new TestArtifactScriptRefactor(FolderEntity.FolderType.DATAFILE, testDataId, true, true, true);
    }

    public static TestArtifactScriptRefactor createForTestCaseEntity(String testCaseId) {
        return new TestArtifactScriptRefactor(FolderEntity.FolderType.TESTCASE, testCaseId, true, true, true);
    }

    public static TestArtifactScriptRefactor createForTestObjectEntity(String testObjectId) {
        return new TestArtifactScriptRefactor(FolderEntity.FolderType.WEBELEMENT, EntityType.WEBELEMENT, testObjectId, false, true, true, false);
    }

    public static TestArtifactScriptRefactor createForWindowsObjectEntity(String testObjectId) {
        return new TestArtifactScriptRefactor(FolderEntity.FolderType.WEBELEMENT, EntityType.WINDOWSELEMENT, testObjectId, false, true, true, false);
    }

    public static TestArtifactScriptRefactor createForCheckpointEntity(String checkpointId) {
        return new TestArtifactScriptRefactor(FolderEntity.FolderType.CHECKPOINT, checkpointId, true, true, true);
    }

    public static TestArtifactScriptRefactor createForFolderEntity(FolderEntity folder) {
        return new TestArtifactScriptRefactor(folder.getFolderType(), folder.getIdForDisplay() + "/", false, false, false, true);
    }

    public static enum EntityType {
        DATAFILE,
        TESTCASE,
        CHECKPOINT,
        WEBELEMENT,
        WINDOWSELEMENT;

    }
}

