/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.tracking.service;

import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryService;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.tracking.builder.PayloadBuilder;
import com.kms.katalon.tracking.model.TrackingActivationInfo;
import com.kms.katalon.tracking.model.TrackingUsageInfo;
import com.kms.katalon.tracking.model.exception.TrackingException;
import com.kms.katalon.tracking.provider.TrackingApiProvider;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class TrackingService {
    private static String PROP_KEY_KATALON_USAGE_TRACKING_DISABLED = "katalon.telemetryDisabled";
    @Inject
    IFeatureController featureController;
    @Inject
    IDiscoveryService discoveryService;
    @Inject
    IHttpClient httpClient;
    @Inject
    INetworkPreferences networkPreferences;
    private ExecutorService executor = Executors.newFixedThreadPool(10);

    public boolean canSubmitUsageTrackingData() {
        boolean canConfigUsageTracking = this.featureController.canUse(ProductFeature.CONFIGURE_USAGE_TRACKING);
        if (!canConfigUsageTracking) {
            return true;
        }
        if (Boolean.valueOf(System.getProperty(PROP_KEY_KATALON_USAGE_TRACKING_DISABLED)).booleanValue()) {
            return false;
        }
        ScopedPreferenceStore prefStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon");
        return prefStore.contains("general.autoCheckAllowUsage_Tracking") ? prefStore.getBoolean("general.autoCheckAllowUsage_Tracking") : true;
    }

    public void trackUsage(TrackingUsageInfo trackInfo) {
        String baseUrl = this.discoveryService.getServerUrl(ServerType.TRACKING);
        if (StringUtils.isBlank((CharSequence)baseUrl)) {
            return;
        }
        this.executor.submit(() -> {
            try {
                PayloadBuilder payloadBuilder = new PayloadBuilder();
                String payload = payloadBuilder.buildUsageTrackingPayload(trackInfo);
                URI uri = null;
                try {
                    URI baseUri = new URI(baseUrl);
                    URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath(TrackingApiProvider.TRACKING_PRODUCT_USAGE_PATH);
                    uri = uriBuilder.build();
                }
                catch (URISyntaxException e) {
                    throw new TrackingException(e.getMessage());
                }
                HashMap headers = new HashMap();
                ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
                HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).proxy(proxyConfig).build();
                this.httpClient.jsonPost(uri, payload, httpOptions);
            }
            catch (Exception exception) {}
        });
    }

    public void trackActivation(TrackingActivationInfo trackInfo) {
        String baseUrl = this.discoveryService.getServerUrl(ServerType.TRACKING);
        if (StringUtils.isBlank((CharSequence)baseUrl)) {
            return;
        }
        this.executor.submit(() -> {
            try {
                PayloadBuilder payloadBuilder = new PayloadBuilder();
                String payload = payloadBuilder.buildActivationTrackingPayload(trackInfo);
                URI uri = null;
                try {
                    URI baseUri = new URI(baseUrl);
                    URIBuilder uriBuilder = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPort(baseUri.getPort()).setPath(TrackingApiProvider.TRACKING_ACTIVATION_PATH);
                    uri = uriBuilder.build();
                }
                catch (URISyntaxException e) {
                    throw new TrackingException(e.getMessage());
                }
                HashMap headers = new HashMap();
                ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
                HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).proxy(proxyConfig).build();
                this.httpClient.jsonPost(uri, payload, httpOptions);
            }
            catch (Exception exception) {}
        });
    }
}

