/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.entity.testsuite;

import com.kms.katalon.entity.Entity;
import com.kms.katalon.entity.IExecutableEntity;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteRunConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;

public class TestSuiteCollectionEntity
extends FileEntity
implements IExecutableEntity {
    private static final long serialVersionUID = -611439373065144113L;
    public static final String FILE_EXTENSION = ".ts";
    public static final int DF_CONCURRENT_INSTANCES = 8;
    public static final int MIN_CONCURRENT_INSTANCES = 1;
    public static final int MAX_CONCURRENT_INSTANCES = 1000;
    public static final int DF_DELAY_BETWEEN_INSTANCES = 0;
    public static final int MIN_DELAY_BETWEEN_INSTANCES = 0;
    public static final int MAX_DELAY_BETWEEN_INSTANCES = 999;
    private List<TestSuiteRunConfiguration> testSuiteRunConfigurations;
    private ExecutionMode executionMode;
    private int maxConcurrentInstances = 8;
    private String browserType;
    private String profileName;
    private int delayBetweenInstances = 0;

    public List<TestSuiteRunConfiguration> getTestSuiteRunConfigurations() {
        if (this.testSuiteRunConfigurations == null) {
            this.testSuiteRunConfigurations = new ArrayList<TestSuiteRunConfiguration>();
        }
        return this.testSuiteRunConfigurations;
    }

    public void setTestSuiteRunConfigurations(List<TestSuiteRunConfiguration> testSuiteRunConfigurations) {
        this.testSuiteRunConfigurations = testSuiteRunConfigurations;
    }

    @Override
    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
        result = 31 * result + (this.testSuiteRunConfigurations == null ? 0 : this.testSuiteRunConfigurations.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        TestSuiteCollectionEntity other = (TestSuiteCollectionEntity)obj;
        EqualsBuilder equalBuilder = new EqualsBuilder();
        return equalBuilder.append((Object)this.getTag(), (Object)other.getTag()).append(this.getTestSuiteRunConfigurations(), other.getTestSuiteRunConfigurations()).isEquals();
    }

    public void reuseWrappers(TestSuiteCollectionEntity src) {
        ArrayList<TestSuiteRunConfiguration> runConfigs = new ArrayList<TestSuiteRunConfiguration>();
        for (TestSuiteRunConfiguration eachSourceConfig : src.getTestSuiteRunConfigurations()) {
            runConfigs.add(TestSuiteRunConfiguration.cloneFrom(eachSourceConfig));
        }
        this.setTestSuiteRunConfigurations(runConfigs);
        this.setExecutionMode(src.getExecutionMode());
        this.setMaxConcurrentInstances(src.getMaxConcurrentInstances());
        this.setDelayBetweenInstances(src.getDelayBetweenInstances());
    }

    @Override
    public Entity clone() {
        return super.clone();
    }

    public boolean isAnyRunEnabled() {
        for (TestSuiteRunConfiguration testSuiteRunConfig : this.getTestSuiteRunConfigurations()) {
            if (!testSuiteRunConfig.isRunEnabled()) continue;
            return true;
        }
        return false;
    }

    public boolean isAllRunEnabled() {
        for (TestSuiteRunConfiguration testSuiteRunConfig : this.getTestSuiteRunConfigurations()) {
            if (testSuiteRunConfig.isRunEnabled()) continue;
            return false;
        }
        return true;
    }

    public void enableRunForAll(boolean runEnabled) {
        for (TestSuiteRunConfiguration testSuiteRunConfig : this.getTestSuiteRunConfigurations()) {
            testSuiteRunConfig.setRunEnabled(runEnabled);
        }
    }

    public List<TestSuiteRunConfiguration> findRunConfigurations(TestSuiteEntity testSuite) {
        if (testSuite == null) {
            return Collections.emptyList();
        }
        ArrayList<TestSuiteRunConfiguration> runConfigurations = new ArrayList<TestSuiteRunConfiguration>();
        for (TestSuiteRunConfiguration config : this.getTestSuiteRunConfigurations()) {
            if (!testSuite.equals(config.getTestSuiteEntity())) continue;
            runConfigurations.add(config);
        }
        return runConfigurations;
    }

    public boolean hasTestSuiteReferences(TestSuiteEntity testSuite) {
        return !this.findRunConfigurations(testSuite).isEmpty();
    }

    public ExecutionMode getExecutionMode() {
        if (this.executionMode == null) {
            return ExecutionMode.SEQUENTIAL;
        }
        return this.executionMode;
    }

    public void setExecutionMode(ExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    public boolean isEmpty() {
        return this.testSuiteRunConfigurations.isEmpty();
    }

    public int getMaxConcurrentInstances() {
        return this.maxConcurrentInstances;
    }

    public void setMaxConcurrentInstances(int maxConcurrentInstances) {
        this.maxConcurrentInstances = maxConcurrentInstances;
    }

    public String getBrowserType() {
        return this.browserType;
    }

    public void setBrowserType(String browserType) {
        this.browserType = browserType;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public void setDelayBetweenInstances(int delayBetweenInstances) {
        this.delayBetweenInstances = delayBetweenInstances;
    }

    public int getDelayBetweenInstances() {
        return this.delayBetweenInstances;
    }

    public static enum ExecutionMode {
        SEQUENTIAL,
        PARALLEL;

    }
}

