/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.common;

import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.model.SSLClientCertificateSettings;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.testobject.ConditionType;
import com.kms.katalon.core.testobject.HttpBodyContent;
import com.kms.katalon.core.testobject.RequestObject;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.core.testobject.TestObjectProperty;
import com.kms.katalon.core.testobject.impl.HttpBinaryBodyContent;
import com.kms.katalon.core.testobject.impl.HttpFormDataBodyContent;
import com.kms.katalon.core.testobject.impl.HttpTextBodyContent;
import com.kms.katalon.core.util.MimeTypeUtil;
import com.kms.katalon.core.webservice.common.HttpUtil;
import com.kms.katalon.core.webservice.common.Requestor;
import com.kms.katalon.core.webservice.helper.WebServiceCommonHelper;
import com.kms.katalon.core.webservice.setting.SSLCertificateOption;
import com.kms.katalon.core.webservice.setting.WebServiceSettingStore;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public abstract class BasicRequestor
implements Requestor {
    protected String projectDir;
    protected ProxyInformation proxyInformation;
    protected WebServiceSettingStore settingStore;
    private KeywordLogger logger = KeywordLogger.getInstance(BasicRequestor.class);

    public BasicRequestor(String projectDir, ProxyInformation proxyInformation) {
        this.projectDir = projectDir;
        this.proxyInformation = proxyInformation;
    }

    @Override
    public ResponseObject send(RequestObject requestObject) throws Exception {
        HttpUriRequest httpRequest = this.buildHttpRequest(requestObject);
        long startTime = System.currentTimeMillis();
        HttpResponse httpResponse = HttpUtil.sendRequest(httpRequest, requestObject.isFollowRedirects(), this.proxyInformation, requestObject.getConnectionTimeout(), requestObject.getSocketTimeout(), requestObject.getMaxResponseSize(), this.getSslCertificateOption(), this.getSSLSettings(), requestObject.getRequestAuthorization());
        long waitingTime = System.currentTimeMillis() - startTime;
        ResponseObject responseObject = this.toResponseObject(httpResponse);
        responseObject.setWaitingTime(waitingTime);
        return responseObject;
    }

    protected abstract HttpUriRequest buildHttpRequest(RequestObject var1) throws Exception;

    protected SSLCertificateOption getSslCertificateOption() throws IOException {
        return this.getSettingStore().getSSLCertificateOption();
    }

    protected SSLClientCertificateSettings getSSLSettings() throws IOException {
        return this.getSettingStore().getClientCertificateSettings();
    }

    protected void setHttpConnectionHeaders(HttpRequest httpRequest, RequestObject request) throws GeneralSecurityException, IOException {
        List<TestObjectProperty> headers = this.getRequestHeaders(request);
        headers.forEach(header -> {
            if (request.getBodyContent() instanceof HttpFormDataBodyContent && header.getName().equalsIgnoreCase("Content-Type")) {
                httpRequest.addHeader(header.getName(), request.getBodyContent().getContentType());
            } else {
                httpRequest.addHeader(header.getName(), header.getValue());
            }
        });
    }

    protected List<TestObjectProperty> getRequestHeaders(RequestObject request) throws GeneralSecurityException, IOException {
        ArrayList<TestObjectProperty> headers = new ArrayList<TestObjectProperty>(request.getHttpHeaderProperties());
        List<TestObjectProperty> complexAuthAttributes = request.getHttpHeaderProperties().stream().filter(header -> StringUtils.startsWith((CharSequence)header.getName(), (CharSequence)"Authorization:")).collect(Collectors.toList());
        if (!complexAuthAttributes.isEmpty()) {
            headers.removeAll(complexAuthAttributes);
            String authorizationValue = BasicRequestor.generateAuthorizationHeader(this.getRequestUrl(request), complexAuthAttributes, request);
            if (!authorizationValue.isEmpty()) {
                headers.add(new TestObjectProperty("Authorization", ConditionType.EQUALS, authorizationValue));
            }
        }
        return headers;
    }

    private String getRequestUrl(RequestObject request) {
        return StringUtils.equals((CharSequence)request.getServiceType(), (CharSequence)"RESTful") ? request.getRestUrl() : request.getWsdlAddress();
    }

    private static String generateAuthorizationHeader(String requestUrl, List<TestObjectProperty> complexAuthAttributes, RequestObject request) throws GeneralSecurityException, IOException {
        Map<String, String> map = complexAuthAttributes.stream().collect(Collectors.toMap(TestObjectProperty::getName, TestObjectProperty::getValue));
        String authType = map.get("Authorization:type");
        if (StringUtils.isBlank((CharSequence)authType)) {
            return "";
        }
        "OAuth 1.0".equals(authType);
        return "";
    }

    protected ResponseObject toResponseObject(HttpResponse httpResponse) throws Exception {
        long startTime = System.currentTimeMillis();
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        long contentDownloadTime = 0L;
        byte[] responseData = null;
        long bodyLength = 0L;
        HttpEntity responseEntity = httpResponse.getEntity();
        if (responseEntity != null) {
            startTime = System.currentTimeMillis();
            responseData = EntityUtils.toByteArray((HttpEntity)responseEntity);
            bodyLength = responseData.length;
            contentDownloadTime = System.currentTimeMillis() - startTime;
        }
        long headerLength = WebServiceCommonHelper.calculateHeaderLength(httpResponse);
        ResponseObject responseObject = new ResponseObject();
        responseObject.setContentType(this.getResponseContentType(httpResponse));
        responseObject.setContentDisposition(this.getResponseContentDisposition(httpResponse));
        responseObject.setHeaderFields(this.getResponseHeaderFields(httpResponse));
        responseObject.setStatusCode(statusCode);
        responseObject.setResponseBodySize(bodyLength);
        responseObject.setResponseHeaderSize(headerLength);
        responseObject.setContentDownloadTime(contentDownloadTime);
        this.setResponseBodyContent(httpResponse, responseData, responseObject);
        return responseObject;
    }

    protected void setResponseBodyContent(HttpResponse httpResponse, byte[] responseData, ResponseObject responseObject) {
        String contentTypeHeader;
        String contentType = contentTypeHeader = this.getResponseContentType(httpResponse);
        String charset = "UTF-8";
        if (contentTypeHeader != null && contentTypeHeader.contains(";")) {
            contentType = contentTypeHeader.split(";")[0].trim();
            int charsetIdx = contentTypeHeader.lastIndexOf("charset=");
            if (charsetIdx >= 0) {
                int separatorIdx = StringUtils.indexOf((CharSequence)contentTypeHeader, (CharSequence)";", (int)charsetIdx);
                if (separatorIdx < 0) {
                    separatorIdx = contentTypeHeader.length();
                }
                charset = contentTypeHeader.substring(charsetIdx + "charset=".length(), separatorIdx).trim().replace("\"", "");
            }
        }
        if (responseData == null || responseData.length == 0) {
            HttpTextBodyContent emptyBodyContent = new HttpTextBodyContent("", charset, contentType);
            responseObject.setBodyContent((HttpBodyContent)emptyBodyContent);
            responseObject.setContentCharset(charset);
            return;
        }
        if (MimeTypeUtil.isTextContentType((String)contentType)) {
            try {
                String responseText = new String(responseData, charset);
                HttpTextBodyContent textBodyContent = new HttpTextBodyContent(responseText, charset, contentType);
                responseObject.setBodyContent((HttpBodyContent)textBodyContent);
                responseObject.setContentCharset(charset);
                return;
            }
            catch (Exception e) {
                this.logger.logWarning(String.format("Ignored. Failed to convert response body content to text using Content-Type \"%s\" and charset \"%s\"", contentType, charset), null, (Throwable)e);
            }
        }
        HttpBinaryBodyContent binaryBodyContent = new HttpBinaryBodyContent(responseData, contentType);
        responseObject.setBodyContent((HttpBodyContent)binaryBodyContent);
        responseObject.setContentCharset(null);
    }

    protected String getResponseContentType(HttpResponse httpResponse) {
        Header contentTypeHeader = httpResponse.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            return contentTypeHeader.getValue();
        }
        return null;
    }

    protected String getResponseContentDisposition(HttpResponse httpResponse) {
        Header contentTypeHeader = httpResponse.getFirstHeader("Content-Disposition");
        if (contentTypeHeader != null) {
            return contentTypeHeader.getValue();
        }
        return null;
    }

    protected Map<String, List<String>> getResponseHeaderFields(HttpResponse httpResponse) {
        Header[] headers;
        HashMap<String, List<String>> headerFields = new HashMap<String, List<String>>();
        Header[] headerArray = headers = httpResponse.getAllHeaders();
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            String name = header.getName();
            if (!headerFields.containsKey(name)) {
                headerFields.put(name, new ArrayList());
            }
            ((List)headerFields.get(name)).add(header.getValue());
            ++n2;
        }
        StatusLine statusLine = httpResponse.getStatusLine();
        if (statusLine != null) {
            headerFields.put("#status#", Arrays.asList(String.valueOf(statusLine)));
        }
        return headerFields;
    }

    public WebServiceSettingStore getSettingStore() {
        if (this.settingStore == null) {
            this.settingStore = WebServiceSettingStore.create(this.projectDir);
        }
        return this.settingStore;
    }

    public void setSettingStore(WebServiceSettingStore store) {
        this.settingStore = store;
    }
}

