/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.wsdl.support.wsdl;

import com.ibm.wsdl.BindingImpl;
import com.ibm.wsdl.BindingOperationImpl;
import com.ibm.wsdl.PortImpl;
import com.ibm.wsdl.ServiceImpl;
import com.ibm.wsdl.extensions.http.HTTPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap12.SOAP12BindingImpl;
import com.kms.katalon.core.webservice.helper.SafeHelper;
import com.kms.katalon.core.webservice.helper.XmlHelper;
import com.kms.katalon.core.webservice.wsdl.support.wsdl.WsdlDefinitionLocator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.http.HTTPOperation;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WsdlParser {
    private static final String THIS_NAMESPACE = "tns";
    private static final String SOAP_HEADER_ACTION = "SOAPAction";
    private static final String SOAP = "SOAP";
    private static final String SOAP12 = "SOAP12";
    private static final String GET = "GET";
    private static final String POST = "POST";
    private Definition definition;
    private Map<String, PortImpl> portMap;
    private WSDLLocator wsdlLocator;

    public WsdlParser(WsdlDefinitionLocator locator) {
        this.wsdlLocator = locator;
    }

    public Definition getDefinition() throws WSDLException {
        if (this.definition != null) {
            return this.definition;
        }
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLReader reader = factory.newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("javax.wsdl.importDocuments", true);
        this.definition = reader.readWSDL(this.wsdlLocator);
        return this.definition;
    }

    public List<QName> getServiceNames() throws WSDLException {
        return new ArrayList<QName>(this.getDefinition().getServices().keySet());
    }

    public List<PortImpl> getPorts() throws WSDLException {
        ServiceImpl service = this.getService();
        if (service == null) {
            return Collections.emptyList();
        }
        Collection ports = service.getPorts().values();
        if (ports.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<PortImpl>(ports);
    }

    public ServiceImpl getService() throws WSDLException {
        Collection services = this.getDefinition().getAllServices().values();
        if (services.isEmpty()) {
            return null;
        }
        return (ServiceImpl)new ArrayList(services).get(0);
    }

    public PortImpl getPortByRequestMethod(String requestMethod) throws WSDLException {
        return this.getPortMap().get(requestMethod);
    }

    public List<BindingImpl> getBindings() throws WSDLException {
        return new ArrayList<BindingImpl>(this.getDefinition().getAllBindings().values());
    }

    public List<QName> getBindingNames() throws WSDLException {
        return new ArrayList<QName>(this.getDefinition().getAllBindings().keySet());
    }

    public Binding getBindingByName(QName bindingName) throws WSDLException {
        return this.getDefinition().getBinding(bindingName);
    }

    public BindingImpl getBindingByRequestMethod(String requestMethod) throws WSDLException {
        PortImpl port = this.getPortByRequestMethod(requestMethod);
        return (BindingImpl)port.getBinding();
    }

    public List<String> getOperationNamesByRequestMethod(String requestMethod) throws WSDLException {
        ArrayList<String> operationNames = new ArrayList<String>();
        this.getOperationsByRequestMethod(requestMethod).forEach(o -> {
            boolean bl = operationNames.add(o.getName());
        });
        return operationNames;
    }

    public List<Operation> getOperationsByRequestMethod(String requestMethod) throws WSDLException {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        this.getBindingOperationsByRequestMethod(requestMethod).forEach(o -> {
            boolean bl = operations.add(o.getOperation());
        });
        return operations;
    }

    public BindingOperationImpl getBindingOperationByRequestMethodAndName(String requestMethod, String name) throws WSDLException {
        if (StringUtils.isBlank((CharSequence)requestMethod) || StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return this.getBindingOperationsByRequestMethod(requestMethod).stream().filter(bo -> name.equals(bo.getName())).findAny().orElse(null);
    }

    public List<BindingOperationImpl> getBindingOperationsByRequestMethod(String requestMethod) throws WSDLException {
        PortImpl port = this.getPortMap().get(requestMethod);
        if (port == null) {
            return Collections.emptyList();
        }
        ArrayList<BindingOperationImpl> bindingOperations = new ArrayList<BindingOperationImpl>();
        bindingOperations.addAll(port.getBinding().getBindingOperations());
        return bindingOperations;
    }

    public Operation getOperationByRequestMethodNName(String requestMethod, String operationName) throws WSDLException {
        return this.getOperationsByRequestMethod(requestMethod).stream().filter(o -> o.getName().equals(operationName)).findFirst().get();
    }

    public String getOperationURI(BindingOperationImpl bindingOperation, String requestMethod) {
        if (bindingOperation == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)requestMethod)) {
            return null;
        }
        List extensibilityElements = bindingOperation.getExtensibilityElements();
        switch (requestMethod.toUpperCase()) {
            case "SOAP": {
                SOAPOperation operation = WsdlParser.getExtensiblityElement(extensibilityElements, SOAPOperation.class);
                return operation.getSoapActionURI();
            }
            case "SOAP12": {
                SOAP12Operation operation = WsdlParser.getExtensiblityElement(extensibilityElements, SOAP12Operation.class);
                return operation.getSoapActionURI();
            }
            case "GET": 
            case "POST": {
                HTTPOperation operation = WsdlParser.getExtensiblityElement(extensibilityElements, HTTPOperation.class);
                return operation.getLocationURI();
            }
        }
        return null;
    }

    public String getPortAddressLocation(String requestMethod) throws WSDLException {
        if (StringUtils.isBlank((CharSequence)requestMethod)) {
            return null;
        }
        PortImpl port = this.getPortByRequestMethod(requestMethod);
        if (port == null) {
            return null;
        }
        List extensibilityElements = port.getExtensibilityElements();
        switch (requestMethod.toUpperCase()) {
            case "SOAP": {
                SOAPAddress address = WsdlParser.getExtensiblityElement(extensibilityElements, SOAPAddress.class);
                return address.getLocationURI();
            }
            case "SOAP12": {
                SOAP12Address address = WsdlParser.getExtensiblityElement(extensibilityElements, SOAP12Address.class);
                return address.getLocationURI();
            }
        }
        HTTPAddress address = WsdlParser.getExtensiblityElement(extensibilityElements, HTTPAddress.class);
        return address.getLocationURI();
    }

    public Map<String, PortImpl> getPortMap() throws WSDLException {
        if (this.portMap == null) {
            this.portMap = new HashMap<String, PortImpl>();
            for (PortImpl p : this.getPorts()) {
                Object binding = WsdlParser.getBindingObject(p.getBinding());
                if (binding == null) continue;
                if (binding instanceof SOAPBindingImpl) {
                    this.portMap.put(SOAP, p);
                    continue;
                }
                if (binding instanceof SOAP12BindingImpl) {
                    this.portMap.put(SOAP12, p);
                    continue;
                }
                if (!(binding instanceof HTTPBindingImpl)) continue;
                this.portMap.put(((HTTPBindingImpl)binding).getVerb().toUpperCase(), p);
            }
        }
        return this.portMap;
    }

    private static Object getBindingObject(Binding binding) {
        List extensibilityElements = binding.getExtensibilityElements();
        SOAPBinding objBinding = WsdlParser.getExtensiblityElement(extensibilityElements, SOAPBinding.class);
        if (objBinding == null) {
            objBinding = WsdlParser.getExtensiblityElement(extensibilityElements, SOAP12Binding.class);
        }
        if (objBinding == null) {
            objBinding = WsdlParser.getExtensiblityElement(extensibilityElements, HTTPBinding.class);
        }
        return objBinding;
    }

    public static <T extends ExtensibilityElement> T getExtensiblityElement(List<?> list, Class<T> clazz) {
        List<T> elements = WsdlParser.getExtensiblityElements(list, clazz);
        return (T)(elements.isEmpty() ? null : (ExtensibilityElement)elements.get(0));
    }

    public static <T extends ExtensibilityElement> List<T> getExtensiblityElements(List list, Class<T> clazz) {
        ArrayList<ExtensibilityElement> result = new ArrayList<ExtensibilityElement>();
        for (ExtensibilityElement elm : list) {
            if (!clazz.isAssignableFrom(elm.getClass())) continue;
            result.add(elm);
        }
        return result;
    }

    private Map<String, List<String>> getParamMap() {
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        try {
            List<String> operationNames = this.getOperationNamesByRequestMethod(SOAP);
            Types types = this.getDefinition().getTypes();
            for (Object obj : SafeHelper.safeList(types.getExtensibilityElements())) {
                Schema schema;
                NodeList nodeList;
                if (obj == null || !(obj instanceof Schema) || (nodeList = (schema = (Schema)obj).getElement().getChildNodes()) == null) continue;
                for (String name : operationNames) {
                    if (StringUtils.isEmpty((CharSequence)name)) continue;
                    List params = XmlHelper.wrapNodeList(nodeList).stream().filter(a -> a.getNodeType() == 1).filter(a -> {
                        Node node = a.getAttributes().getNamedItem("name");
                        return node != null && node.getNodeValue().equals(name);
                    }).flatMap(WsdlParser::flatten).filter(a -> a.getNodeType() == 1).filter(a -> a.getAttributes().getNamedItem("name") != null).filter(a -> !a.getAttributes().getNamedItem("name").getNodeValue().equals(name)).map(a -> a.getAttributes().getNamedItem("name").getNodeValue()).filter(a -> a != null).collect(Collectors.toList());
                    paramMap.put(name, params);
                }
            }
            return paramMap;
        }
        catch (Exception exception) {
            return Collections.emptyMap();
        }
    }

    private static Stream<Node> flatten(Node node) {
        return Stream.concat(Stream.of(node), XmlHelper.wrapNodeList(node.getChildNodes()).stream().flatMap(WsdlParser::flatten));
    }
}

