/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.windows.driver;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.network.apache.services.ApacheHttpClient;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import net.lingala.zip4j.ZipFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;

public class FlaUIDriverManager {
    private static String LOCALHOST = "127.0.0.1";
    private static int PREFERRED_PORT = 4723;
    private static int SESSION_CLEANUP_INTERVAL_IN_SECONDS = 300;
    private static String LOG_FOLDER = "logs";
    private static final long LOG_RETENTION_DAYS = 3L;
    private String driverPath;
    private FlaUIServer localServer;
    public static final FlaUIDriverManager singleton = new FlaUIDriverManager();

    static {
        try {
            singleton.setDriverPath(FlaUIDriverManager.resolveDriverPath());
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)"Failed to resolve FlaUI.WebDriver's path");
        }
    }

    private static String resolveDriverPath() throws IOException {
        Path relativeDirPath = Path.of("resources", "extensions", "FlaUIWebDriver");
        Path relativeExeFilePath = relativeDirPath.resolve("FlaUI.WebDriver.exe");
        Path relativeZipFilePath = relativeDirPath.resolve("FlaUI.WebDriver.zip");
        String fullExeFilePath = FlaUIDriverManager.resolveFilePath(relativeExeFilePath.toString());
        if (Files.exists(Paths.get(fullExeFilePath, new String[0]), new LinkOption[0])) {
            return fullExeFilePath;
        }
        String fullZipFilePath = FlaUIDriverManager.resolveFilePath(relativeZipFilePath.toString());
        LogUtil.logInfo((String)("FlaUI: extract zip file: " + fullZipFilePath));
        Throwable throwable = null;
        Object var6_7 = null;
        try (ZipFile zipFile = new ZipFile(fullZipFilePath);){
            zipFile.extractAll(Paths.get(fullExeFilePath, new String[0]).getParent().toAbsolutePath().toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return fullExeFilePath;
    }

    private static String resolveFilePath(String relativePath) {
        try {
            String currentPath = FlaUIDriverManager.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            if (currentPath.endsWith("jar")) {
                String configurationFolderPath = new File(FileLocator.resolve((URL)Platform.getConfigurationLocation().getURL()).getFile()).toString();
                return Paths.get(configurationFolderPath, relativePath).toAbsolutePath().toString();
            }
            File file = new File(currentPath + relativePath);
            return file.getAbsolutePath();
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)("Failed to resolve relativePath: " + relativePath));
            return null;
        }
    }

    public static FlaUIDriverManager getInstance() {
        return singleton;
    }

    private FlaUIDriverManager() {
    }

    public void setDriverPath(String driverPath) {
        LogUtil.logInfo((String)("FlaUI.WebDriver's path: " + driverPath));
        this.driverPath = driverPath;
    }

    private void setLocalServer(FlaUIServer server) {
        this.localServer = server;
    }

    public boolean checkIfServerReady(FlaUIServer server, ProxyConfig proxyConfig) {
        if (server == null) {
            return false;
        }
        if (server.process != null && !server.process.isAlive()) {
            return false;
        }
        try {
            ApacheHttpClient httpClient = new ApacheHttpClient();
            HashMap headers = new HashMap();
            HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).proxy(proxyConfig).connectTimeout(Integer.valueOf(10000)).socketTimeout(Integer.valueOf(10000)).build();
            URI uri = new URI(server.getServerUrl() + "/status");
            HttpResponse response = httpClient.get(uri, httpOptions);
            String rawResponse = response.getBody();
            JsonObject jsonResponse = JsonParser.parseString((String)rawResponse).getAsJsonObject();
            boolean isReady = jsonResponse.getAsJsonObject("value").get("ready").getAsBoolean();
            if (!isReady) {
                LogUtil.logInfo((String)("FlaUI server is not ready yet. Response = " + rawResponse));
                return false;
            }
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)"Failed to check FlaUI server status");
            return false;
        }
        return true;
    }

    private boolean waitUntilServerReady(FlaUIServer server, ProxyConfig proxyConfig) {
        int maxRetries = 10;
        int i = 0;
        while (i < maxRetries) {
            if (this.checkIfServerReady(server, proxyConfig)) {
                return true;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public FlaUIServer startLocalServer(StartMode mode, ProxyConfig proxyConfig) {
        if (mode == StartMode.ONLY_START_IF_NOT_HEALTHY) {
            if (this.checkIfServerReady(this.localServer, proxyConfig)) {
                LogUtil.logInfo((String)("FlaUI driver is running at " + this.localServer.getServerUrl()));
                return this.localServer;
            }
            this.stopLocalServer();
        }
        if (mode == StartMode.FORCE_RESTART) {
            this.stopLocalServer();
        }
        int portFrom = PREFERRED_PORT;
        int portTo = PREFERRED_PORT + 5;
        int port = portFrom;
        while (port < portTo) {
            if (!this.isPortBusy(port)) {
                LogUtil.logInfo((String)("Attempt to start FlaUI driver at port " + port));
                FlaUIServer server = this.attemptToStartServerWithPort(port, proxyConfig);
                if (server != null) {
                    this.setLocalServer(server);
                    LogUtil.logInfo((String)("FlaUI driver is started at " + server.getServerUrl()));
                    return server;
                }
            }
            ++port;
        }
        LogUtil.logInfo((String)"Failed to start FlaUI driver");
        return null;
    }

    private boolean isPortBusy(int port) {
        block12: {
            Throwable throwable = null;
            Object var3_4 = null;
            Socket socket = new Socket(LOCALHOST, port);
            try {
                socket.close();
                if (socket == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (Exception exception) {
                    return false;
                }
            }
            socket.close();
        }
        return true;
    }

    private FlaUIServer attemptToStartServerWithPort(int port, ProxyConfig proxyConfig) {
        FlaUIServer server;
        block5: {
            String host = LOCALHOST;
            ProcessBuilder processBuilder = new ProcessBuilder(this.driverPath, "--urls=http://" + host + ":" + port, "--environment=Production", "--SessionCleanup:SchedulingIntervalSeconds=" + SESSION_CLEANUP_INTERVAL_IN_SECONDS);
            processBuilder.redirectErrorStream(true);
            try {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss_SSS");
                String timestamp = LocalDateTime.now().format(formatter);
                String logFileName = "flaui_" + timestamp + ".log";
                File logFile = new File(LOG_FOLDER, logFileName);
                logFile.getParentFile().mkdirs();
                processBuilder.redirectOutput(ProcessBuilder.Redirect.to(logFile));
                LogUtil.logInfo((String)("FlaUI's log will be redirected to log file: " + logFile.getAbsolutePath()));
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e, (String)"Failed to redirect FlaUI's log to file");
            }
            try {
                Process process = processBuilder.start();
                Runtime.getRuntime().addShutdownHook(new Thread(() -> this.safelyDestroyProcess(process)));
                server = new FlaUIServer(host, port, process);
                boolean isReady = this.waitUntilServerReady(server, proxyConfig);
                if (isReady) break block5;
                this.safelyDestroyProcess(process);
                return null;
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e, (String)"Failed to start FlaUI driver");
                return null;
            }
        }
        return server;
    }

    public void stopLocalServer() {
        if (this.localServer == null) {
            return;
        }
        this.safelyDestroyProcess(this.localServer.process);
        LogUtil.logInfo((String)("FlaUI driver has stopped at " + this.localServer.getServerUrl()));
        this.localServer = null;
        try {
            this.deleteOldLogFiles();
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)"Failed to delete old log files");
        }
    }

    private void safelyDestroyProcess(Process process) {
        if (process == null) {
            return;
        }
        if (process.isAlive()) {
            try {
                process.destroyForcibly();
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e, (String)("Failed to force kill FlaUI driver with PID: " + String.valueOf(process.pid())));
            }
        }
    }

    private void deleteOldLogFiles() {
        File logDir = new File(LOG_FOLDER);
        if (!logDir.exists() || !logDir.isDirectory()) {
            return;
        }
        File[] files = logDir.listFiles((dir, name) -> name.startsWith("flaui") && name.endsWith(".log"));
        if (files == null) {
            return;
        }
        long cutoff = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(3L);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.lastModified() < cutoff) {
                try {
                    Files.deleteIfExists(file.toPath());
                    LogUtil.logInfo((String)("Deleted old log file: " + file.getAbsolutePath()));
                }
                catch (IOException e) {
                    LogUtil.logError((Throwable)e, (String)("Failed to delete old log file: " + file.getAbsolutePath()));
                }
            }
            ++n2;
        }
    }

    public static class FlaUIServer {
        private Process process;
        private String host;
        private int port;

        public FlaUIServer(String host, int port, Process process) {
            this.host = host;
            this.port = port;
            this.process = process;
        }

        public String getServerUrl() {
            return "http://" + this.host + ":" + this.port;
        }

        public boolean isSpanwedByKs() {
            return this.process != null;
        }
    }

    public static enum StartMode {
        ONLY_START_IF_NOT_HEALTHY,
        FORCE_RESTART;

    }
}

