/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.components;

import com.kms.katalon.composer.components.impl.dialogs.DatabaseConnectionAbstractDialog;
import com.kms.katalon.composer.components.impl.providers.ConnectionPropertyColumnLabelProvider;
import com.kms.katalon.composer.components.impl.support.ConnectionPropertyEditingSupport;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.core.db.ConnectionProperty;
import com.kms.katalon.core.db.DBConnectionProperties;
import com.kms.katalon.core.webui.util.OSUtil;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ConnectionPropertyTable {
    private ToolItem tltmAddProperty;
    private ToolItem tltmRemoveProperty;
    private ToolItem tltmClearProperties;
    protected TableViewer properiesTableViewer;
    protected List<ConnectionProperty> listConnectionPropeties = new ArrayList<ConnectionProperty>();
    private Composite tableComposite;
    private Label lblConnectionProperties;
    private DatabaseConnectionAbstractDialog abstractDialog;
    private Shell shell;

    public ConnectionPropertyTable(DatabaseConnectionAbstractDialog dialog, Shell shell) {
        this.abstractDialog = dialog;
        this.shell = shell;
    }

    public ConnectionPropertyTable(Shell shell) {
        this.shell = shell;
    }

    public void setLabelBold() {
        ControlUtils.setFontToBeBold((Control)this.lblConnectionProperties);
    }

    public void createContent(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginRight = 5;
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite lblComposite = new Composite(mainComposite, 0);
        GridLayout lblLayout = new GridLayout(2, false);
        lblLayout.marginWidth = 0;
        lblComposite.setLayout((Layout)lblLayout);
        lblComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.lblConnectionProperties = new Label(lblComposite, 0);
        this.lblConnectionProperties.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.lblConnectionProperties.setText("Set Connection Properties for JDBC Driver");
        Label separator = new Label(lblComposite, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.createToolBar(mainComposite);
        this.createTableViewerColumn();
        this.createToolItemListeners();
    }

    private int calcMarginLeft() {
        int res = Toolkit.getDefaultToolkit().getScreenResolution();
        double scale = (double)res / 96.0;
        if (scale == 1.25) {
            return 15;
        }
        if (scale == 1.5) {
            return 35;
        }
        return 0;
    }

    private void createToolBar(Composite mainComposite) {
        Composite propertiesComposite = new Composite(mainComposite, 0);
        GridLayout propertiesLayout = new GridLayout(2, false);
        propertiesLayout.marginWidth = 0;
        propertiesComposite.setLayout((Layout)propertiesLayout);
        propertiesComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite emptyComposite = new Composite(propertiesComposite, 0);
        GridLayout emptyLayout = new GridLayout(1, false);
        emptyLayout.marginWidth = 0;
        emptyComposite.setLayout((Layout)emptyLayout);
        emptyComposite.setLayoutData((Object)new GridData(88, 10));
        new Label(emptyComposite, 0);
        this.tableComposite = new Composite(propertiesComposite, 0);
        GridLayout tableLayout = new GridLayout(1, false);
        tableLayout.marginWidth = 0;
        tableLayout.marginLeft = this.calcMarginLeft();
        this.tableComposite.setLayout((Layout)tableLayout);
        this.tableComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite compositeToolbar = new Composite(this.tableComposite, 0);
        compositeToolbar.setLayout((Layout)new FillLayout(256));
        compositeToolbar.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        ToolBar toolBar = new ToolBar(compositeToolbar, 0x820000);
        toolBar.setForeground(ColorUtil.getToolBarForegroundColor());
        this.tltmAddProperty = new ToolItem(toolBar, 0);
        this.tltmAddProperty.setText(GlobalMessageConstants.ADD);
        this.tltmAddProperty.setImage(ImageManager.getImage((String)"add_16.png"));
        this.tltmRemoveProperty = new ToolItem(toolBar, 0);
        this.tltmRemoveProperty.setText(GlobalMessageConstants.REMOVE);
        this.tltmRemoveProperty.setImage(ImageManager.getImage((String)"delete_16.png"));
        this.tltmClearProperties = new ToolItem(toolBar, 0);
        this.tltmClearProperties.setText(GlobalMessageConstants.CLEAR);
        this.tltmClearProperties.setImage(ImageManager.getImage((String)"delete_16.png"));
    }

    private void createTableViewerColumn() {
        Composite tableConnectionPropertiesComposite = new Composite(this.tableComposite, 0);
        GridData ldTableComposite = new GridData(4, 4, true, true, 1, 1);
        ldTableComposite.minimumHeight = 100;
        tableConnectionPropertiesComposite.setLayoutData((Object)ldTableComposite);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableConnectionPropertiesComposite.setLayout((Layout)tableColumnLayout);
        this.properiesTableViewer = new TableViewer(tableConnectionPropertiesComposite, 68114);
        this.properiesTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table table = this.properiesTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(ControlUtils.shouldLineVisble(table.getDisplay()));
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableViewerColumn tvcKey = new TableViewerColumn(this.properiesTableViewer, 0);
        TableColumn nameClm = tvcKey.getColumn();
        nameClm.setText(GlobalMessageConstants.NAME);
        tvcKey.setEditingSupport((EditingSupport)new ConnectionPropertyEditingSupport(this.properiesTableViewer, GlobalMessageConstants.NAME, this));
        tvcKey.setLabelProvider((CellLabelProvider)new ConnectionPropertyColumnLabelProvider(GlobalMessageConstants.NAME));
        TableViewerColumn tvcValue = new TableViewerColumn(this.properiesTableViewer, 0);
        TableColumn valueClm = tvcValue.getColumn();
        valueClm.setText(GlobalMessageConstants.VALUE);
        tvcValue.setLabelProvider((CellLabelProvider)new ConnectionPropertyColumnLabelProvider(GlobalMessageConstants.VALUE));
        tvcValue.setEditingSupport((EditingSupport)new ConnectionPropertyEditingSupport(this.properiesTableViewer, GlobalMessageConstants.VALUE, this));
        tableColumnLayout.setColumnData((Widget)nameClm, (ColumnLayoutData)new ColumnWeightData(20, 100));
        tableColumnLayout.setColumnData((Widget)valueClm, (ColumnLayoutData)new ColumnWeightData(40, 100));
    }

    private void createToolItemListeners() {
        this.tltmAddProperty.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ConnectionPropertyTable.this.addProperty();
                ConnectionPropertyTable.this.setChanged();
            }
        });
        this.tltmRemoveProperty.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ConnectionPropertyTable.this.removeProperty();
                ConnectionPropertyTable.this.setChanged();
            }
        });
        this.tltmClearProperties.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ConnectionPropertyTable.this.clearProperties();
                ConnectionPropertyTable.this.setChanged();
            }
        });
    }

    private void setChanged() {
        if (this.abstractDialog != null) {
            this.abstractDialog.setChanged();
        }
    }

    private void addProperty() {
        this.listConnectionPropeties.add(new ConnectionProperty(this.generateNewPropertyName(), ""));
        this.properiesTableViewer.refresh();
    }

    private void removeProperty() {
        IStructuredSelection selection = (IStructuredSelection)this.properiesTableViewer.getSelection();
        if (!selection.isEmpty()) {
            for (Object selectedObject : selection.toList()) {
                if (!(selectedObject instanceof ConnectionProperty)) continue;
                ConnectionProperty selectedCustomRunConfig = (ConnectionProperty)selectedObject;
                this.listConnectionPropeties.remove(selectedCustomRunConfig);
            }
            this.properiesTableViewer.refresh();
        }
    }

    private boolean isUniquePropName(String name) {
        for (ConnectionProperty prop : this.listConnectionPropeties) {
            if (!prop.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    private String generateNewPropertyName() {
        String name = "property";
        int index = 0;
        boolean isUnique = false;
        Object newName = name;
        while (!isUnique) {
            if (this.isUniquePropName((String)newName)) {
                isUnique = true;
                continue;
            }
            newName = name + "_" + index;
            ++index;
        }
        return newName;
    }

    private void clearProperties() {
        this.listConnectionPropeties.clear();
        this.properiesTableViewer.refresh();
    }

    public Composite getTableComposite() {
        return this.tableComposite;
    }

    public Properties getConnectionProperties() {
        return DBConnectionProperties.convertListToProperties(this.listConnectionPropeties);
    }

    public void enableConnectionPropertiesArea(boolean enabled) {
        this.tltmAddProperty.setEnabled(enabled);
        this.tltmRemoveProperty.setEnabled(enabled);
        this.tltmClearProperties.setEnabled(enabled);
        this.properiesTableViewer.getTable().setEnabled(enabled);
    }

    public List<ConnectionProperty> getListConnectionPropeties() {
        return this.listConnectionPropeties;
    }

    public void setListConnectionPropeties(List<ConnectionProperty> listConnectionPropeties) {
        this.listConnectionPropeties = listConnectionPropeties;
    }

    public void setTableInput(List<ConnectionProperty> listConnectionPropeties) {
        this.listConnectionPropeties = listConnectionPropeties;
        this.properiesTableViewer.setInput(listConnectionPropeties);
    }

    public void redrawTable() {
        if (OSUtil.isMacBigSurOrLater()) {
            this.properiesTableViewer.getTable().redraw();
        }
    }

    public Shell getShell() {
        return this.shell;
    }
}

