/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.control;

import com.kms.katalon.composer.components.impl.control.HotkeyActiveListener;
import com.kms.katalon.composer.components.impl.handler.WorkbenchUtilizer;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class CMenu
extends Menu {
    private Map<String, String> keyStrokeActionMap = new HashMap<String, String>();
    private HotkeyActiveListener listener;

    public CMenu(Control parent, HotkeyActiveListener listener) {
        super(parent);
        this.listener = listener;
        this.addControlListeners(parent);
    }

    private void addControlListeners(Control parent) {
        new WorkbenchUtilizer();
        final EBindingService bindingService = WorkbenchUtilizer.getService(EBindingService.class);
        parent.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                String hotkey = KeyStroke.getInstance((int)e.stateMask, (int)e.keyCode).format().toLowerCase();
                if (CMenu.this.keyStrokeActionMap.containsKey(hotkey)) {
                    CMenu.this.listener.executeAction(CMenu.this.keyStrokeActionMap.get(hotkey));
                }
            }
        });
        parent.addFocusListener(new FocusListener(){
            private Collection<Binding> oldContext;

            public void focusLost(FocusEvent e) {
                for (Binding oldBinding : this.oldContext) {
                    bindingService.activateBinding(oldBinding);
                }
                this.oldContext.clear();
            }

            public void focusGained(FocusEvent e) {
                this.oldContext = new ArrayList<Binding>();
                for (Binding oldBinding : bindingService.getActiveBindings()) {
                    if (!CMenu.this.keyStrokeActionMap.containsKey(oldBinding.getTriggerSequence().format().toLowerCase())) continue;
                    this.oldContext.add(oldBinding);
                    bindingService.deactivateBinding(oldBinding);
                }
            }
        });
    }

    public MenuItem createMenuItem(String name, String hotkey) {
        return this.createMenuItem(name, hotkey, null, 8);
    }

    public MenuItem createMenuItem(String name, String hotkey, Callable<Boolean> enableWhen) {
        return this.createMenuItem(name, hotkey, enableWhen, 8);
    }

    public MenuItem createMenuItem(String name, String hotkey, Callable<Boolean> enableWhen, int menuItemType) {
        block3: {
            try {
                if (name != null) break block3;
                return null;
            }
            catch (ParseException e) {
                LoggerSingleton.logError((Throwable)e);
                return null;
            }
        }
        MenuItem menuItem = new MenuItem((Menu)this, menuItemType);
        this.handleItemSelected(name, menuItem);
        this.handleItemEnable(enableWhen, menuItem);
        String formattedHotkey = StringUtils.isNotEmpty((String)hotkey) ? KeyStroke.getInstance((String)hotkey).format() : "";
        menuItem.setText(this.createMenuItemText(name, formattedHotkey));
        this.registerHotkey(name, menuItem, formattedHotkey);
        return menuItem;
    }

    public MenuItem createMenuItemWithoutSelectionListener(String name, String hotkey, Callable<Boolean> enableWhen, int menuItemType) {
        block3: {
            try {
                if (name != null) break block3;
                return null;
            }
            catch (ParseException e) {
                LoggerSingleton.logError((Throwable)e);
                return null;
            }
        }
        MenuItem menuItem = new MenuItem((Menu)this, menuItemType);
        this.handleItemEnable(enableWhen, menuItem);
        String formattedHotkey = StringUtils.isNotEmpty((String)hotkey) ? KeyStroke.getInstance((String)hotkey).format() : "";
        menuItem.setText(this.createMenuItemText(name, formattedHotkey));
        this.registerHotkey(name, menuItem, formattedHotkey);
        return menuItem;
    }

    private void handleItemSelected(final String name, MenuItem menuItem) {
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CMenu.this.listener.executeAction(name);
            }
        });
    }

    private void handleItemEnable(final Callable<Boolean> visibleWhen, final MenuItem menuItem) {
        if (visibleWhen != null) {
            this.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    try {
                        if (menuItem.isDisposed()) {
                            return;
                        }
                        menuItem.setEnabled(((Boolean)visibleWhen.call()).booleanValue());
                    }
                    catch (Exception ex) {
                        LoggerSingleton.logError((Throwable)ex);
                    }
                }
            });
        }
    }

    private void registerHotkey(String name, MenuItem menuItem, String formattedHotkey) {
        if (!StringUtils.isEmpty((String)formattedHotkey)) {
            final String hotkeyAsId = formattedHotkey.toLowerCase();
            this.keyStrokeActionMap.put(hotkeyAsId, name);
            menuItem.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    CMenu.this.keyStrokeActionMap.remove(hotkeyAsId);
                }
            });
        }
    }

    private String createMenuItemText(String name, String hotkey) {
        if (StringUtils.isEmpty((String)hotkey)) {
            return name;
        }
        return name + "\t" + hotkey;
    }

    protected void checkSubclass() {
    }
}

