/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.dialogs;

import com.kms.katalon.composer.components.impl.constants.StringConstants;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddMailRecipientDialog
extends Dialog {
    private Text text;
    private ControlDecoration controlDecoration;
    private static final String EMAIL_TEXT_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private Pattern pattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
    private Set<String> emails = new LinkedHashSet<String>();
    private String[] existedEmails;

    public AddMailRecipientDialog(Shell parentShell, String[] existedEmails) {
        super(parentShell);
        if (existedEmails != null) {
            Arrays.sort(existedEmails);
            this.existedEmails = existedEmails;
        } else {
            this.existedEmails = new String[0];
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)container.getLayout();
        gridLayout.horizontalSpacing = 20;
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 5;
        Label lblNewLabel = new Label(container, 0);
        lblNewLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel.setText(StringConstants.DIA_LBL_EMAIL);
        this.text = new Text(container, 2048);
        GridData gd_text = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_text.heightHint = 18;
        this.text.setLayoutData((Object)gd_text);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddMailRecipientDialog.this.validateEmail();
            }
        });
        this.controlDecoration = new ControlDecoration((Control)this.text, 16512);
        Image imgInfo = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage();
        this.controlDecoration.setImage(imgInfo);
        this.controlDecoration.show();
        this.controlDecoration.setShowHover(true);
        this.controlDecoration.setDescriptionText(StringConstants.DIA_DESC_PLS_ENTER_EMAIL_ADDR);
        return container;
    }

    private void validateEmail() {
        StringBuilder duplicatedEmailBuilder = new StringBuilder();
        String[] stringArray = this.text.getText().replace(" ", "").split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String email = stringArray[n2];
            String emailName = email.trim();
            if (!this.pattern.matcher(emailName).matches() && !emailName.isEmpty()) {
                super.getButton(0).setEnabled(false);
                this.showErrorValidator();
                return;
            }
            if (Arrays.binarySearch(this.existedEmails, emailName) >= 0) {
                if (duplicatedEmailBuilder.length() > 0) {
                    duplicatedEmailBuilder.append(", ");
                }
                duplicatedEmailBuilder.append(emailName);
            }
            ++n2;
        }
        String dupplicatedNames = duplicatedEmailBuilder.toString();
        if (!dupplicatedNames.isEmpty()) {
            super.getButton(0).setEnabled(false);
            this.showDuplicatedValidator(dupplicatedNames);
            return;
        }
        super.getButton(0).setEnabled(true);
        this.controlDecoration.hide();
    }

    private void showErrorValidator() {
        Image imgInfo = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage();
        this.controlDecoration.setImage(imgInfo);
        this.controlDecoration.setShowHover(true);
        this.controlDecoration.setDescriptionText(StringConstants.DIA_DESC_INVALID_EMAIL_ADDR);
        this.controlDecoration.show();
    }

    private void showDuplicatedValidator(String dupplicatedNames) {
        Image imgInfo = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage();
        this.controlDecoration.setImage(imgInfo);
        this.controlDecoration.setShowHover(true);
        this.controlDecoration.setDescriptionText(MessageFormat.format(StringConstants.DIA_DESC_DUPLICATED_EMAIL_ADDR, dupplicatedNames));
        this.controlDecoration.show();
    }

    protected Point getInitialSize() {
        return new Point(400, 150);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(StringConstants.DIA_ADD_EMAIL_RECIPIENT);
    }

    public String[] getEmails() {
        return this.emails.toArray(new String[0]);
    }

    protected void okPressed() {
        String[] stringArray = this.text.getText().replace(" ", "").split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String email = stringArray[n2];
            this.emails.add(email.trim());
            ++n2;
        }
        super.okPressed();
    }
}

