/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.tree;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.transfer.TreeEntityTransfer;
import com.kms.katalon.composer.components.impl.tree.AbstractTreeEntity;
import com.kms.katalon.composer.components.impl.tree.CheckpointTreeEntity;
import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.impl.tree.ReportTreeEntity;
import com.kms.katalon.composer.components.impl.tree.SystemFileTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestDataTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.tree.TooltipPropertyDescription;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;

public class FolderTreeEntity
extends AbstractTreeEntity {
    private static final long serialVersionUID = 2019661366633516087L;
    private boolean isAutoLoadedChildren = true;
    private FolderEntity folder;

    public FolderTreeEntity(FolderEntity folder, ITreeEntity parentTreeEntity) {
        this(folder, parentTreeEntity, true);
    }

    public FolderTreeEntity(FolderEntity folder, ITreeEntity parentTreeEntity, boolean isAutoLoadedChildren) {
        super((FileEntity)folder, parentTreeEntity);
        this.folder = folder;
        this.isAutoLoadedChildren = isAutoLoadedChildren;
    }

    public Object[] getChildren() throws Exception {
        ArrayList<Object> childrenEntities = new ArrayList<Object>();
        if (this.folder.getFolderType() == FolderEntity.FolderType.GENAI) {
            for (FileEntity file : this.folder.getChildrenEntities()) {
                if (!(file instanceof TestCaseEntity)) continue;
                TestCaseEntity tcEntity = (TestCaseEntity)file;
                childrenEntities.add(new TestCaseTreeEntity(tcEntity, (ITreeEntity)this));
            }
        } else if (this.folder.getFolderType() == FolderEntity.FolderType.KEYWORD) {
            for (IPackageFragment packageFragment : GroovyUtil.getAllPackageInFolder((ProjectEntity)this.folder.getProject(), (String)GlobalStringConstants.ROOT_FOLDER_NAME_KEYWORD)) {
                if (!packageFragment.exists()) continue;
                childrenEntities.add(new PackageTreeEntity(packageFragment, this));
            }
        } else if ("OpenAPI Specification".equals(this.folder.getName())) {
            ITreeEntity[] iTreeEntityArray = TreeEntityUtil.getChildren(this, this.isAutoLoadedChildren);
            int n = iTreeEntityArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeEntity child = iTreeEntityArray[n2];
                if (!(child instanceof FolderTreeEntity)) {
                    childrenEntities.add(child);
                }
                ++n2;
            }
        } else if (FolderController.getInstance().isSourceFolder(ProjectController.getInstance().getCurrentProject(), this.folder)) {
            for (IPackageFragment packageFragment : GroovyUtil.getAllPackageInFolder((ProjectEntity)this.folder.getProject(), (String)this.folder.getRelativePath())) {
                if (!packageFragment.exists()) continue;
                childrenEntities.add(new PackageTreeEntity(packageFragment, this));
            }
            ITreeEntity[] iTreeEntityArray = TreeEntityUtil.getChildren(this);
            int n = iTreeEntityArray.length;
            int n3 = 0;
            while (n3 < n) {
                String extension;
                ITreeEntity child = iTreeEntityArray[n3];
                if (child instanceof SystemFileTreeEntity && !(extension = ((SystemFileTreeEntity)child).getObject().getFileExtension()).equals(".groovy") && !extension.equals(".java")) {
                    childrenEntities.add(child);
                }
                ++n3;
            }
        } else {
            childrenEntities.addAll(Arrays.asList(TreeEntityUtil.getChildren(this, this.isAutoLoadedChildren)));
        }
        childrenEntities.sort(new Comparator<ITreeEntity>(){

            @Override
            public int compare(ITreeEntity nodeA, ITreeEntity nodeB) {
                try {
                    if (nodeA instanceof ReportTreeEntity && nodeB instanceof ReportTreeEntity) {
                        ReportEntity reportA = (ReportEntity)nodeA.getObject();
                        ReportEntity reportB = (ReportEntity)nodeB.getObject();
                        Date dateCreatedA = ReportController.getInstance().getReportDate(reportA);
                        Date dateCreatedB = ReportController.getInstance().getReportDate(reportB);
                        return dateCreatedA.compareTo(dateCreatedB);
                    }
                    return StringUtils.compareIgnoreCase((String)nodeA.getText(), (String)nodeB.getText());
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                    return 0;
                }
            }
        });
        return childrenEntities.toArray();
    }

    public boolean hasChildren() throws Exception {
        return true;
    }

    public Image getImage() throws Exception {
        String idForDisplay = this.folder.getIdForDisplay();
        if (StringConstants.ROOT_FOLDER_NAME_TEST_CASE.equals(idForDisplay)) {
            return ImageConstants.IMG_16_FOLDER_TEST_CASE;
        }
        if (StringConstants.ROOT_FOLDER_NAME_TEST_SUITE.equals(idForDisplay)) {
            return ImageConstants.IMG_16_FOLDER_TEST_SUITE;
        }
        if (StringConstants.ROOT_FOLDER_NAME_OBJECT_REPOSITORY.equals(idForDisplay)) {
            return ImageConstants.IMG_16_FOLDER_OBJECT;
        }
        if (StringConstants.ROOT_FOLDER_NAME_DATA_FILE.equals(idForDisplay)) {
            return ImageConstants.IMG_16_FOLDER_DATA;
        }
        if (StringConstants.ROOT_FOLDER_NAME_KEYWORD.equals(idForDisplay)) {
            return ImageConstants.IMG_16_FOLDER_KEYWORD;
        }
        if (StringConstants.ROOT_FOLDER_NAME_REPORT.equals(idForDisplay)) {
            return ImageConstants.IMG_16_FOLDER_REPORT;
        }
        if (StringConstants.ROOT_FOLDER_NAME_CHECKPOINT.equals(idForDisplay)) {
            return ImageConstants.IMG_16_FOLDER_CHECKPOINT;
        }
        if (FolderController.getInstance().isSourceFolder(ProjectController.getInstance().getCurrentProject(), this.folder)) {
            return ImageConstants.IMG_16_FOLDER_SOURCE;
        }
        if (this.folder.getTag().equals("API_Test_Generation")) {
            return ImageConstants.IMG_16_FOLDER_AI_GEN;
        }
        return ImageConstants.IMG_16_FOLDER;
    }

    public String getTypeName() throws Exception {
        return StringConstants.TREE_FOLDER_TYPE_NAME;
    }

    public boolean isRemoveable() throws Exception {
        String idForDisplay = this.folder.getIdForDisplay();
        if (idForDisplay.equals(StringConstants.ROOT_FOLDER_NAME_TEST_CASE) || idForDisplay.equals(StringConstants.ROOT_FOLDER_NAME_TEST_SUITE) || idForDisplay.equals(StringConstants.ROOT_FOLDER_NAME_OBJECT_REPOSITORY) || idForDisplay.equals(StringConstants.ROOT_FOLDER_NAME_DATA_FILE) || idForDisplay.equals(StringConstants.ROOT_FOLDER_NAME_KEYWORD) || idForDisplay.equals(StringConstants.ROOT_FOLDER_NAME_REPORT) || idForDisplay.equals(StringConstants.ROOT_FOLDER_NAME_CHECKPOINT)) {
            return false;
        }
        return !FolderController.getInstance().isAncentorSystemFolder(ProjectController.getInstance().getCurrentProject(), this.getObject());
    }

    public FolderEntity getObject() throws Exception {
        return this.folder;
    }

    public boolean isRenamable() throws Exception {
        if (this.folder.getFolderType() == FolderEntity.FolderType.REPORT) {
            return false;
        }
        return this.isRemoveable();
    }

    public Transfer getEntityTransfer() throws Exception {
        return TreeEntityTransfer.getInstance();
    }

    public String getCopyTag() throws Exception {
        return this.folder.getFolderType().toString();
    }

    @Override
    public void setObject(Object object) throws Exception {
        if (object instanceof FolderEntity) {
            this.entity = (FileEntity)object;
            this.folder = (FolderEntity)object;
        }
    }

    public String getKeyWord() throws Exception {
        switch (this.folder.getFolderType()) {
            case TESTCASE: {
                return "tc";
            }
            case TESTSUITE: {
                return "ts";
            }
            case DATAFILE: {
                return "td";
            }
            case KEYWORD: {
                return "kw";
            }
            case WEBELEMENT: {
                return "ob";
            }
            case REPORT: {
                return "rp";
            }
            case CHECKPOINT: {
                return "cp";
            }
        }
        return "";
    }

    public String[] getSearchTags() throws Exception {
        switch (this.folder.getFolderType()) {
            case TESTCASE: {
                return TestCaseTreeEntity.SEARCH_TAGS;
            }
            case TESTSUITE: {
                return TestSuiteTreeEntity.SEARCH_TAGS;
            }
            case DATAFILE: {
                return TestDataTreeEntity.SEARCH_TAGS;
            }
            case KEYWORD: {
                return KeywordTreeEntity.SEARCH_TAGS;
            }
            case WEBELEMENT: {
                return WebElementTreeEntity.SEARCH_TAGS;
            }
            case REPORT: {
                return ReportTreeEntity.SEARCH_TAGS;
            }
            case CHECKPOINT: {
                return CheckpointTreeEntity.SEARCH_TAGS;
            }
        }
        return null;
    }

    public String getPropertyValue(String key) {
        if (key.equals("name")) {
            return this.folder.getName();
        }
        return "";
    }

    public Image getEntryImage() throws Exception {
        switch (this.folder.getFolderType()) {
            case TESTCASE: {
                return ImageConstants.IMG_16_TEST_CASE;
            }
            case TESTSUITE: {
                return ImageConstants.IMG_16_TEST_SUITE;
            }
            case DATAFILE: {
                return ImageConstants.IMG_16_TEST_DATA;
            }
            case KEYWORD: {
                return ImageConstants.IMG_16_KEYWORD;
            }
            case WEBELEMENT: {
                return ImageConstants.IMG_16_TEST_OBJECT;
            }
            case REPORT: {
                return ImageConstants.IMG_16_REPORT;
            }
            case CHECKPOINT: {
                return ImageConstants.IMG_16_CHECKPOINT;
            }
        }
        return ImageConstants.IMG_16_FOLDER;
    }

    public void loadAllDescentdantEntities() throws Exception {
        FolderController.getInstance().loadAllDescentdantEntities(this.folder);
    }

    @Override
    public List<TooltipPropertyDescription> getTooltipDescriptions() {
        return Collections.emptyList();
    }
}

