/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.tree;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.constants.StringConstants;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.impl.tree.SystemFileTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.tree.TooltipPropertyDescription;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;

public class PackageTreeEntity
implements ITreeEntity {
    private static final long serialVersionUID = 2019661366633516087L;
    private static final String PACKAGE_TYPE_NAME = StringConstants.TREE_PACKAGE_TYPE_NAME;
    public static final String DEFAULT_PACKAGE_LABEL = StringConstants.TREE_PACKAGE_DEFAULT_LBL;
    private IPackageFragment packageFragment;
    private String packageName;
    private boolean isDefaultPackage;
    private ITreeEntity parentTreeEntity;

    public PackageTreeEntity(IPackageFragment packageFragment, ITreeEntity parentTreeEntity) {
        this.packageFragment = packageFragment;
        this.packageName = packageFragment.getElementName();
        this.isDefaultPackage = this.packageName.equals("");
        this.parentTreeEntity = parentTreeEntity;
    }

    public Object[] getChildren() throws Exception {
        ArrayList<Object> children = new ArrayList<Object>();
        for (ICompilationUnit childGroovyClass : GroovyUtil.getAllGroovyClasses((IPackageFragment)this.packageFragment)) {
            if (!childGroovyClass.getResource().exists()) continue;
            children.add(new KeywordTreeEntity(childGroovyClass, this));
        }
        FolderEntity parentFolder = (FolderEntity)this.getParent().getObject();
        String folderId = this.packageFragment.getResource().getProjectRelativePath().toString();
        FolderTreeEntity folderTree = new FolderTreeEntity(FolderController.getInstance().getFolderByDisplayId(parentFolder.getProject(), folderId), this.getParent());
        ITreeEntity[] iTreeEntityArray = TreeEntityUtil.getChildren(folderTree);
        int n = iTreeEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            String extension;
            ITreeEntity child = iTreeEntityArray[n2];
            if (child instanceof SystemFileTreeEntity && !(extension = ((SystemFileTreeEntity)child).getObject().getFileExtension()).equals(".groovy") && !extension.equals(".java")) {
                children.add(new SystemFileTreeEntity((SystemFileEntity)child.getObject(), (ITreeEntity)this));
            }
            ++n2;
        }
        Collections.sort(children, new Comparator<Object>(){

            @Override
            public int compare(Object arg0, Object arg1) {
                if (arg0 instanceof KeywordTreeEntity && arg1 instanceof KeywordTreeEntity) {
                    KeywordTreeEntity keyword0 = (KeywordTreeEntity)arg0;
                    KeywordTreeEntity keyword1 = (KeywordTreeEntity)arg1;
                    try {
                        return keyword0.getText().compareTo(keyword1.getText());
                    }
                    catch (Exception exception) {
                        return 0;
                    }
                }
                return 0;
            }
        });
        return children.toArray();
    }

    public ITreeEntity getParent() throws Exception {
        return this.parentTreeEntity;
    }

    public boolean hasChildren() throws Exception {
        return true;
    }

    public String getText() throws Exception {
        return this.packageName.isEmpty() ? DEFAULT_PACKAGE_LABEL : this.packageName;
    }

    public Image getImage() throws Exception {
        return ImageConstants.IMG_16_PACKAGE;
    }

    public String getTypeName() throws Exception {
        return PACKAGE_TYPE_NAME;
    }

    public boolean isRemoveable() throws Exception {
        return this.packageFragment != null && !this.packageFragment.isDefaultPackage();
    }

    public Object getObject() throws Exception {
        return this.packageFragment;
    }

    public boolean isRenamable() throws Exception {
        return this.isRemoveable();
    }

    public Transfer getEntityTransfer() throws Exception {
        return FileTransfer.getInstance();
    }

    public String getCopyTag() throws Exception {
        return FolderEntity.FolderType.KEYWORD.toString();
    }

    public boolean equals(Object object) {
        PackageTreeEntity anotherPackageTreeEntity;
        block5: {
            block4: {
                try {
                    if (object instanceof PackageTreeEntity) break block4;
                    return false;
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                    return false;
                }
            }
            anotherPackageTreeEntity = (PackageTreeEntity)object;
            if (anotherPackageTreeEntity.getObject() instanceof IPackageFragment) break block5;
            return false;
        }
        IPackageFragment anotherPackageFragment = (IPackageFragment)anotherPackageTreeEntity.getObject();
        return StringUtils.equalsIgnoreCase((String)anotherPackageFragment.getPath().toString(), (String)this.packageFragment.getPath().toString());
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 31).append((Object)(this.packageFragment.getPath().toString() + (this.isDefaultPackage ? "\\defaultPackage" : ""))).toHashCode();
    }

    public void setObject(Object object) throws Exception {
        if (object instanceof IPackageFragment) {
            this.packageFragment = (IPackageFragment)object;
            this.packageName = ((IPackageFragment)object).getElementName();
            this.isDefaultPackage = this.packageName.equals("");
        }
    }

    public String getKeyWord() throws Exception {
        return "kw";
    }

    public String[] getSearchTags() throws Exception {
        return KeywordTreeEntity.SEARCH_TAGS;
    }

    public String getPropertyValue(String key) {
        if (key.equals("name")) {
            if (this.isDefaultPackage) {
                return DEFAULT_PACKAGE_LABEL;
            }
            return this.packageName;
        }
        return "";
    }

    public Image getEntryImage() throws Exception {
        return ImageConstants.IMG_16_KEYWORD;
    }

    public void loadAllDescentdantEntities() throws Exception {
    }

    public List<TooltipPropertyDescription> getTooltipDescriptions() {
        return Collections.emptyList();
    }

    public String getPackageName() {
        if (this.isDefaultPackage) {
            return DEFAULT_PACKAGE_LABEL;
        }
        return this.packageName;
    }
}

