/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.util;

import com.kms.katalon.composer.components.application.ApplicationSingleton;
import com.kms.katalon.composer.components.part.IComposerPart;
import com.kms.katalon.composer.components.services.ModelServiceSingleton;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.CheckpointController;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.controller.TestSuiteCollectionController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.controller.WindowsElementController;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.entity.IEntity;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.eclipse.ui.part.FileEditorInput;

public class EntityPartUtil {
    public static String getTestCaseCompositePartId(String testCasePk) {
        return "com.kms.katalon.composer.content.testcase(" + testCasePk + ")";
    }

    public static String getTestObjectPartId(String testObjectPk) {
        return "com.kms.katalon.composer.content.testobject(" + testObjectPk + ")";
    }

    public static String getMobileTestObjectPartId(String testObjectPk) {
        return "com.kms.katalon.composer.content.mobiletestobject(" + testObjectPk + ")";
    }

    public static String getWindowsTestObjectPartId(String windowsTestObjectId) {
        return "com.kms.katalon.composer.content.windowstestobject(" + windowsTestObjectId + ")";
    }

    public static String getDraftRequestPartId(String testObjectPk) {
        return "com.kms.katalon.composer.content.draftRequest(" + testObjectPk + ")";
    }

    public static String getUnusedTestObjectsPartId() {
        return "com.kms.katalon.composer.content.unusedtestobjects()";
    }

    public static String getTestSuiteCompositePartId(String testSuitePk) {
        return "com.kms.katalon.composer.content.testsuite(" + testSuitePk + ")";
    }

    public static String getTestSuiteCollectionPartId(String testSuiteCollectionId) {
        return "com.kms.katalon.composer.content.testSuiteCollection(" + testSuiteCollectionId + ")";
    }

    public static String getTestDataPartId(String testDataPk) {
        return "com.kms.katalon.composer.content.testdata(" + testDataPk + ")";
    }

    public static String getCheckpointPartId(String checkpointId) {
        return "com.kms.katalon.composer.content.checkpoint(" + checkpointId + ")";
    }

    public static String getReportPartId(String reportPk) {
        return "com.kms.katalon.composer.content.report(" + reportPk + ")";
    }

    public static String getReportCollectionPartId(String reportCollectionId) {
        return "com.kms.katalon.composer.content.collectionReport(" + reportCollectionId + ")";
    }

    public static String getExecutionProfilePartId(String executionProfileId) {
        return "com.kms.katalon.composer.content.executionProfile(" + executionProfileId + ")";
    }

    public static String getFeaturePartId(String featureId) {
        return "com.kms.katalon.composer.content.feature(" + featureId + ")";
    }

    public static void closePart(IEntity entity) {
        if (entity == null) {
            return;
        }
        String partId = "";
        String entityId = entity.getId();
        if (entity instanceof TestCaseEntity) {
            partId = EntityPartUtil.getTestCaseCompositePartId(entityId);
        } else if (entity instanceof WebElementEntity) {
            partId = EntityPartUtil.getTestObjectPartId(entityId);
        } else if (entity instanceof DataFileEntity) {
            partId = EntityPartUtil.getTestDataPartId(entityId);
        } else if (entity instanceof TestSuiteEntity) {
            partId = EntityPartUtil.getTestSuiteCompositePartId(entityId);
        } else if (entity instanceof ReportEntity) {
            partId = EntityPartUtil.getReportPartId(entityId);
        } else if (entity instanceof TestSuiteCollectionEntity) {
            partId = EntityPartUtil.getTestSuiteCollectionPartId(entityId);
        } else if (entity instanceof ReportCollectionEntity) {
            partId = EntityPartUtil.getReportCollectionPartId(entityId);
        } else if (entity instanceof CheckpointEntity) {
            partId = EntityPartUtil.getCheckpointPartId(entityId);
        } else {
            return;
        }
        EModelService modelService = ModelServiceSingleton.getInstance().getModelService();
        MApplication application = ApplicationSingleton.getInstance().getApplication();
        MPartStack mStackPart = (MPartStack)modelService.find("com.kms.katalon.composer.content", (MUIElement)application);
        MPart mPart = (MPart)modelService.find(partId, (MUIElement)application);
        if (mPart != null) {
            if (mPart.getToolbar() != null && mPart.getToolbar().getWidget() != null) {
                ((ToolBar)mPart.getToolbar().getWidget()).dispose();
            }
            mStackPart.getChildren().remove(mPart);
        }
    }

    public static IEntity getEntityByPartId(String partElementId) {
        block15: {
            try {
                if (!StringUtils.isBlank((String)partElementId)) break block15;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        String testCaseId = EntityPartUtil.getEntityIdFromPartId(partElementId, "com.kms.katalon.composer.content.testcase");
        if (testCaseId != null) {
            return TestCaseController.getInstance().getTestCase(testCaseId);
        }
        String testObjectId = EntityPartUtil.getEntityIdFromPartId(partElementId, "com.kms.katalon.composer.content.testobject");
        if (testObjectId != null) {
            return ObjectRepositoryController.getInstance().getWebElement(testObjectId);
        }
        String mobileTestObjectId = EntityPartUtil.getEntityIdFromPartId(partElementId, "com.kms.katalon.composer.content.mobiletestobject");
        if (mobileTestObjectId != null) {
            return ObjectRepositoryController.getInstance().getWebElement(mobileTestObjectId);
        }
        String windowTestObjectId = EntityPartUtil.getEntityIdFromPartId(partElementId, "com.kms.katalon.composer.content.windowstestobject");
        if (windowTestObjectId != null) {
            return WindowsElementController.getInstance().getWindowsElementEntity(windowTestObjectId);
        }
        String testDataId = EntityPartUtil.getEntityIdFromPartId(partElementId, "com.kms.katalon.composer.content.testdata");
        if (testDataId != null) {
            return TestDataController.getInstance().getTestData(testDataId);
        }
        String testSuiteId = EntityPartUtil.getEntityIdFromPartId(partElementId, "com.kms.katalon.composer.content.testsuite");
        if (testSuiteId != null) {
            return TestSuiteController.getInstance().getTestSuite(testSuiteId);
        }
        String reportCollectionId = EntityPartUtil.getEntityIdFromPartId(partElementId, "com.kms.katalon.composer.content.collectionReport");
        if (reportCollectionId != null) {
            return ReportController.getInstance().getReportCollection(reportCollectionId);
        }
        String reportId = EntityPartUtil.getEntityIdFromPartId(partElementId, "com.kms.katalon.composer.content.report");
        if (reportId != null) {
            return ReportController.getInstance().getReportEntity(reportId);
        }
        String testSuiteCollectionId = EntityPartUtil.getEntityIdFromPartId(partElementId, "com.kms.katalon.composer.content.testSuiteCollection");
        if (testSuiteCollectionId != null) {
            return TestSuiteCollectionController.getInstance().getTestSuiteCollection(testSuiteCollectionId);
        }
        String checkpointId = EntityPartUtil.getEntityIdFromPartId(partElementId, "com.kms.katalon.composer.content.checkpoint");
        if (checkpointId != null) {
            return CheckpointController.getInstance().getById(checkpointId);
        }
        String profileId = EntityPartUtil.getEntityIdFromPartId(partElementId, "com.kms.katalon.composer.content.executionProfile");
        if (profileId != null) {
            ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
            return GlobalVariableController.getInstance().getExecutionProfileById(profileId, projectEntity);
        }
        String windowsEntityId = EntityPartUtil.getEntityIdFromPartId(partElementId, "com.kms.katalon.composer.content.windowstestobject");
        if (windowsEntityId != null) {
            return WindowsElementController.getInstance().getWindowsElementEntity(windowsEntityId);
        }
        return null;
    }

    public static String getEntityIdFromPartId(String partElementId, String entityPrefixId) {
        if (!StringUtils.startsWith((String)partElementId, (String)entityPrefixId)) {
            return null;
        }
        return StringUtils.substring((String)partElementId, (int)(partElementId.indexOf("(") + 1), (int)partElementId.lastIndexOf(")"));
    }

    public static String[] getDraftEntities(Collection<MPart> parts) {
        ArrayList<String> ids = new ArrayList<String>();
        if (parts == null || parts.isEmpty()) {
            return new String[0];
        }
        for (MPart part : parts) {
            IComposerPart composerPart;
            Object o = part.getObject();
            if (!(o instanceof IComposerPart) || !(composerPart = (IComposerPart)o).isDraft()) continue;
            ids.add(composerPart.getPartId());
        }
        return ids.toArray(new String[0]);
    }

    public static List<String> getOpenedEntityIds(Collection<MPart> parts) {
        ArrayList<String> ids = new ArrayList<String>();
        if (parts == null || parts.isEmpty()) {
            return ids;
        }
        for (MPart part : parts) {
            CompatibilityEditor editor;
            IEditorInput editorInput;
            Object o = part.getObject();
            if (o instanceof IComposerPart) {
                String entityId;
                IComposerPart composerPart = (IComposerPart)o;
                if (composerPart.isDraft() || !StringUtils.isNotBlank((String)(entityId = composerPart.getEntityId()))) continue;
                ids.add(entityId);
                continue;
            }
            if (!(o instanceof CompatibilityEditor) || StringUtils.startsWith((String)((CompatibilityEditor)o).getModel().getElementId(), (String)"com.kms.katalon.composer.content.testcase") || !((editorInput = (editor = (CompatibilityEditor)o).getEditor().getEditorInput()) instanceof FileEditorInput)) continue;
            String filePath = ((FileEditorInput)editorInput).getPath().toOSString();
            String relativePath = PathUtil.absoluteToRelativePath((String)filePath, (String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
            if (relativePath.startsWith(GlobalStringConstants.ROOT_FOLDER_NAME_TEST_LISTENER)) {
                ids.add(relativePath.replace(".groovy", ""));
                continue;
            }
            ids.add(relativePath);
        }
        return ids;
    }

    public static MCompositePart findTestCaseCompositePart(TestCaseEntity testCaseEntity) {
        EModelService modelService = ModelServiceSingleton.getInstance().getModelService();
        MApplication application = ApplicationSingleton.getInstance().getApplication();
        String testCasePartId = EntityPartUtil.getTestCaseCompositePartId(testCaseEntity.getId());
        MCompositePart testCasePart = null;
        MPartStack stack = (MPartStack)modelService.find("com.kms.katalon.composer.content", (MUIElement)application);
        if (stack != null) {
            testCasePart = (MCompositePart)modelService.find(testCasePartId, (MUIElement)stack);
        }
        return testCasePart;
    }
}

