/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.dto.result;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.katalon.execution.dto.result.Statistics;
import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.ExecutionTestResult;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.TestExecutionStep;
import com.katalon.execution.model.steps.TestPreparing;
import com.katalon.execution.model.steps.TestReportingPhase;
import com.katalon.execution.model.steps.testcase.BaseTestCaseExecution;
import com.katalon.execution.model.steps.testcase.TestCaseBindingExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecutionAttempt;
import com.katalon.execution.model.steps.testsuite.BaseTestSuiteExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteCollectionExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecutionAttempt;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JobDTO {
    private String id;
    private String name;
    private Integer progress = null;
    @JsonProperty(value="result")
    private ExecutionTestResult testResult = null;
    @JsonProperty(value="failedReason")
    public String failedReason;
    @JsonProperty(value="status")
    private ExecutionJobStatus jobStatus = ExecutionJobStatus.PENDING;
    @JsonProperty(value="stoppable")
    private boolean stoppable = false;
    @JsonProperty(value="pausable")
    private boolean pausable = false;
    @JsonProperty(value="retriable")
    private boolean retriable = false;
    private Statistics statistics;
    private List<JobDTO> subJobs = new ArrayList<JobDTO>();

    public JobDTO(String id, String name, Integer progress, ExecutionJobStatus status) {
        this.id = id;
        this.name = name;
        this.progress = progress;
        this.jobStatus = status;
    }

    public JobDTO(String id, String name, Integer progress, TestExecutionStep step) {
        this.id = id;
        this.name = name;
        this.progress = progress;
        if (step == null) {
            return;
        }
        this.jobStatus = step.getExecutionJobStatus();
        if (step.getJobFailedReason().isPresent()) {
            this.failedReason = step.getJobFailedReason().get();
            return;
        }
        if (this.jobStatus == ExecutionJobStatus.TERMINATED) {
            return;
        }
    }

    public void addSubJobs(JobDTO job) {
        this.subJobs.add(job);
    }

    public static JobDTO fromTestPreparing(TestPreparing testPreparing) {
        return new JobDTO(testPreparing.getId().toString(), testPreparing.getTitle(), null, testPreparing);
    }

    public static JobDTO fromEntityExecution(EntityExecution entityExecution) {
        if (entityExecution instanceof BaseTestCaseExecution) {
            BaseTestCaseExecution baseTestCaseExecution = (BaseTestCaseExecution)entityExecution;
            return JobDTO.fromBaseTestCaseExecution(baseTestCaseExecution);
        }
        if (entityExecution instanceof BaseTestSuiteExecution) {
            BaseTestSuiteExecution baseTestSuiteExecution = (BaseTestSuiteExecution)entityExecution;
            return JobDTO.fromBaseTestSuiteExecution(baseTestSuiteExecution);
        }
        if (entityExecution instanceof TestSuiteCollectionExecution) {
            TestSuiteCollectionExecution tscExecution = (TestSuiteCollectionExecution)entityExecution;
            return JobDTO.fromTestSuiteCollectionExecution(tscExecution);
        }
        return null;
    }

    public static JobDTO fromReportingPhase(TestReportingPhase reportingPhase) {
        JobDTO job = new JobDTO(reportingPhase.getId().toString(), reportingPhase.getTitle(), null, reportingPhase);
        job.setSubJobs(reportingPhase.getChildren().stream().map(child -> new JobDTO(child.getId().toString(), child.getTitle(), null, (TestExecutionStep)child)).toList());
        return job;
    }

    private static JobDTO fromBaseTestSuiteExecution(BaseTestSuiteExecution baseTestSuiteExecution) {
        if (baseTestSuiteExecution instanceof TestSuiteExecution) {
            TestSuiteExecution testSuiteExecution = (TestSuiteExecution)baseTestSuiteExecution;
            return JobDTO.fromTestSuiteExecution(testSuiteExecution);
        }
        if (baseTestSuiteExecution instanceof TestSuiteExecutionAttempt) {
            TestSuiteExecutionAttempt testSuiteExecutionAttempt = (TestSuiteExecutionAttempt)baseTestSuiteExecution;
            return JobDTO.fromTestSuiteExecutionAttempt(testSuiteExecutionAttempt);
        }
        return null;
    }

    private static JobDTO fromTestSuiteExecution(TestSuiteExecution testSuiteExecution) {
        JobDTO job = new JobDTO(testSuiteExecution.getId().toString(), testSuiteExecution.getTitle(), (Integer)0, testSuiteExecution);
        job.stoppable = true;
        EntityExecution.JobProgress jobProgress = testSuiteExecution.buildJobProgress();
        JobDTO.updateJobWithProgress(job, jobProgress, "test case");
        job.statistics = Statistics.fromEntityExecution(testSuiteExecution);
        return job;
    }

    private static JobDTO fromTestSuiteExecutionAsPartOfCollection(TestSuiteExecution testSuiteExecution) {
        JobDTO job = new JobDTO(testSuiteExecution.getId().toString(), testSuiteExecution.getName(), null, testSuiteExecution);
        EntityExecution.JobProgress jobProgress = testSuiteExecution.buildJobProgress();
        job.name = String.valueOf(job.name) + " (" + jobProgress.executedUnits() + "/" + jobProgress.totalUnits() + " test case(s))";
        if (testSuiteExecution.getExecutionJobStatus() == ExecutionJobStatus.COMPLETED && testSuiteExecution.getTestResult().isPresent()) {
            job.setTestResult(testSuiteExecution.getTestResult().get());
        }
        job.statistics = Statistics.fromEntityExecution(testSuiteExecution);
        return job;
    }

    private static JobDTO fromTestSuiteExecutionAttempt(TestSuiteExecutionAttempt attempt) {
        JobDTO job = new JobDTO(attempt.getId().toString(), attempt.getTitle(), (Integer)0, attempt);
        EntityExecution.JobProgress jobProgress = attempt.buildJobProgress();
        JobDTO.updateJobWithProgress(job, jobProgress, "test case");
        job.statistics = Statistics.fromEntityExecution(attempt);
        return job;
    }

    private static JobDTO fromTestSuiteCollectionExecution(TestSuiteCollectionExecution tscExecution) {
        JobDTO job = new JobDTO(tscExecution.getId().toString(), tscExecution.getTitle(), (Integer)0, tscExecution);
        job.stoppable = true;
        int totalTestSuitesCount = tscExecution.getTestSuiteExecutions().size();
        int executedTestSuitesCount = (int)tscExecution.getTestSuiteExecutions().stream().filter(ts -> ts.getExecutionJobStatus() == ExecutionJobStatus.COMPLETED).count();
        EntityExecution.JobProgress jobProgress = new EntityExecution.JobProgress(executedTestSuitesCount, totalTestSuitesCount);
        JobDTO.updateJobWithProgress(job, jobProgress, "test suite");
        for (TestSuiteExecution tsExecution : tscExecution.getTestSuiteExecutions()) {
            JobDTO subJob = JobDTO.fromTestSuiteExecutionAsPartOfCollection(tsExecution);
            job.addSubJobs(subJob);
        }
        return job;
    }

    private static void updateJobWithProgress(JobDTO job, EntityExecution.JobProgress jobProgress, String unitName) {
        if (jobProgress != null) {
            job.setProgress((int)((float)jobProgress.executedUnits() / (float)jobProgress.totalUnits() * 100.0f));
        }
        String verb = JobDTO.buildExecuteVerb(job.getJobStatus());
        String jobName = verb + " " + jobProgress.executedUnits() + "/" + jobProgress.totalUnits() + " " + unitName + "(s)";
        job.setName(jobName);
    }

    private static String buildExecuteVerb(ExecutionJobStatus status) {
        return switch (status) {
            case ExecutionJobStatus.PENDING -> "Execute";
            case ExecutionJobStatus.RUNNING -> "Executing";
            case ExecutionJobStatus.ERROR, ExecutionJobStatus.TERMINATED, ExecutionJobStatus.COMPLETED, ExecutionJobStatus.FAILED -> "Executed";
            default -> "Execute";
        };
    }

    private static JobDTO fromBaseTestCaseExecution(BaseTestCaseExecution baseTestCaseExecution) {
        if (baseTestCaseExecution instanceof TestCaseBindingExecution) {
            TestCaseBindingExecution testCaseBindingExecution = (TestCaseBindingExecution)baseTestCaseExecution;
            return JobDTO.fromTestCaseBindingExecution(testCaseBindingExecution);
        }
        if (baseTestCaseExecution instanceof TestCaseExecution) {
            TestCaseExecution normalTestCaseExecution = (TestCaseExecution)baseTestCaseExecution;
            return JobDTO.fromTestCaseExecution(normalTestCaseExecution);
        }
        if (baseTestCaseExecution instanceof TestCaseExecutionAttempt) {
            TestCaseExecutionAttempt testCaseExecutionAttempt = (TestCaseExecutionAttempt)baseTestCaseExecution;
            return JobDTO.fromTestCaseExecutionAttempt(testCaseExecutionAttempt);
        }
        return null;
    }

    private static JobDTO fromTestCaseBindingExecution(TestCaseBindingExecution testCaseBindingExecution) {
        JobDTO job = new JobDTO(testCaseBindingExecution.getId().toString(), testCaseBindingExecution.getTitle(), (Integer)0, testCaseBindingExecution);
        job.stoppable = true;
        EntityExecution.JobProgress jobProgress = testCaseBindingExecution.buildJobProgress();
        JobDTO.updateJobWithProgress(job, jobProgress, "iteration");
        job.statistics = Statistics.fromEntityExecution(testCaseBindingExecution);
        return job;
    }

    private static JobDTO fromTestCaseExecution(TestCaseExecution testCaseExecution) {
        JobDTO job = new JobDTO(testCaseExecution.getId().toString(), testCaseExecution.getTitle(), (Integer)0, testCaseExecution);
        job.stoppable = true;
        if (testCaseExecution.getTestResult().isPresent()) {
            job.setTestResult(testCaseExecution.getTestResult().get());
        }
        job.setName(JobDTO.buildExecuteVerb(job.getJobStatus()) + " test case");
        job.statistics = Statistics.fromEntityExecution(testCaseExecution);
        return job;
    }

    private static JobDTO fromTestCaseExecutionAttempt(TestCaseExecutionAttempt attempt) {
        return new JobDTO(attempt.getId().toString(), (String)(attempt.getTitle() != null ? attempt.getTitle() : "Attempt " + (attempt.getAttemptIndex() + 1)), (Integer)0, attempt);
    }

    public String toString() {
        return "Job(id=" + this.id + ", name=" + this.name + ", progress=" + String.valueOf(this.progress) + ", status=" + String.valueOf((Object)this.jobStatus) + ")";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getProgress() {
        return this.progress;
    }

    public void setProgress(Integer progress) {
        this.progress = progress;
    }

    public List<JobDTO> getSubJobs() {
        return this.subJobs;
    }

    public void setSubJobs(List<JobDTO> subJobs) {
        this.subJobs = subJobs;
    }

    public ExecutionTestResult getTestResult() {
        return this.testResult;
    }

    public void setTestResult(ExecutionTestResult testResult) {
        this.testResult = testResult;
    }

    public ExecutionJobStatus getJobStatus() {
        return this.jobStatus;
    }

    public void setJobStatus(ExecutionJobStatus jobStatus) {
        this.jobStatus = jobStatus;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(Statistics statistics) {
        this.statistics = statistics;
    }
}

