/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.dto.result;

import com.katalon.execution.model.ExecutionTestResult;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.TestResultStatistics;
import java.util.EnumMap;

public class Statistics {
    public int total;
    public int passed;
    public int failed;
    public int errored;
    public int skipped;
    public int notRun;
    public int incomplete;
    public int progress;

    public static Statistics fromEntityExecution(EntityExecution entityExecution) {
        TestResultStatistics descendantTestCaseStats = entityExecution.getDescendantTestCaseStats();
        Statistics stats = new Statistics();
        stats.total = entityExecution.getTestCaseCount();
        EnumMap<ExecutionTestResult, Integer> testResultCountMap = descendantTestCaseStats.getTestResultCount();
        stats.passed = testResultCountMap.getOrDefault((Object)ExecutionTestResult.PASSED, 0);
        stats.failed = testResultCountMap.getOrDefault((Object)ExecutionTestResult.FAILED, 0);
        stats.errored = testResultCountMap.getOrDefault((Object)ExecutionTestResult.ERROR, 0);
        stats.skipped = testResultCountMap.getOrDefault((Object)ExecutionTestResult.SKIPPED, 0);
        stats.notRun = testResultCountMap.getOrDefault((Object)ExecutionTestResult.NOT_RUN, 0);
        stats.incomplete = testResultCountMap.getOrDefault((Object)ExecutionTestResult.INCOMPLETE, 0);
        stats.progress = stats.total - (stats.passed + stats.failed + stats.errored + stats.skipped + stats.notRun + stats.incomplete);
        return stats;
    }

    public String toString() {
        return String.format("Statistics{total=%d, passed=%d, failed=%d, errored=%d, skipped=%d, notRun=%d, incomplete=%d, progress=%d}", this.total, this.passed, this.failed, this.errored, this.skipped, this.notRun, this.incomplete, this.progress);
    }
}

