/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.dto.result;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.katalon.execution.dto.result.MaskableContextParam;
import com.katalon.execution.dto.result.SelfHealingInfo;
import com.katalon.execution.dto.result.TestEntityExecutionResult;
import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.ExecutionTestResult;
import com.katalon.execution.model.logrecord.LogRecord;
import com.katalon.execution.model.logrecord.MessageLogRecord;
import com.katalon.execution.model.logrecord.TestCaseLogRecord;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.testcase.TestCaseBindingExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecutionAttempt;
import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.testcase.TestCaseBinding;
import com.kms.katalon.core.testcase.VariableReport;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class TestCaseExecutionResult
extends TestEntityExecutionResult {
    @JsonProperty(value="selfHealingInfo")
    private SelfHealingInfo selfHealingInfo;

    public TestCaseExecutionResult(TestEntityExecutionResult.TestExecutionType type) {
        this.type = type;
    }

    public static TestCaseExecutionResult fromTestCaseExecutionAttempt(TestCaseExecutionAttempt attempt, TestCaseBinding testCaseBinding, String parentId) {
        TestCaseExecutionResult result = new TestCaseExecutionResult(TestEntityExecutionResult.TestExecutionType.TEST_CASE_ATTEMPT);
        result.id = attempt.getId().toString();
        result.name = attempt.getTestCase().getIdForDisplay();
        result.shortDisplayName = TestCaseExecutionResult.buildTestCaseShortDisplayName(attempt, testCaseBinding, result.name);
        result.description = attempt.getTestCase().getDescription();
        result.startTime = TestCaseExecutionResult.getTimeString(attempt.getStartDate());
        result.endTime = TestCaseExecutionResult.getTimeString(attempt.getEndDate());
        result.retryCount = attempt.getAttemptIndex();
        for (LogRecord childLogRecord : attempt.getLogRecords()) {
            if (!(childLogRecord instanceof MessageLogRecord)) continue;
            MessageLogRecord messageLogRecord = (MessageLogRecord)childLogRecord;
            result.messages.add(TestEntityExecutionResult.LogMessage.fromLogRecord(messageLogRecord));
        }
        TestCaseLogRecord testCaseLogRecord = attempt.getTestCaseLogRecord();
        if (testCaseLogRecord != null) {
            List normalVariables;
            Pair<List<MaskableContextParam>, List<MaskableContextParam>> variableLists = TestCaseExecutionResult.buildVariableLists(testCaseLogRecord, testCaseBinding);
            List bindedVariables = variableLists != null ? (List)variableLists.getLeft() : null;
            List list = normalVariables = variableLists != null ? (List)variableLists.getRight() : null;
            if (bindedVariables != null) {
                result.dataBinding = bindedVariables;
            }
            if (normalVariables != null) {
                result.variables = normalVariables;
            }
            if (testCaseLogRecord.isSelfHealingApplied()) {
                SelfHealingInfo selfHealingInfo = new SelfHealingInfo();
                selfHealingInfo.applied = true;
                selfHealingInfo.report = List.of(StringConstants.SELF_HEALING_REPORT_VISIT_INSIGHT_PART, StringConstants.SELF_HEALING_REFER_TO_DOCUMENT);
                result.setSelfHealingInfo(selfHealingInfo);
            }
            if (!attempt.isPartOfTestSuite()) {
                result.executionInfo = TestCaseExecutionResult.buildExecutionInfo(attempt);
            }
        }
        result.executionJobStatus = attempt.getExecutionJobStatus();
        attempt.getTestResult().ifPresent(v -> {
            ExecutionTestResult executionTestResult = testCaseExecutionResult.executionTestResult = v;
        });
        attempt.determineFinalTestFailedReason().ifPresent(v -> {
            String string = testCaseExecutionResult.failedReason = v;
        });
        if (result.executionTestResult != ExecutionTestResult.PASSED && attempt.getExecutionSettings() != null && attempt.getExecutionSettings().getRunConfiguration() != null && attempt.getExecutionSettings().getRunConfiguration().getExecution() != null && attempt.getExecutionSettings().getRunConfiguration().getExecution().getGeneral() != null && attempt.getExecutionSettings().getExecutionDirPath() != null && attempt.getExecutionSettings().getExecutionDirPath().toAbsolutePath().toString() != "") {
            result.timeCapsuleEnabled = attempt.getExecutionSettings().getRunConfiguration().getExecution().getGeneral().getTimeCapsuleEnabled();
            result.executionDirPath = attempt.getExecutionSettings().getExecutionDirPath().toAbsolutePath().toString();
            result.failedTestCaseId = attempt.getTestCaseId();
        }
        result.parentId = parentId;
        return result;
    }

    public static TestCaseExecutionResult fromLogRecord(TestCaseLogRecord logRecord, String parentId) {
        TestCaseExecutionResult result = new TestCaseExecutionResult(TestEntityExecutionResult.TestExecutionType.TEST_CASE);
        result.id = logRecord.getId().toString();
        result.name = logRecord.getName();
        result.description = logRecord.getDescription();
        result.startTime = TestCaseExecutionResult.getTimeString(logRecord.getStartTime());
        result.endTime = TestCaseExecutionResult.getTimeString(logRecord.getEndTime());
        for (LogRecord childLogRecord : logRecord.getChildRecords()) {
            if (!(childLogRecord instanceof MessageLogRecord)) continue;
            MessageLogRecord messageLogRecord = (MessageLogRecord)childLogRecord;
            result.messages.add(TestEntityExecutionResult.LogMessage.fromLogRecord(messageLogRecord));
        }
        if (logRecord.isSelfHealingApplied()) {
            SelfHealingInfo selfHealingInfo = new SelfHealingInfo();
            selfHealingInfo.applied = true;
            result.setSelfHealingInfo(selfHealingInfo);
        }
        if (result.startTime != null) {
            result.executionJobStatus = result.endTime != null ? ExecutionJobStatus.COMPLETED : ExecutionJobStatus.RUNNING;
        }
        ExecutionTestResult testResult = ExecutionTestResult.fromTestStatusValue(logRecord.getTestStatus().getStatusValue());
        result.executionTestResult = TestCaseExecutionResult.resolveTestResult(result.executionJobStatus, testResult);
        result.parentId = parentId;
        return result;
    }

    private static Pair<List<MaskableContextParam>, List<MaskableContextParam>> buildVariableLists(TestCaseLogRecord testCaseLogRecord, TestCaseBinding testCaseBinding) {
        List<VariableReport> variableList = testCaseLogRecord.getVariableReports();
        if (variableList == null || variableList.isEmpty()) {
            return null;
        }
        Set bindedVariableNames = testCaseBinding != null && testCaseBinding.getBindedValues() != null ? testCaseBinding.getBindedValues().keySet() : Set.of();
        ArrayList<MaskableContextParam> bindedVariables = new ArrayList<MaskableContextParam>();
        ArrayList<MaskableContextParam> normalVariables = new ArrayList<MaskableContextParam>();
        for (VariableReport variable : variableList) {
            if (variable == null || variable.getName() == null) continue;
            MaskableContextParam contextParam = new MaskableContextParam(variable.getName(), variable.getValue(), variable.isMasked());
            if (bindedVariableNames.contains(variable.getName())) {
                bindedVariables.add(contextParam);
                continue;
            }
            normalVariables.add(contextParam);
        }
        return Pair.of(bindedVariables, normalVariables);
    }

    private static String buildTestCaseShortDisplayName(TestCaseExecutionAttempt attempt, TestCaseBinding testCaseBinding, String defaultName) {
        EntityExecution entityExecution = attempt.getParentEntityExecution();
        if (entityExecution instanceof TestCaseExecution) {
            TestCaseExecution testCaseExecution = (TestCaseExecution)entityExecution;
            if (testCaseExecution.getAttempts().size() == 1) {
                if (testCaseExecution.getParentEntityExecution() instanceof TestCaseBindingExecution && testCaseBinding != null) {
                    return TestCaseExecutionResult.buildTestCaseNameWithBindingInfo(testCaseBinding);
                }
                return defaultName;
            }
            if (attempt.getAttemptIndex() == 0) {
                return "First execution";
            }
            int maxRetryCount = 1;
            if (testCaseExecution.getExecutionSettings() != null && testCaseExecution.getExecutionSettings().getTestSuiteRerunSettings() != null) {
                maxRetryCount = testCaseExecution.getExecutionSettings().getTestSuiteRerunSettings().getMaxRetryCount();
            }
            return String.format("Retry attempt %d/%d", attempt.getAttemptIndex(), maxRetryCount);
        }
        return defaultName;
    }

    private static String buildTestCaseShortDisplayName(TestCaseExecution testCaseExecution, TestCaseBinding testCaseBinding, String defaultName) {
        if (testCaseExecution.getParentEntityExecution() instanceof TestCaseBindingExecution && testCaseBinding != null) {
            return TestCaseExecutionResult.buildTestCaseNameWithBindingInfo(testCaseBinding);
        }
        return defaultName;
    }

    private static String buildTestCaseNameWithBindingInfo(TestCaseBinding testCaseBinding) {
        Object iterationValue;
        Object nameWithBinding = testCaseBinding == null ? "" : testCaseBinding.getTestCaseName();
        int iterationPos = ((String)nameWithBinding).indexOf("Iteration");
        if (iterationPos != -1) {
            nameWithBinding = ((String)nameWithBinding).substring(iterationPos).trim();
        }
        if (testCaseBinding != null && testCaseBinding.getIterationVariableName() != null && !testCaseBinding.getIterationVariableName().isEmpty() && testCaseBinding.getBindedValues() != null && (iterationValue = testCaseBinding.getBindedValues().get(testCaseBinding.getIterationVariableName())) != null && !iterationValue.toString().isEmpty()) {
            nameWithBinding = (String)nameWithBinding + " | " + iterationValue.toString();
        }
        return nameWithBinding;
    }

    public static TestCaseExecutionResult fromTestCaseExecution(TestCaseExecution testCaseExecution, TestCaseBinding testCaseBinding, String parentId, String anchorChildId) {
        TestCaseExecutionResult result = new TestCaseExecutionResult(TestEntityExecutionResult.TestExecutionType.TEST_CASE);
        result.id = testCaseExecution.getId().toString();
        result.name = testCaseExecution.getTestCase().getIdForDisplay();
        result.shortDisplayName = TestCaseExecutionResult.buildTestCaseShortDisplayName(testCaseExecution, testCaseBinding, result.name);
        result.description = testCaseExecution.getTestCase().getDescription();
        TestCaseExecutionAttempt firstAttempt = testCaseExecution.getFirstAttempt();
        TestCaseExecutionAttempt lastAttempt = testCaseExecution.getLastAttempt();
        result.startTime = TestCaseExecutionResult.getTimeString(firstAttempt.getStartDate());
        result.endTime = TestCaseExecutionResult.getTimeString(lastAttempt.getEndDate());
        if (!testCaseExecution.isPartOfTestSuite()) {
            result.executionInfo = TestCaseExecutionResult.buildExecutionInfo(testCaseExecution.getFirstAttempt());
        }
        result.executionJobStatus = testCaseExecution.getExecutionJobStatus();
        testCaseExecution.getTestResult().ifPresent(v -> {
            ExecutionTestResult executionTestResult = testCaseExecutionResult.executionTestResult = v;
        });
        testCaseExecution.determineFinalTestFailedReason().ifPresent(v -> {
            String string = testCaseExecutionResult.failedReason = v;
        });
        if (StringUtils.isNotBlank((CharSequence)anchorChildId)) {
            result.anchorChildId = anchorChildId;
            result.updateType = TestEntityExecutionResult.UpdateType.REARRANGE_PARENT_CHILDREN;
        } else {
            result.parentId = parentId;
        }
        return result;
    }

    public static TestCaseExecutionResult fromTestCaseBindingExecution(TestCaseBindingExecution testCaseBindingExecution, String parentId) {
        TestCaseExecutionResult result = new TestCaseExecutionResult(TestEntityExecutionResult.TestExecutionType.TEST_CASE);
        result.id = testCaseBindingExecution.getId().toString();
        result.name = testCaseBindingExecution.getTestCase().getIdForDisplay();
        result.description = testCaseBindingExecution.getTestCase().getDescription();
        TestCaseExecutionAttempt firstAttempt = testCaseBindingExecution.getFirstIteration().getFirstAttempt();
        TestCaseExecutionAttempt lastAttempt = testCaseBindingExecution.getLastIteration().getLastAttempt();
        result.startTime = TestCaseExecutionResult.getTimeString(firstAttempt.getStartDate());
        result.endTime = TestCaseExecutionResult.getTimeString(lastAttempt.getEndDate());
        if (!testCaseBindingExecution.isPartOfTestSuite()) {
            result.executionInfo = TestCaseExecutionResult.buildExecutionInfo(testCaseBindingExecution.getFirstIteration().getFirstAttempt());
        }
        result.executionJobStatus = testCaseBindingExecution.getExecutionJobStatus();
        testCaseBindingExecution.getTestResult().ifPresent(v -> {
            ExecutionTestResult executionTestResult = testCaseExecutionResult.executionTestResult = v;
        });
        testCaseBindingExecution.determineFinalTestFailedReason().ifPresent(v -> {
            String string = testCaseExecutionResult.failedReason = v;
        });
        result.parentId = parentId;
        return result;
    }

    private static List<MaskableContextParam> buildExecutionInfo(TestCaseExecutionAttempt attempt) {
        TestCaseLogRecord testCaseLogRecord = attempt.getTestCaseLogRecord();
        if (testCaseLogRecord != null) {
            return TestCaseExecutionResult.buildExecutionInfo(testCaseLogRecord.getRunData());
        }
        return List.of();
    }

    public SelfHealingInfo getSelfHealingInfo() {
        return this.selfHealingInfo;
    }

    public void setSelfHealingInfo(SelfHealingInfo selfHealingInfo) {
        this.selfHealingInfo = selfHealingInfo;
    }
}

