/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.dto.result;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.katalon.execution.dto.result.MaskableContextParam;
import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.ExecutionTestResult;
import com.katalon.execution.model.logrecord.LogRecord;
import com.katalon.execution.model.logrecord.MessageLogRecord;
import com.katalon.execution.model.steps.EntityExecution;
import com.kms.katalon.entity.IExecutableEntity;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.FilteringTestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.util.DateTimes;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TestEntityExecutionResult {
    public String id;
    public TestExecutionType type;
    public String name;
    public String shortDisplayName;
    public String description;
    public String startTime;
    public String endTime;
    public int retryCount;
    public int index;
    public List<MaskableContextParam> executionInfo = new ArrayList<MaskableContextParam>();
    public List<MaskableContextParam> dataBinding = new ArrayList<MaskableContextParam>();
    public List<MaskableContextParam> variables = new ArrayList<MaskableContextParam>();
    public String failedReason;
    public boolean timeCapsuleEnabled;
    public String executionDirPath;
    public String failedTestCaseId;
    @JsonProperty(value="status")
    public ExecutionJobStatus executionJobStatus = ExecutionJobStatus.PENDING;
    @JsonProperty(value="result")
    public ExecutionTestResult executionTestResult;
    @JsonProperty(value="logs")
    public List<LogMessage> messages = new ArrayList<LogMessage>();
    public String parentId;
    public String anchorChildId;
    public TestEntityExecutionResult[] children;
    @JsonIgnoreProperties
    public UpdateType updateType = UpdateType.FULL;

    public static TestEntityExecutionResult simpleStatusUpdate(EntityExecution entityExecution) {
        TestEntityExecutionResult result = new TestEntityExecutionResult();
        result.id = entityExecution.getIdString();
        result.executionJobStatus = entityExecution.getExecutionJobStatus();
        result.endTime = TestEntityExecutionResult.getTimeString(entityExecution.getEndDate());
        entityExecution.getTestResult().ifPresent(v -> {
            ExecutionTestResult executionTestResult = testEntityExecutionResult.executionTestResult = v;
        });
        entityExecution.determineFinalTestFailedReason().ifPresent(v -> {
            String string = testEntityExecutionResult.failedReason = v;
        });
        result.updateType = UpdateType.STATUS_ONLY;
        return result;
    }

    public static TestEntityExecutionResult simpleStatusUpdateForIncompleteRecord(LogRecord logRecord, ExecutionJobStatus jobStatus) {
        TestEntityExecutionResult result = new TestEntityExecutionResult();
        result.id = logRecord.getId();
        result.executionJobStatus = jobStatus;
        result.endTime = TestEntityExecutionResult.getTimeString(logRecord.getEndTime());
        result.executionTestResult = ExecutionTestResult.INCOMPLETE;
        result.updateType = UpdateType.STATUS_ONLY;
        return result;
    }

    protected static ExecutionTestResult resolveTestResult(ExecutionJobStatus jobStatus, ExecutionTestResult originalResult) {
        if (jobStatus == ExecutionJobStatus.RUNNING) {
            return null;
        }
        if (originalResult != null) {
            return originalResult;
        }
        if (jobStatus == ExecutionJobStatus.COMPLETED) {
            return ExecutionTestResult.PASSED;
        }
        if (jobStatus == ExecutionJobStatus.FAILED) {
            return ExecutionTestResult.FAILED;
        }
        if (jobStatus == ExecutionJobStatus.ERROR) {
            return ExecutionTestResult.ERROR;
        }
        if (jobStatus == ExecutionJobStatus.TERMINATED) {
            return ExecutionTestResult.INCOMPLETE;
        }
        return null;
    }

    protected static String getTimeString(long epochMillis) {
        if (epochMillis > 0L) {
            return DateTimes.formatISO8601((Date)new Date(epochMillis));
        }
        return null;
    }

    protected static String getTimeString(Date date) {
        if (date != null) {
            return DateTimes.formatISO8601((Date)date);
        }
        return null;
    }

    protected static List<MaskableContextParam> buildExecutionInfo(Map<String, String> runData) {
        if (runData == null) {
            return new ArrayList<MaskableContextParam>();
        }
        boolean masked = false;
        return runData.entrySet().stream().map(entry -> new MaskableContextParam((String)entry.getKey(), (String)entry.getValue(), masked)).toList();
    }

    public static enum LogLevel {
        DEBUG,
        INFO,
        WARNING,
        FAILED,
        ERROR,
        ABORTED,
        NOT_RUN,
        PASSED,
        SKIPPED;

    }

    public static class LogMessage {
        public String message;
        public String time;
        public String level;

        public static LogMessage fromLogRecord(MessageLogRecord logRecord) {
            LogMessage result = new LogMessage();
            result.message = logRecord.getMessage();
            result.time = DateTimes.formatISO8601((Date)new Date(logRecord.getStartTime()));
            result.level = logRecord.getLogLevel().getName();
            return result;
        }
    }

    public static enum TestExecutionType {
        TEST_STEP,
        TEST_STEP_OF_TEST_SUITE,
        TEST_CASE_LISTENER,
        TEST_CASE_ATTEMPT,
        TEST_CASE,
        TEST_SUITE_ATTEMPT,
        TEST_SUITE,
        TEST_SUITE_COLLECTION,
        BDD_FEATURE_FILE,
        DYNAMIC_TEST_SUITE;


        public static TestExecutionType fromExecutableEntity(IExecutableEntity executableEntity) {
            if (executableEntity instanceof TestCaseEntity) {
                return TEST_CASE;
            }
            if (executableEntity instanceof SystemFileEntity) {
                return BDD_FEATURE_FILE;
            }
            if (executableEntity instanceof FilteringTestSuiteEntity) {
                return DYNAMIC_TEST_SUITE;
            }
            if (executableEntity instanceof TestSuiteEntity) {
                return TEST_SUITE;
            }
            return TEST_SUITE_COLLECTION;
        }
    }

    public static enum UpdateType {
        FULL,
        STATUS_ONLY,
        REARRANGE_PARENT_CHILDREN;

    }
}

