/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.dto.result;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.katalon.execution.dto.result.SelfHealingInfo;
import com.katalon.execution.dto.result.TestEntityExecutionResult;
import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.ExecutionTestResult;
import com.katalon.execution.model.logrecord.LogRecord;
import com.katalon.execution.model.logrecord.MessageLogRecord;
import com.katalon.execution.model.logrecord.TestCaseLogRecord;
import com.katalon.execution.model.logrecord.TestStepLogRecord;
import com.katalon.execution.model.logrecord.TestSuiteLogRecord;
import com.katalon.execution.model.steps.TestListenerExecution;

public class TestStepExecutionResult
extends TestEntityExecutionResult {
    @JsonProperty(value="selfHealingInfo")
    private SelfHealingInfo selfHealingInfo;

    public TestStepExecutionResult(TestEntityExecutionResult.TestExecutionType type) {
        this.type = type;
    }

    public static TestStepExecutionResult fromLogRecord(TestStepLogRecord logRecord, String parentId) {
        TestEntityExecutionResult.TestExecutionType type = TestEntityExecutionResult.TestExecutionType.TEST_STEP;
        if (logRecord.getParent() instanceof TestSuiteLogRecord) {
            type = TestEntityExecutionResult.TestExecutionType.TEST_STEP_OF_TEST_SUITE;
        } else if (logRecord.isTestListenerStep()) {
            type = TestEntityExecutionResult.TestExecutionType.TEST_CASE_LISTENER;
        }
        TestStepExecutionResult result = new TestStepExecutionResult(type);
        result.id = logRecord.getId().toString();
        result.name = logRecord.getName();
        result.description = logRecord.getDescription();
        result.startTime = TestStepExecutionResult.getTimeString(logRecord.getStartTime());
        result.endTime = TestStepExecutionResult.getTimeString(logRecord.getEndTime());
        for (LogRecord childLogRecord : logRecord.getChildRecords()) {
            if (!(childLogRecord instanceof MessageLogRecord)) continue;
            MessageLogRecord messageLogRecord = (MessageLogRecord)childLogRecord;
            result.messages.add(TestEntityExecutionResult.LogMessage.fromLogRecord(messageLogRecord));
        }
        if (logRecord.isSelfHealingApplied()) {
            SelfHealingInfo selfHealingInfo = new SelfHealingInfo();
            selfHealingInfo.applied = true;
            result.setSelfHealingInfo(selfHealingInfo);
        }
        if (result.startTime != null) {
            result.executionJobStatus = result.endTime != null ? ExecutionJobStatus.COMPLETED : ExecutionJobStatus.RUNNING;
        }
        ExecutionTestResult testResult = ExecutionTestResult.fromTestStatusValue(logRecord.getTestStatus().getStatusValue());
        result.executionTestResult = TestStepExecutionResult.resolveTestResult(result.executionJobStatus, testResult);
        if (result.executionTestResult != ExecutionTestResult.PASSED) {
            result.failedReason = logRecord.getFailedReason();
            result.failedTestCaseId = TestStepExecutionResult.findTestCaseId(logRecord);
        }
        result.parentId = parentId;
        return result;
    }

    public static TestStepExecutionResult fromListenerTestStep(TestListenerExecution testListenerExecution, String parentId) {
        TestStepExecutionResult result = new TestStepExecutionResult(TestEntityExecutionResult.TestExecutionType.TEST_STEP_OF_TEST_SUITE);
        result.id = testListenerExecution.getId().toString();
        result.name = testListenerExecution.getName();
        result.startTime = TestStepExecutionResult.getTimeString(testListenerExecution.getStartDate());
        result.endTime = TestStepExecutionResult.getTimeString(testListenerExecution.getEndDate());
        result.retryCount = 0;
        for (LogRecord childLogRecord : testListenerExecution.getLogRecords()) {
            if (!(childLogRecord instanceof MessageLogRecord)) continue;
            MessageLogRecord messageLogRecord = (MessageLogRecord)childLogRecord;
            result.messages.add(TestEntityExecutionResult.LogMessage.fromLogRecord(messageLogRecord));
        }
        if (result.startTime != null) {
            result.executionJobStatus = result.endTime != null ? ExecutionJobStatus.COMPLETED : ExecutionJobStatus.RUNNING;
        }
        result.executionTestResult = ExecutionTestResult.PASSED;
        result.parentId = parentId;
        return result;
    }

    public SelfHealingInfo getSelfHealingInfo() {
        return this.selfHealingInfo;
    }

    public void setSelfHealingInfo(SelfHealingInfo selfHealingInfo) {
        this.selfHealingInfo = selfHealingInfo;
    }

    private static String findTestCaseId(LogRecord logRecord) {
        LogRecord current = logRecord.getParent();
        while (current != null) {
            if (current instanceof TestCaseLogRecord) {
                return current.getName();
            }
            current = current.getParent();
        }
        return null;
    }
}

