/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.dto.result;

import com.katalon.execution.dto.result.MaskableContextParam;
import com.katalon.execution.dto.result.TestEntityExecutionResult;
import com.katalon.execution.model.ExecutionTestResult;
import com.katalon.execution.model.logrecord.TestSuiteLogRecord;
import com.katalon.execution.model.settings.TestSuiteRerunSettings;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecutionAttempt;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TestSuiteExecutionResult
extends TestEntityExecutionResult {
    public TestSuiteExecutionResult(TestEntityExecutionResult.TestExecutionType type) {
        this.type = type;
    }

    public static TestSuiteExecutionResult fromTestSuiteExecutionAttempt(TestSuiteExecutionAttempt attempt, String parentId) {
        TestSuiteExecutionResult result = new TestSuiteExecutionResult(TestEntityExecutionResult.TestExecutionType.TEST_SUITE_ATTEMPT);
        result.id = attempt.getId().toString();
        result.shortDisplayName = result.name = attempt.getTestSuite().getIdForDisplay();
        if (attempt.getAttemptIndex() > 0) {
            TestSuiteRerunSettings.RetryStrategy retryStrategy = attempt.getExecutionSettings().getTestSuiteRerunSettings().getRetryStrategy();
            int maxRetryCount = attempt.getExecutionSettings().getTestSuiteRerunSettings().getMaxRetryCount();
            switch (retryStrategy) {
                case ALL_EXECUTIONS: {
                    result.shortDisplayName = String.format("Retry attempt %d/%d", attempt.getAttemptIndex(), maxRetryCount);
                    break;
                }
                case FAILED_EXECUTIONS: {
                    result.shortDisplayName = String.format("Retry attempt %d/%d", attempt.getAttemptIndex(), maxRetryCount);
                    break;
                }
            }
        } else {
            TestSuiteExecution parentExecution;
            EntityExecution entityExecution = attempt.getParentEntityExecution();
            if (entityExecution instanceof TestSuiteExecution && (parentExecution = (TestSuiteExecution)entityExecution).getAttempts().size() > 1) {
                result.shortDisplayName = "First execution";
            }
        }
        result.description = attempt.getTestSuite().getDescription();
        result.startTime = TestSuiteExecutionResult.getTimeString(attempt.getStartDate());
        result.endTime = TestSuiteExecutionResult.getTimeString(attempt.getEndDate());
        result.retryCount = attempt.getAttemptIndex();
        result.executionInfo = TestSuiteExecutionResult.buildExecutionInfo(attempt);
        result.executionJobStatus = attempt.getExecutionJobStatus();
        attempt.getTestResult().ifPresent(v -> {
            ExecutionTestResult executionTestResult = testSuiteExecutionResult.executionTestResult = v;
        });
        attempt.determineFinalTestFailedReason().ifPresent(v -> {
            String string = testSuiteExecutionResult.failedReason = v;
        });
        result.parentId = parentId;
        if (result.executionTestResult != ExecutionTestResult.PASSED && attempt.getExecutionSettings() != null && attempt.getExecutionSettings().getRunConfiguration() != null && attempt.getExecutionSettings().getRunConfiguration().getExecution() != null && attempt.getExecutionSettings().getRunConfiguration().getExecution().getGeneral() != null && attempt.getExecutionSettings().getExecutionDirPath() != null && attempt.getExecutionSettings().getExecutionDirPath().toAbsolutePath().toString() != "") {
            result.timeCapsuleEnabled = attempt.getExecutionSettings().getRunConfiguration().getExecution().getGeneral().getTimeCapsuleEnabled();
            result.executionDirPath = attempt.getExecutionSettings().getExecutionDirPath().toAbsolutePath().toString();
            result.failedTestCaseId = attempt.getTestCaseExecutions().stream().filter(tc -> tc.isErrorOrFailed()).findFirst().map(tc -> tc.getTestCaseId()).orElse(null);
        }
        return result;
    }

    public static TestSuiteExecutionResult fromTestSuiteExecution(TestSuiteExecution testSuiteExecution, String parentId, String anchorChildId) {
        TestSuiteExecutionResult result = new TestSuiteExecutionResult(TestEntityExecutionResult.TestExecutionType.TEST_SUITE);
        result.id = testSuiteExecution.getId().toString();
        result.name = testSuiteExecution.getTestSuite().getIdForDisplay();
        result.description = testSuiteExecution.getTestSuite().getDescription();
        TestSuiteExecutionAttempt firstAttempt = testSuiteExecution.getFirstAttempt();
        TestSuiteExecutionAttempt lastAttempt = testSuiteExecution.getLastAttempt();
        result.startTime = TestSuiteExecutionResult.getTimeString(firstAttempt.getStartDate());
        result.endTime = TestSuiteExecutionResult.getTimeString(lastAttempt.getEndDate());
        result.executionInfo = TestSuiteExecutionResult.buildExecutionInfo(testSuiteExecution.getFirstAttempt());
        result.executionJobStatus = testSuiteExecution.getExecutionJobStatus();
        testSuiteExecution.getTestResult().ifPresent(v -> {
            ExecutionTestResult executionTestResult = testSuiteExecutionResult.executionTestResult = v;
        });
        testSuiteExecution.determineFinalTestFailedReason().ifPresent(v -> {
            String string = testSuiteExecutionResult.failedReason = v;
        });
        if (StringUtils.isNotBlank((CharSequence)anchorChildId)) {
            result.anchorChildId = anchorChildId;
            result.updateType = TestEntityExecutionResult.UpdateType.REARRANGE_PARENT_CHILDREN;
        } else {
            result.parentId = parentId;
        }
        return result;
    }

    private static List<MaskableContextParam> buildExecutionInfo(TestSuiteExecutionAttempt attempt) {
        TestSuiteLogRecord testSuiteLogRecord = attempt.getTestSuiteLogRecord();
        if (testSuiteLogRecord != null) {
            return TestSuiteExecutionResult.buildExecutionInfo(testSuiteLogRecord.getRunData());
        }
        return List.of();
    }
}

