/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.model.settings;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.katalon.capability.constant.DriverType;
import com.katalon.capability.constant.RemoteDriverType;
import com.katalon.execution.constant.ExecutionDriverType;
import com.katalon.execution.model.settings.SerializableMap;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DriversProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="system")
    private DriverSystemPropertiesMap systemProps = new DriverSystemPropertiesMap();
    @JsonProperty(value="preferences")
    private DriverPreferencesPropertiesMap preferencesProps = new DriverPreferencesPropertiesMap();

    public DriverSystemPropertiesMap getSystemProps() {
        return this.systemProps;
    }

    public void setSystemProps(DriverSystemPropertiesMap systemProps) {
        this.systemProps = systemProps;
    }

    public DriverPreferencesPropertiesMap getPreferencesProps() {
        return this.preferencesProps;
    }

    public void setPreferencesProps(DriverPreferencesPropertiesMap preferencesProps) {
        this.preferencesProps = preferencesProps;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class DriverPreferencesProperties
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected SerializableMap customProps = new SerializableMap();

        @JsonAnyGetter
        public SerializableMap getCustomProps() {
            return this.customProps;
        }

        public void setCustomProps(SerializableMap customProps) {
            this.customProps = customProps;
        }
    }

    @JsonSerialize(using=ExecutionDriverTypeMapSerializer.class)
    public static class DriverPreferencesPropertiesMap
    extends HashMap<ExecutionDriverType, DriverPreferencesProperties>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public static DriverPreferencesPropertiesMap of(ExecutionDriverType executionDriverType, DriverPreferencesProperties driverPreferencesProperties) {
            DriverPreferencesPropertiesMap map = new DriverPreferencesPropertiesMap();
            map.put(executionDriverType, driverPreferencesProperties);
            return map;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class DriverSystemProperties
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="browserType")
        private DriverType browserType;
        @JsonProperty(value="chromeDriverPath")
        private String chromeDriverPath;
        @JsonProperty(value="geckoDriverPath")
        private String firefoxDriverPath;
        @JsonProperty(value="edgeChromiumDriverPath")
        private String edgeChromiumDriverPath;
        @JsonProperty(value="appiumDirectory")
        private String appiumDirectory;
        @JsonProperty(value="appiumLogFile")
        private String appiumLogFile;
        @JsonProperty(value="appiumLogLevel")
        private String appiumLogLevel;
        @JsonProperty(value="deviceId")
        private String deviceId;
        @JsonProperty(value="devicePlatform")
        private MobileDriverType mobileDriverType;
        private String deviceOS;
        private String deviceOSVersion;
        private String deviceModel;
        private String deviceManufacturer;
        private String deviceName;
        @JsonProperty(value="deviceConsolePath")
        private String iosDeviceConsolePath;

        public String getIosDeviceConsolePath() {
            return this.iosDeviceConsolePath;
        }

        public void setIosDeviceConsolePath(String iosDeviceConsolePath) {
            this.iosDeviceConsolePath = iosDeviceConsolePath;
        }

        public String getAppiumDirectory() {
            return this.appiumDirectory;
        }

        public void setAppiumDirectory(String appiumDirectory) {
            this.appiumDirectory = appiumDirectory;
        }

        public String getAppiumLogFile() {
            return this.appiumLogFile;
        }

        public void setAppiumLogFile(String appiumLogFile) {
            this.appiumLogFile = appiumLogFile;
        }

        public String getAppiumLogLevel() {
            return this.appiumLogLevel;
        }

        public void setAppiumLogLevel(String appiumLogLevel) {
            this.appiumLogLevel = appiumLogLevel;
        }

        public DriverType getBrowserType() {
            return this.browserType;
        }

        public void setBrowserType(DriverType browserType) {
            this.browserType = browserType;
        }

        public String getChromeDriverPath() {
            return this.chromeDriverPath;
        }

        public void setChromeDriverPath(String chromeDriverPath) {
            this.chromeDriverPath = chromeDriverPath;
        }

        public String getFirefoxDriverPath() {
            return this.firefoxDriverPath;
        }

        public void setFirefoxDriverPath(String firefoxDriverPath) {
            this.firefoxDriverPath = firefoxDriverPath;
        }

        public String getEdgeChromiumDriverPath() {
            return this.edgeChromiumDriverPath;
        }

        public void setEdgeChromiumDriverPath(String edgeChromiumDriverPath) {
            this.edgeChromiumDriverPath = edgeChromiumDriverPath;
        }

        public String getDeviceId() {
            return this.deviceId;
        }

        public void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public MobileDriverType getMobileDriverType() {
            return this.mobileDriverType;
        }

        public void setMobileDriverType(MobileDriverType mobileDriverType) {
            this.mobileDriverType = mobileDriverType;
        }

        public String getDeviceOS() {
            return this.deviceOS;
        }

        public void setDeviceOS(String deviceOS) {
            this.deviceOS = deviceOS;
        }

        public String getDeviceOSVersion() {
            return this.deviceOSVersion;
        }

        public void setDeviceOSVersion(String deviceOSVersion) {
            this.deviceOSVersion = deviceOSVersion;
        }

        public String getDeviceModel() {
            return this.deviceModel;
        }

        public void setDeviceModel(String deviceModel) {
            this.deviceModel = deviceModel;
        }

        public String getDeviceManufacturer() {
            return this.deviceManufacturer;
        }

        public void setDeviceManufacturer(String deviceManufacturer) {
            this.deviceManufacturer = deviceManufacturer;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }
    }

    @JsonSerialize(using=ExecutionDriverTypeMapSerializer.class)
    public static class DriverSystemPropertiesMap
    extends HashMap<ExecutionDriverType, DriverSystemProperties>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public static DriverSystemPropertiesMap of(ExecutionDriverType executionDriverType, ExistingDriverSystemProperties systemProps) {
            DriverSystemPropertiesMap map = new DriverSystemPropertiesMap();
            map.put(executionDriverType, systemProps);
            return map;
        }
    }

    private static class ExecutionDriverTypeMapSerializer
    extends JsonSerializer<Map<ExecutionDriverType, ?>> {
        private ExecutionDriverTypeMapSerializer() {
        }

        public void serialize(Map<ExecutionDriverType, ?> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value == null) {
                gen.writeNull();
                return;
            }
            gen.writeStartObject();
            for (Map.Entry<ExecutionDriverType, ?> entry : value.entrySet()) {
                if (entry.getKey() == null) continue;
                gen.writeObjectField(entry.getKey().getName(), entry.getValue());
            }
            gen.writeEndObject();
        }
    }

    public static class ExistingDriverSystemProperties
    extends DriverSystemProperties {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="existingSession.sessionId")
        private String sessionId;
        @JsonProperty(value="existingSession.serverUrl")
        private String remoteServerUrl;
        @JsonProperty(value="existingSession.webSocketUrl")
        private String webSocketUrl;
        @JsonProperty(value="existingSession.driverType")
        private String driverType;

        public String getSessionId() {
            return this.sessionId;
        }

        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public String getRemoteServerUrl() {
            return this.remoteServerUrl;
        }

        public void setRemoteServerUrl(String remoteServerUrl) {
            this.remoteServerUrl = remoteServerUrl;
        }

        public String getWebSocketUrl() {
            return this.webSocketUrl;
        }

        public void setWebSocketUrl(String webSocketUrl) {
            this.webSocketUrl = webSocketUrl;
        }

        public String getDriverType() {
            return this.driverType;
        }

        public void setDriverType(String driverType) {
            this.driverType = driverType;
        }
    }

    public static class RemoteDriverSystemProperties
    extends DriverSystemProperties {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="isEncrypted")
        private Boolean isRemoteWebDriverUrlEncrypted;
        @JsonProperty(value="remoteWebDriverUrl")
        private String remoteWebDriverUrl;
        @JsonProperty(value="remoteWebDriverType")
        @JsonSerialize(using=RemoteDriverTypeDisplayNameSerializer.class)
        private RemoteDriverType remoteWebDriverType;
        @JsonProperty(value="remoteMobileDriver")
        private MobileDriverType remoteMobileDriverType;

        public Boolean getIsRemoteWebDriverUrlEncrypted() {
            return this.isRemoteWebDriverUrlEncrypted;
        }

        public void setIsRemoteWebDriverUrlEncrypted(Boolean isRemoteWebDriverUrlEncrypted) {
            this.isRemoteWebDriverUrlEncrypted = isRemoteWebDriverUrlEncrypted;
        }

        public String getRemoteWebDriverUrl() {
            return this.remoteWebDriverUrl;
        }

        public void setRemoteWebDriverUrl(String remoteWebDriverUrl) {
            this.remoteWebDriverUrl = remoteWebDriverUrl;
        }

        public RemoteDriverType getRemoteWebDriverType() {
            return this.remoteWebDriverType;
        }

        public void setRemoteWebDriverType(RemoteDriverType remoteWebDriverType) {
            this.remoteWebDriverType = remoteWebDriverType;
        }

        public MobileDriverType getRemoteMobileDriverType() {
            return this.remoteMobileDriverType;
        }

        public void setRemoteMobileDriverType(MobileDriverType remoteMobileDriverType) {
            this.remoteMobileDriverType = remoteMobileDriverType;
        }
    }

    private static class RemoteDriverTypeDisplayNameSerializer
    extends JsonSerializer<RemoteDriverType> {
        private RemoteDriverTypeDisplayNameSerializer() {
        }

        public void serialize(RemoteDriverType value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value == null) {
                gen.writeNull();
                return;
            }
            gen.writeString(value.getDisplayName());
        }
    }

    public static class TestCloudDesktopBrowserPreferencesProperties
    extends DriverPreferencesProperties {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="browserName")
        private String browserName;
        @JsonProperty(value="browserVersion")
        private String browserVersion;
        @JsonProperty(value="platformName")
        private String platformName;
        @JsonProperty(value="katalon:options")
        private SerializableMap katalonOptions;

        public String getBrowserName() {
            return this.browserName;
        }

        public void setBrowserName(String browserName) {
            this.browserName = browserName;
        }

        public String getBrowserVersion() {
            return this.browserVersion;
        }

        public void setBrowserVersion(String browserVersion) {
            this.browserVersion = browserVersion;
        }

        public String getPlatformName() {
            return this.platformName;
        }

        public void setPlatformName(String platformName) {
            this.platformName = platformName;
        }

        public SerializableMap getKatalonOptions() {
            return this.katalonOptions;
        }

        public void setKatalonOptions(SerializableMap katalonOptions) {
            this.katalonOptions = katalonOptions;
        }
    }

    public static class TestCloudDriverSystemProperties
    extends RemoteDriverSystemProperties {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="testCloudRemoteOS")
        private String testCloudRemoteOs;
        @JsonProperty(value="readTimeout")
        @JsonFormat(shape=JsonFormat.Shape.STRING)
        private int testCloudReadTimeout;

        public String getTestCloudRemoteOs() {
            return this.testCloudRemoteOs;
        }

        public void setTestCloudRemoteOs(String testCloudRemoteOs) {
            this.testCloudRemoteOs = testCloudRemoteOs;
        }

        public int getTestCloudReadTimeout() {
            return this.testCloudReadTimeout;
        }

        public void setTestCloudReadTimeout(int testCloudReadTimeout) {
            this.testCloudReadTimeout = testCloudReadTimeout;
        }
    }

    public static class TestCloudMobileDevicePreferencesProperties
    extends DriverPreferencesProperties {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="browserName")
        private String browserName;
        @JsonProperty(value="browserVersion")
        private String browserVersion;
        @JsonProperty(value="platformName")
        private String platformName;
        @JsonProperty(value="appium:deviceName")
        private String deviceName;
        @JsonProperty(value="appium:platformVersion")
        private String platformVersion;
        @JsonProperty(value="appium:udid")
        private String deviceUdid;
        @JsonProperty(value="testCloudOverrideMobileApplication")
        private String testCloudOverrideMobileApplication;
        @JsonProperty(value="katalon:options")
        private SerializableMap katalonOptions;

        public String getBrowserName() {
            return this.browserName;
        }

        public void setBrowserName(String browserName) {
            this.browserName = browserName;
        }

        public String getBrowserVersion() {
            return this.browserVersion;
        }

        public void setBrowserVersion(String browserVersion) {
            this.browserVersion = browserVersion;
        }

        public String getPlatformName() {
            return this.platformName;
        }

        public void setPlatformName(String platformName) {
            this.platformName = platformName;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public String getPlatformVersion() {
            return this.platformVersion;
        }

        public void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public String getDeviceUdid() {
            return this.deviceUdid;
        }

        public void setDeviceUdid(String deviceUdid) {
            this.deviceUdid = deviceUdid;
        }

        public String getTestCloudOverrideMobileApplication() {
            return this.testCloudOverrideMobileApplication;
        }

        public void setTestCloudOverrideMobileApplication(String testCloudOverrideMobileApplication) {
            this.testCloudOverrideMobileApplication = testCloudOverrideMobileApplication;
        }

        public SerializableMap getKatalonOptions() {
            return this.katalonOptions;
        }

        public void setKatalonOptions(SerializableMap katalonOptions) {
            this.katalonOptions = katalonOptions;
        }
    }

    public static class WindowsPreferencesProperties
    extends DriverPreferencesProperties {
        public static final long serialVersionUID = 1L;
        @JsonProperty(value="desktopDriverUrl")
        private String desktopDriverUrl;

        public String getDesktopDriverUrl() {
            return this.desktopDriverUrl;
        }

        public void setDesktopDriverUrl(String desktopDriverUrl) {
            this.desktopDriverUrl = desktopDriverUrl;
        }
    }
}

