/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.model.steps;

import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.ExecutionTestResult;
import com.katalon.execution.model.steps.TestExecutionStep;
import com.katalon.execution.model.steps.TestListenerExecution;
import com.katalon.execution.model.steps.TestResultStatistics;
import com.katalon.execution.model.steps.testsuite.TestSuiteCollectionExecution;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public abstract class EntityExecution
extends TestExecutionStep {
    protected List<TestListenerExecution> beforeListeners = new ArrayList<TestListenerExecution>();
    protected List<TestListenerExecution> afterListeners = new ArrayList<TestListenerExecution>();
    protected Optional<ExecutionTestResult> testResult = Optional.empty();
    protected Optional<String> testFailedReason = Optional.empty();
    protected final TestResultStatistics descendantTestCaseStats = new TestResultStatistics();

    protected EntityExecution() {
    }

    protected EntityExecution(UUID uuid) {
        super(uuid);
    }

    public abstract int getTestCaseCount();

    public abstract int getExecutedTestCaseCount();

    public abstract String getName();

    public abstract void onPlanChanged();

    public abstract void onPlanTerminated();

    public abstract void onLaunchEnded();

    public abstract void onDescendantTestCaseResultChange(Optional<ExecutionTestResult> var1, ExecutionTestResult var2);

    public abstract void onDescendantTestCaseResultChange(ExecutionJobStatus var1);

    public abstract void onChildExecutionEnded(EntityExecution var1);

    public boolean isErrorOrFailed() {
        return this.testResult.isPresent() && this.testResult.get().isErrorOrFailed();
    }

    public JobProgress buildJobProgress() {
        return new JobProgress(this.getExecutedTestCaseCount(), this.getTestCaseCount());
    }

    @Override
    public void updateJobStatus(ExecutionJobStatus executionJobStatus, Optional<Date> timestamp, Optional<String> jobFailedReason) {
        EntityExecution parentEntityExecution;
        super.updateJobStatus(executionJobStatus, timestamp, jobFailedReason);
        if (executionJobStatus.isFinal() && (parentEntityExecution = this.getParentEntityExecution()) != null) {
            parentEntityExecution.onChildExecutionEnded(this);
        }
    }

    public void updateTestFailedReasonAndPropagateUp(String reason) {
        if (this.testFailedReason.isPresent()) {
            return;
        }
        this.testFailedReason = Optional.ofNullable(reason);
        EntityExecution parentEntityExecution = this.getParentEntityExecution();
        if (parentEntityExecution != null) {
            parentEntityExecution.updateTestFailedReasonAndPropagateUp(reason);
        }
    }

    public void clearFailedReasonAndPropagateUp() {
        if (this.testFailedReason.isEmpty()) {
            return;
        }
        this.testFailedReason = Optional.empty();
        EntityExecution parentEntityExecution = this.getParentEntityExecution();
        if (parentEntityExecution != null) {
            parentEntityExecution.clearFailedReasonAndPropagateUp();
        }
    }

    public EntityExecution getParentEntityExecution() {
        TestExecutionStep testExecutionStep = this.parent;
        if (testExecutionStep instanceof EntityExecution) {
            EntityExecution parentEntityExecution = (EntityExecution)testExecutionStep;
            return parentEntityExecution;
        }
        return null;
    }

    public TestSuiteCollectionExecution getTSCExecution() {
        TestExecutionStep testExecutionStep;
        if (this.parent != null && (testExecutionStep = this.parent.getParent()) instanceof TestSuiteCollectionExecution) {
            TestSuiteCollectionExecution tscExecution = (TestSuiteCollectionExecution)testExecutionStep;
            return tscExecution;
        }
        return null;
    }

    public void addBeforeListenerStep(TestListenerExecution listenerExecution) {
        this.beforeListeners.add(listenerExecution);
        listenerExecution.setParent(this);
    }

    public void addAfterListenerStep(TestListenerExecution listenerExecution) {
        this.afterListeners.add(listenerExecution);
        listenerExecution.setParent(this);
    }

    public void updateTestResultAndJobStatus(ExecutionTestResult newTestResult, ExecutionJobStatus newJobStatus) {
        this.testResult = Optional.of(newTestResult);
        this.updateJobStatus(newJobStatus);
    }

    public int determineExitCode() {
        if (this.descendantTestCaseStats.hasFailed()) {
            if (this.descendantTestCaseStats.hasError()) {
                return 3;
            }
            return 1;
        }
        if (this.descendantTestCaseStats.hasError()) {
            return 2;
        }
        return 0;
    }

    public Optional<String> determineFinalTestFailedReason() {
        if (this.testResult.isEmpty()) {
            return Optional.empty();
        }
        return this.testFailedReason;
    }

    public List<TestListenerExecution> getBeforeListeners() {
        return this.beforeListeners;
    }

    public void setBeforeListeners(List<TestListenerExecution> beforeListeners) {
        this.beforeListeners = beforeListeners;
    }

    public List<TestListenerExecution> getAfterListeners() {
        return this.afterListeners;
    }

    public void setAfterListeners(List<TestListenerExecution> afterListeners) {
        this.afterListeners = afterListeners;
    }

    public Optional<ExecutionTestResult> getTestResult() {
        return this.testResult;
    }

    public TestResultStatistics getDescendantTestCaseStats() {
        return this.descendantTestCaseStats;
    }

    public Optional<String> getTestFailedReason() {
        return this.testFailedReason;
    }

    public record JobProgress(int executedUnits, int totalUnits) {
    }
}

