/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.model.steps;

import com.katalon.execution.model.ExecutionJobStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public abstract class TestExecutionStep {
    protected final UUID id;
    protected Date startDate;
    protected Date endDate;
    protected ExecutionJobStatus executionJobStatus = ExecutionJobStatus.PENDING;
    protected Optional<String> jobFailedReason = Optional.empty();
    protected TestExecutionStep parent;
    protected List<TestExecutionStep> children = new ArrayList<TestExecutionStep>();

    protected TestExecutionStep() {
        this(UUID.randomUUID());
    }

    protected TestExecutionStep(UUID uuid) {
        this.id = uuid;
    }

    public abstract String getTitle();

    public abstract boolean isPausible();

    public void start() {
        if (this.executionJobStatus != ExecutionJobStatus.PENDING) {
            throw new IllegalStateException("Cannot start execution step from status: " + String.valueOf((Object)this.executionJobStatus));
        }
        this.updateJobStatus(ExecutionJobStatus.RUNNING);
    }

    public void stop() {
        if (this.executionJobStatus != ExecutionJobStatus.RUNNING) {
            throw new IllegalStateException("Cannot stop execution step from status: " + String.valueOf((Object)this.executionJobStatus));
        }
        this.updateJobStatus(ExecutionJobStatus.TERMINATED);
    }

    public void addChild(TestExecutionStep child) {
        this.children.add(child);
        child.setParent(this);
    }

    public String getIdString() {
        return this.id == null ? null : this.id.toString();
    }

    public String getParentIdString() {
        return this.parent == null ? null : this.parent.getIdString();
    }

    public Optional<Integer> getDurationInMilliseconds() {
        if (this.startDate != null && this.endDate != null) {
            return Optional.of((int)(this.endDate.getTime() - this.startDate.getTime()));
        }
        return Optional.empty();
    }

    public void updateJobStatus(ExecutionJobStatus executionJobStatus, Optional<Date> timestamp, Optional<String> jobFailedReason) {
        this.executionJobStatus = executionJobStatus;
        this.jobFailedReason = jobFailedReason;
        if (executionJobStatus == ExecutionJobStatus.RUNNING && this.startDate == null) {
            this.startDate = timestamp.orElse(new Date());
        }
        if (executionJobStatus.isFinal() && this.endDate == null) {
            this.endDate = timestamp.orElse(new Date());
        }
        if (executionJobStatus == ExecutionJobStatus.RUNNING && this.parent != null && this.parent.getExecutionJobStatus() == ExecutionJobStatus.PENDING) {
            this.parent.updateJobStatus(ExecutionJobStatus.RUNNING, Optional.of(this.startDate), jobFailedReason);
        }
    }

    public void updateJobStatus(ExecutionJobStatus executionJobStatus, String jobFailedReason) {
        this.updateJobStatus(executionJobStatus, Optional.empty(), Optional.ofNullable(jobFailedReason));
    }

    public void updateJobStatus(ExecutionJobStatus executionJobStatus) {
        this.updateJobStatus(executionJobStatus, Optional.empty(), Optional.empty());
    }

    public String toString() {
        return String.format("%s(%s)", this.getClass().getSimpleName(), TestExecutionStep.shortId(this.getIdString()));
    }

    private static String shortId(String id) {
        if (id == null) {
            return "N/A";
        }
        if (id.length() <= 8) {
            return id;
        }
        return id.substring(0, 8);
    }

    public UUID getId() {
        return this.id;
    }

    public TestExecutionStep getParent() {
        return this.parent;
    }

    public void setParent(TestExecutionStep parent) {
        this.parent = parent;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public ExecutionJobStatus getExecutionJobStatus() {
        return this.executionJobStatus;
    }

    public Optional<String> getJobFailedReason() {
        return this.jobFailedReason;
    }

    public List<TestExecutionStep> getChildren() {
        return Collections.unmodifiableList(this.children);
    }
}

