/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.model.steps;

import com.katalon.execution.model.ExecutionTestResult;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;

public class TestResultStatistics {
    private final EnumMap<ExecutionTestResult, Integer> testResultCount = new EnumMap(ExecutionTestResult.class);
    private int totalCount = 0;

    public TestResultStatistics() {
        this.reset();
    }

    public void recalculateFromOtherStats(List<TestResultStatistics> others) {
        this.reset();
        this.setTotalCount(others.stream().mapToInt(stats -> stats.totalCount).sum());
        ExecutionTestResult[] executionTestResultArray = ExecutionTestResult.values();
        int n = executionTestResultArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutionTestResult result = executionTestResultArray[n2];
            int totalForResult = others.stream().mapToInt(stats -> stats.testResultCount.getOrDefault((Object)result, 0)).sum();
            this.testResultCount.put(result, totalForResult);
            ++n2;
        }
    }

    public void recalculateFromTestResults(List<ExecutionTestResult> testResults) {
        this.reset();
        this.setTotalCount(testResults.size());
        for (ExecutionTestResult result : testResults) {
            this.testResultCount.computeIfPresent(result, (k, v) -> v + 1);
        }
    }

    public void recordChange(Optional<ExecutionTestResult> oldTestResult, ExecutionTestResult newTestResult) {
        if (oldTestResult.isPresent()) {
            this.testResultCount.computeIfPresent(oldTestResult.get(), (k, v) -> v - 1);
        }
        this.testResultCount.computeIfPresent(newTestResult, (k, v) -> v + 1);
    }

    public int getExecutedTestCaseCount() {
        return this.testResultCount.values().stream().mapToInt(Integer::intValue).sum() - this.testResultCount.get((Object)ExecutionTestResult.NOT_RUN) - this.testResultCount.get((Object)ExecutionTestResult.INCOMPLETE);
    }

    public void removeErrorOrFailedCases() {
        this.testResultCount.put(ExecutionTestResult.ERROR, 0);
        this.testResultCount.put(ExecutionTestResult.FAILED, 0);
    }

    public void reset() {
        this.testResultCount.clear();
        ExecutionTestResult[] executionTestResultArray = ExecutionTestResult.values();
        int n = executionTestResultArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutionTestResult result = executionTestResultArray[n2];
            this.testResultCount.put(result, 0);
            ++n2;
        }
    }

    public Optional<ExecutionTestResult> determineAggregatedResult() {
        int finishedCount = this.testResultCount.values().stream().mapToInt(Integer::intValue).sum();
        if (finishedCount < this.totalCount) {
            return Optional.empty();
        }
        if (this.testResultCount.get((Object)ExecutionTestResult.ERROR) > 0) {
            return Optional.of(ExecutionTestResult.ERROR);
        }
        if (this.testResultCount.get((Object)ExecutionTestResult.FAILED) > 0) {
            return Optional.of(ExecutionTestResult.FAILED);
        }
        int warningOrPassed = this.testResultCount.get((Object)ExecutionTestResult.WARNING) + this.testResultCount.get((Object)ExecutionTestResult.PASSED);
        if (warningOrPassed > 0) {
            return Optional.of(ExecutionTestResult.PASSED);
        }
        if (this.testResultCount.get((Object)ExecutionTestResult.SKIPPED) > 0) {
            return Optional.of(ExecutionTestResult.SKIPPED);
        }
        return Optional.of(ExecutionTestResult.INCOMPLETE);
    }

    public boolean hasFailedOrError() {
        return this.hasFailed() || this.hasError();
    }

    public boolean hasFailed() {
        return this.testResultCount.get((Object)ExecutionTestResult.FAILED) > 0;
    }

    public boolean hasError() {
        return this.testResultCount.get((Object)ExecutionTestResult.ERROR) > 0;
    }

    public int countFailedAndError() {
        return this.testResultCount.get((Object)ExecutionTestResult.FAILED) + this.testResultCount.get((Object)ExecutionTestResult.ERROR);
    }

    public String toString() {
        if (this.totalCount == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Total: ").append(this.totalCount);
        ExecutionTestResult[] executionTestResultArray = ExecutionTestResult.values();
        int n = executionTestResultArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutionTestResult result = executionTestResultArray[n2];
            if (this.testResultCount.get((Object)result) != 0) {
                sb.append(", ").append(result.name()).append(": ").append(this.testResultCount.get((Object)result));
            }
            ++n2;
        }
        return sb.toString();
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public EnumMap<ExecutionTestResult, Integer> getTestResultCount() {
        return this.testResultCount;
    }
}

