/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.model.steps.reporting;

import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.reporting.TestReporting;
import com.katalon.execution.model.steps.testsuite.TestSuiteCollectionExecution;
import com.kms.katalon.core.setting.ReportSettings;

public class TestReportGeneration
extends TestReporting {
    private final ReportFormat format;
    private final ReportSettings reportSettings;

    public TestReportGeneration(EntityExecution targetExecution, ReportFormat format, ReportSettings reportSettings) {
        super(targetExecution);
        this.format = format;
        this.reportSettings = reportSettings;
    }

    @Override
    public String getTitle() {
        return this.buildTitle();
    }

    @Override
    public boolean isPausible() {
        return false;
    }

    private String buildTitle() {
        String title = (switch (this.executionJobStatus) {
            case ExecutionJobStatus.PENDING -> "Generate";
            case ExecutionJobStatus.RUNNING -> "Generating";
            case ExecutionJobStatus.COMPLETED -> "Generated";
            case ExecutionJobStatus.ERROR, ExecutionJobStatus.TERMINATED, ExecutionJobStatus.FAILED -> "Failed to generate";
            default -> "Generate";
        }) + " " + this.format.displayName + " report";
        if (this.getTargetExecution().getParentEntityExecution() != null) {
            title = title + " for " + this.getTargetExecution().getName();
        } else if (this.getTargetExecution() instanceof TestSuiteCollectionExecution) {
            title = title + " for " + this.getTargetExecution().getName();
        }
        return title;
    }

    @Override
    public String toString() {
        return "TestReportGeneration{format=" + String.valueOf((Object)this.format) + ", target=" + String.valueOf(this.getTargetExecution()) + "}";
    }

    public ReportFormat getFormat() {
        return this.format;
    }

    public ReportSettings getReportSettings() {
        return this.reportSettings;
    }

    public static enum ReportFormat {
        JUNIT("JUnit"),
        HTML_TEST_SUITE("HTML"),
        CSV("CSV"),
        PDF("PDF"),
        CONSOLE_LOG("Console log", "console log"),
        HTML_TSC("HTML");

        private final String displayName;
        private final String trackingName;

        private ReportFormat(String displayName, String trackingName) {
            this.displayName = displayName;
            this.trackingName = trackingName;
        }

        private ReportFormat(String displayName) {
            this.displayName = displayName;
            this.trackingName = displayName;
        }

        public String getTrackingName() {
            return this.trackingName;
        }
    }
}

