/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.model.steps.reporting;

import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.reporting.TestReporting;
import com.katalon.execution.model.steps.testsuite.TestSuiteCollectionExecution;
import com.katalon.execution.services.IReportIntegrationProvider;
import java.util.HashMap;
import java.util.Map;

public class TestReportIntegration
extends TestReporting {
    private final IReportIntegrationProvider reportIntegrationProvider;
    private final Map<String, String> additionalInfo;

    public TestReportIntegration(EntityExecution targetExecution, IReportIntegrationProvider reportIntegrationProvider, Map<String, String> additionalInfo) {
        super(targetExecution);
        this.reportIntegrationProvider = reportIntegrationProvider;
        this.additionalInfo = additionalInfo != null ? additionalInfo : new HashMap();
    }

    @Override
    public String getTitle() {
        return this.buildTitle();
    }

    @Override
    public boolean isPausible() {
        return false;
    }

    private String buildTitle() {
        String title = (switch (this.executionJobStatus) {
            case ExecutionJobStatus.PENDING -> "Upload";
            case ExecutionJobStatus.RUNNING -> "Uploading";
            case ExecutionJobStatus.COMPLETED -> "Uploaded";
            case ExecutionJobStatus.ERROR, ExecutionJobStatus.TERMINATED, ExecutionJobStatus.FAILED -> "Failed to upload";
            default -> "Upload";
        }) + " Test Report to " + this.reportIntegrationProvider.getName();
        if (this.getTargetExecution().getParentEntityExecution() != null) {
            title = title + " for " + this.getTargetExecution().getName();
        } else if (this.getTargetExecution() instanceof TestSuiteCollectionExecution) {
            title = title + " for " + this.getTargetExecution().getName();
        }
        return title;
    }

    @Override
    public String toString() {
        return "TestReportIntegration{provider=" + this.reportIntegrationProvider.getName() + ", target=" + String.valueOf(this.getTargetExecution()) + "}";
    }

    public IReportIntegrationProvider getReportIntegrationProvider() {
        return this.reportIntegrationProvider;
    }

    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }
}

