/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.model.steps.testcase;

import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.ExecutionTestResult;
import com.katalon.execution.model.settings.ExecutionSettings;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.testcase.BaseTestCaseExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecution;
import com.kms.katalon.core.testcase.TestCaseBinding;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class TestCaseBindingExecution
extends BaseTestCaseExecution {
    private List<TestCaseExecution> iterations = new ArrayList<TestCaseExecution>();
    private List<TestCaseBinding> testCaseBindings = new ArrayList<TestCaseBinding>();

    public TestCaseBindingExecution(TestCaseEntity testCase, ExecutionSettings executionSettings) {
        super(testCase, executionSettings);
    }

    @Override
    public String getTitle() {
        return "Executing Test Case Binding";
    }

    @Override
    public int getTestCaseCount() {
        return this.descendantTestCaseStats.getTotalCount();
    }

    @Override
    public int getExecutedTestCaseCount() {
        return this.descendantTestCaseStats.getExecutedTestCaseCount();
    }

    @Override
    public void onPlanChanged() {
        int totalTestCases = this.iterations != null ? this.iterations.size() : 0;
        this.descendantTestCaseStats.setTotalCount(totalTestCases);
    }

    @Override
    public void onPlanTerminated() {
        if (this.executionJobStatus.isFinal() && this.testResult.isPresent()) {
            return;
        }
        for (TestCaseExecution iteration : this.iterations) {
            iteration.onPlanTerminated();
        }
        this.recalculateDescendantTestCaseStats();
        Optional<ExecutionTestResult> newAggregatedTestResult = this.descendantTestCaseStats.determineAggregatedResult();
        if (newAggregatedTestResult.isPresent()) {
            this.updateTestResultAndJobStatus(newAggregatedTestResult.get(), ExecutionJobStatus.TERMINATED);
        }
    }

    @Override
    public void onLaunchEnded() {
        if (this.executionJobStatus.isFinal() && this.testResult.isPresent()) {
            return;
        }
        for (TestCaseExecution iteration : this.iterations) {
            iteration.onLaunchEnded();
        }
        this.recalculateDescendantTestCaseStats();
        Optional<ExecutionTestResult> newAggregatedTestResult = this.descendantTestCaseStats.determineAggregatedResult();
        if (newAggregatedTestResult.isPresent()) {
            this.updateTestResultAndJobStatus(newAggregatedTestResult.get(), ExecutionJobStatus.FAILED);
        }
    }

    private void recalculateDescendantTestCaseStats() {
        this.descendantTestCaseStats.recalculateFromTestResults(this.iterations.stream().map(iteration -> iteration.getTestResult().orElse(null)).filter(result -> result != null).collect(Collectors.toList()));
    }

    @Override
    public void onDescendantTestCaseResultChange(Optional<ExecutionTestResult> oldTestResult, ExecutionTestResult newTestResult) {
        EntityExecution parentEntityExecution;
        this.descendantTestCaseStats.recordChange(oldTestResult, newTestResult);
        Optional<ExecutionTestResult> newAggregatedTestResult = this.descendantTestCaseStats.determineAggregatedResult();
        if (newAggregatedTestResult.isPresent()) {
            this.updateTestResultAndJobStatus(newAggregatedTestResult.get(), ExecutionJobStatus.COMPLETED);
        }
        if ((parentEntityExecution = this.getParentEntityExecution()) != null) {
            parentEntityExecution.onDescendantTestCaseResultChange(oldTestResult, newTestResult);
        }
    }

    @Override
    public void onDescendantTestCaseResultChange(ExecutionJobStatus reason) {
        EntityExecution parentEntityExecution;
        this.recalculateDescendantTestCaseStats();
        Optional<ExecutionTestResult> newAggregatedTestResult = this.descendantTestCaseStats.determineAggregatedResult();
        if (newAggregatedTestResult.isPresent()) {
            this.updateTestResultAndJobStatus(newAggregatedTestResult.get(), reason);
        }
        if ((parentEntityExecution = this.getParentEntityExecution()) != null) {
            parentEntityExecution.onDescendantTestCaseResultChange(reason);
        }
    }

    @Override
    public void onChildExecutionEnded(EntityExecution childExecution) {
    }

    public void addIterationWithBinding(TestCaseEntity testCaseEntity, TestCaseBinding testCaseBinding) {
        TestCaseExecution iteration = new TestCaseExecution(testCaseEntity, this.executionSettings, testCaseBinding.getTestCaseExecutionId());
        iteration.setParent(this);
        iteration.setIterationIndex(this.iterations.size());
        this.iterations.add(iteration);
        this.testCaseBindings.add(testCaseBinding);
    }

    public TestCaseExecution getFirstIteration() {
        if (this.iterations.size() == 0) {
            return null;
        }
        return this.iterations.get(0);
    }

    public TestCaseExecution getLastIteration() {
        if (this.iterations.size() == 0) {
            return null;
        }
        return this.iterations.get(this.iterations.size() - 1);
    }

    public List<TestCaseExecution> getIterations() {
        return this.iterations;
    }

    public void setIterations(List<TestCaseExecution> iterations) {
        this.iterations = iterations;
    }

    public List<TestCaseBinding> getTestCaseBindings() {
        return this.testCaseBindings;
    }

    public void setTestCaseBindings(List<TestCaseBinding> testCaseBindings) {
        this.testCaseBindings = testCaseBindings;
    }
}

