/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.model.steps.testcase;

import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.ExecutionTestResult;
import com.katalon.execution.model.settings.ExecutionSettings;
import com.katalon.execution.model.settings.TestSuiteRerunSettings;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.testcase.BaseTestCaseExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecutionAttempt;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class TestCaseExecution
extends BaseTestCaseExecution {
    private int iterationIndex = 0;
    private List<TestCaseExecutionAttempt> attempts = new ArrayList<TestCaseExecutionAttempt>();
    private Optional<SystemFileEntity> originalCucumberFeatureFileEntity = Optional.empty();

    public TestCaseExecution(TestCaseEntity testCase, ExecutionSettings executionSettings) {
        super(testCase, executionSettings);
        this.addNewAttempt();
    }

    public TestCaseExecution(TestCaseEntity testCase, ExecutionSettings executionSettings, UUID uuid) {
        super(testCase, executionSettings, uuid);
        this.addNewAttempt();
    }

    public TestCaseExecution(SystemFileEntity cucumberFeatureFileEntity, ExecutionSettings executionSettings) {
        super(TestCaseExecution.buildTemporaryTestCase(cucumberFeatureFileEntity), executionSettings);
        this.originalCucumberFeatureFileEntity = Optional.of(cucumberFeatureFileEntity);
        this.addNewAttempt();
    }

    private static TestCaseEntity buildTemporaryTestCase(SystemFileEntity cucumberFeatureFileEntity) {
        TestCaseEntity testCase = new TestCaseEntity();
        testCase.setId(cucumberFeatureFileEntity.getId());
        testCase.setName(cucumberFeatureFileEntity.getName());
        testCase.setProject(cucumberFeatureFileEntity.getProject());
        return testCase;
    }

    @Override
    public String getTitle() {
        return "Execute test case";
    }

    @Override
    public int getTestCaseCount() {
        return this.descendantTestCaseStats.getTotalCount();
    }

    @Override
    public int getExecutedTestCaseCount() {
        return this.descendantTestCaseStats.getExecutedTestCaseCount();
    }

    @Override
    public void onPlanChanged() {
        this.descendantTestCaseStats.setTotalCount(1);
    }

    @Override
    public void onPlanTerminated() {
        if (this.executionJobStatus.isFinal() && this.testResult.isPresent()) {
            return;
        }
        TestCaseExecutionAttempt lastAttempt = this.getLastAttempt();
        if (lastAttempt == null) {
            return;
        }
        lastAttempt.onPlanTerminated();
        if (lastAttempt.getTestResult().isEmpty()) {
            return;
        }
        ExecutionTestResult finalTestResult = lastAttempt.getTestResult().get();
        this.descendantTestCaseStats.recalculateFromTestResults(List.of(finalTestResult));
        this.updateTestResultAndJobStatus(finalTestResult, ExecutionJobStatus.TERMINATED);
    }

    @Override
    public void onLaunchEnded() {
        if (this.executionJobStatus.isFinal() && this.testResult.isPresent()) {
            return;
        }
        TestCaseExecutionAttempt lastAttempt = this.getLastAttempt();
        if (lastAttempt != null) {
            lastAttempt.onLaunchEnded();
        }
        if (lastAttempt.getTestResult().isEmpty()) {
            return;
        }
        ExecutionTestResult finalTestResult = lastAttempt.getTestResult().get();
        this.descendantTestCaseStats.recalculateFromTestResults(List.of(finalTestResult));
        this.updateTestResultAndJobStatus(finalTestResult, ExecutionJobStatus.FAILED);
    }

    @Override
    public void onDescendantTestCaseResultChange(Optional<ExecutionTestResult> oldTestResultOfLastAttempt, ExecutionTestResult newTestResultOfLastAttempt) {
        Optional oldTestResult = this.testResult;
        ExecutionTestResult newTestResult = newTestResultOfLastAttempt;
        this.descendantTestCaseStats.recordChange(oldTestResult, newTestResult);
        if (this.shouldRetryTestCase()) {
            return;
        }
        this.updateTestResultAndJobStatus(newTestResult, ExecutionJobStatus.COMPLETED);
        EntityExecution parentEntityExecution = this.getParentEntityExecution();
        if (parentEntityExecution != null) {
            parentEntityExecution.onDescendantTestCaseResultChange(oldTestResult, newTestResult);
        }
    }

    @Override
    public void onDescendantTestCaseResultChange(ExecutionJobStatus reason) {
        if (this.getLastAttempt().getTestResult().isEmpty()) {
            return;
        }
        ExecutionTestResult newTestResult = this.getLastAttempt().getTestResult().get();
        this.descendantTestCaseStats.recalculateFromTestResults(List.of(newTestResult));
        this.updateTestResultAndJobStatus(newTestResult, reason);
        EntityExecution parentEntityExecution = this.getParentEntityExecution();
        if (parentEntityExecution != null) {
            parentEntityExecution.onDescendantTestCaseResultChange(reason);
        }
    }

    @Override
    public void onChildExecutionEnded(EntityExecution childExecution) {
        if (this.shouldRetryTestCase()) {
            return;
        }
        TestCaseExecutionAttempt lastAttempt = this.getLastAttempt();
        if (lastAttempt.getTestResult().isEmpty()) {
            return;
        }
        if (!lastAttempt.getTestResult().get().isErrorOrFailed()) {
            this.clearFailedReasonAndPropagateUp();
            return;
        }
        for (TestCaseExecutionAttempt attempt : this.attempts) {
            if (!attempt.getTestFailedReason().isPresent()) continue;
            this.updateTestFailedReasonAndPropagateUp(attempt.getTestFailedReason().orElse(null));
            return;
        }
    }

    public TestCaseExecutionAttempt addNewAttempt() {
        TestCaseExecutionAttempt newAttempt = new TestCaseExecutionAttempt(this.testCase, this.executionSettings);
        newAttempt.setParent(this);
        newAttempt.setAttemptIndex(this.attempts.size());
        this.attempts.add(newAttempt);
        this.descendantTestCaseStats.reset();
        this.descendantTestCaseStats.setTotalCount(1);
        return newAttempt;
    }

    public TestCaseExecutionAttempt getFirstAttempt() {
        if (this.attempts.size() == 0) {
            return null;
        }
        return this.attempts.get(0);
    }

    public TestCaseExecutionAttempt getLastAttempt() {
        if (this.attempts.size() == 0) {
            return null;
        }
        return this.attempts.get(this.attempts.size() - 1);
    }

    public boolean shouldRetryTestCase() {
        TestCaseExecutionAttempt lastAttempt = this.getLastAttempt();
        if (!lastAttempt.isErrorOrFailed()) {
            return false;
        }
        if (this.executionSettings.getTestSuiteRerunSettings() == null) {
            return false;
        }
        int maxRetries = this.executionSettings.getTestSuiteRerunSettings().getMaxRetryCount();
        TestSuiteRerunSettings.RetryStrategy retryStrategy = this.executionSettings.getTestSuiteRerunSettings().getRetryStrategy();
        if (retryStrategy != TestSuiteRerunSettings.RetryStrategy.IMMEDIATELY) {
            return false;
        }
        return this.attempts.size() < maxRetries + 1;
    }

    public List<TestCaseExecutionAttempt> getAttempts() {
        return this.attempts;
    }

    public void setAttempts(List<TestCaseExecutionAttempt> attempts) {
        this.attempts = attempts;
    }

    public int getIterationIndex() {
        return this.iterationIndex;
    }

    public void setIterationIndex(int iterationIndex) {
        this.iterationIndex = iterationIndex;
    }

    public Optional<SystemFileEntity> getOriginalCucumberFeatureFileEntity() {
        return this.originalCucumberFeatureFileEntity;
    }
}

