/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.model.steps.testcase;

import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.ExecutionTestResult;
import com.katalon.execution.model.logrecord.LogRecord;
import com.katalon.execution.model.logrecord.TestCaseLogRecord;
import com.katalon.execution.model.settings.ExecutionSettings;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.testcase.BaseTestCaseExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecutionAttempt;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class TestCaseExecutionAttempt
extends BaseTestCaseExecution {
    private int attemptIndex;
    private final List<LogRecord> logRecords = new ArrayList<LogRecord>();

    public TestCaseExecutionAttempt(TestCaseEntity testCase, ExecutionSettings executionSettings) {
        super(testCase, executionSettings);
    }

    @Override
    public String getTitle() {
        return "Executing Test Case Attempt";
    }

    public final void updateTestResultAndPropagateUp(ExecutionTestResult newTestResult) {
        if (newTestResult == null) {
            return;
        }
        if (this.testResult.isPresent() && this.testResult.get() == newTestResult) {
            return;
        }
        Optional oldTestResult = this.testResult;
        this.updateTestResultAndJobStatus(newTestResult, ExecutionJobStatus.COMPLETED);
        EntityExecution parentEntityExecution = this.getParentEntityExecution();
        if (parentEntityExecution != null) {
            parentEntityExecution.onDescendantTestCaseResultChange(oldTestResult, newTestResult);
        }
    }

    @Override
    public void onDescendantTestCaseResultChange(Optional<ExecutionTestResult> oldTestResult, ExecutionTestResult newResult) {
    }

    @Override
    public void onDescendantTestCaseResultChange(ExecutionJobStatus reason) {
    }

    @Override
    public void onChildExecutionEnded(EntityExecution childExecution) {
    }

    @Override
    public int getTestCaseCount() {
        return 1;
    }

    @Override
    public int getExecutedTestCaseCount() {
        return this.testResult.isPresent() ? 1 : 0;
    }

    @Override
    public void onPlanChanged() {
    }

    @Override
    public void onPlanTerminated() {
        if (this.executionJobStatus.isFinal() && this.testResult.isPresent()) {
            return;
        }
        if (this.executionJobStatus == ExecutionJobStatus.RUNNING) {
            this.updateTestResultAndJobStatus(ExecutionTestResult.INCOMPLETE, ExecutionJobStatus.TERMINATED);
        } else if (this.executionJobStatus == ExecutionJobStatus.PENDING) {
            this.updateTestResultAndJobStatus(ExecutionTestResult.NOT_RUN, ExecutionJobStatus.TERMINATED);
        } else if (this.executionJobStatus == ExecutionJobStatus.TERMINATED) {
            this.updateTestResultAndJobStatus(ExecutionTestResult.INCOMPLETE, ExecutionJobStatus.TERMINATED);
        }
    }

    @Override
    public void onLaunchEnded() {
        if (this.executionJobStatus.isFinal() && this.testResult.isPresent()) {
            return;
        }
        if (this.executionJobStatus == ExecutionJobStatus.RUNNING) {
            this.updateTestResultAndJobStatus(ExecutionTestResult.INCOMPLETE, ExecutionJobStatus.FAILED);
        } else if (this.executionJobStatus == ExecutionJobStatus.PENDING) {
            this.updateTestResultAndJobStatus(ExecutionTestResult.NOT_RUN, ExecutionJobStatus.FAILED);
        }
    }

    public void addLogRecord(LogRecord logRecord) {
        this.logRecords.add(logRecord);
    }

    public LogRecord getLastLogRecord() {
        if (this.logRecords.isEmpty()) {
            return null;
        }
        return this.logRecords.get(this.logRecords.size() - 1);
    }

    public TestCaseLogRecord getTestCaseLogRecord() {
        return this.logRecords.stream().filter(record -> record instanceof TestCaseLogRecord).findFirst().orElse(null);
    }

    public TestStatus.TestStatusValue getLogRecordTestStatusValue() {
        TestCaseLogRecord testCaseLogRecord = this.getTestCaseLogRecord();
        if (testCaseLogRecord != null) {
            return testCaseLogRecord.getTestStatusValue();
        }
        return null;
    }

    public TestSuiteExecutionAttempt getAncestorTestSuiteExecutionAttempt() {
        EntityExecution current = this;
        while (current != null) {
            if (current instanceof TestSuiteExecutionAttempt) {
                TestSuiteExecutionAttempt tsExecutionAttempt = (TestSuiteExecutionAttempt)current;
                return tsExecutionAttempt;
            }
            current = current.getParentEntityExecution();
        }
        return null;
    }

    public int getAttemptIndex() {
        return this.attemptIndex;
    }

    public void setAttemptIndex(int attemptIndex) {
        this.attemptIndex = attemptIndex;
    }

    public List<LogRecord> getLogRecords() {
        return this.logRecords;
    }
}

