/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.model.steps.testsuite;

import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.ExecutionTestResult;
import com.katalon.execution.model.settings.TSCExecutionSettings;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.TestResultStatistics;
import com.katalon.execution.model.steps.testsuite.BaseTestSuiteExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecutionAttempt;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class TestSuiteCollectionExecution
extends EntityExecution {
    private final String executionUUID;
    private final String testSuiteCollectionId;
    private final TestSuiteCollectionEntity testSuiteCollection;
    private final List<TestSuiteExecution> testSuiteExecutions = new ArrayList<TestSuiteExecution>();
    private final TSCExecutionSettings tscExecutionSettings;

    public TestSuiteCollectionExecution(TestSuiteCollectionEntity testSuiteCollection, TSCExecutionSettings tscExecutionSettings, String executionUUID) {
        this.testSuiteCollection = testSuiteCollection;
        this.testSuiteCollectionId = testSuiteCollection.getIdForDisplay();
        this.tscExecutionSettings = tscExecutionSettings;
        this.executionUUID = executionUUID != null && !executionUUID.isEmpty() ? executionUUID : UUID.randomUUID().toString();
    }

    @Override
    public int getTestCaseCount() {
        return this.descendantTestCaseStats.getTotalCount();
    }

    @Override
    public int getExecutedTestCaseCount() {
        return this.descendantTestCaseStats.getExecutedTestCaseCount();
    }

    @Override
    public void onPlanChanged() {
        List<TestResultStatistics> childStats = this.testSuiteExecutions.stream().map(BaseTestSuiteExecution::getDescendantTestCaseStats).collect(Collectors.toList());
        this.descendantTestCaseStats.recalculateFromOtherStats(childStats);
    }

    @Override
    public void onPlanTerminated() {
        if (this.executionJobStatus.isFinal() && this.testResult.isPresent()) {
            return;
        }
        for (TestSuiteExecution testSuiteExecution : this.testSuiteExecutions) {
            testSuiteExecution.onPlanTerminated();
        }
        this.recalculateDescendantTestCaseStats();
        Optional<ExecutionTestResult> newAggregatedTestResult = this.descendantTestCaseStats.determineAggregatedResult();
        if (newAggregatedTestResult.isPresent()) {
            this.updateTestResultAndJobStatus(newAggregatedTestResult.get(), ExecutionJobStatus.TERMINATED);
        }
    }

    @Override
    public void onLaunchEnded() {
        if (this.executionJobStatus.isFinal() && this.testResult.isPresent()) {
            return;
        }
        for (TestSuiteExecution testSuiteExecution : this.testSuiteExecutions) {
            testSuiteExecution.onLaunchEnded();
        }
        this.recalculateDescendantTestCaseStats();
        Optional<ExecutionTestResult> newAggregatedTestResult = this.descendantTestCaseStats.determineAggregatedResult();
        if (newAggregatedTestResult.isPresent()) {
            this.updateTestResultAndJobStatus(newAggregatedTestResult.get(), ExecutionJobStatus.FAILED);
        }
    }

    private void recalculateDescendantTestCaseStats() {
        List<TestResultStatistics> childStats = this.testSuiteExecutions.stream().map(BaseTestSuiteExecution::getDescendantTestCaseStats).collect(Collectors.toList());
        this.descendantTestCaseStats.recalculateFromOtherStats(childStats);
    }

    @Override
    public void onDescendantTestCaseResultChange(Optional<ExecutionTestResult> oldTestResult, ExecutionTestResult newTestResult) {
        this.descendantTestCaseStats.recordChange(oldTestResult, newTestResult);
        Optional<ExecutionTestResult> newAggregatedTestResult = this.descendantTestCaseStats.determineAggregatedResult();
        if (newAggregatedTestResult.isPresent()) {
            this.updateTestResultAndJobStatus(newAggregatedTestResult.get(), ExecutionJobStatus.COMPLETED);
        }
    }

    @Override
    public void onDescendantTestCaseResultChange(ExecutionJobStatus reason) {
        this.recalculateDescendantTestCaseStats();
        Optional<ExecutionTestResult> newAggregatedTestResult = this.descendantTestCaseStats.determineAggregatedResult();
        if (newAggregatedTestResult.isPresent()) {
            this.updateTestResultAndJobStatus(newAggregatedTestResult.get(), reason);
        }
    }

    @Override
    public void onChildExecutionEnded(EntityExecution childExecution) {
    }

    @Override
    public String getName() {
        return this.testSuiteCollection != null ? this.testSuiteCollection.getName() : null;
    }

    @Override
    public String getTitle() {
        return "Executing Test Suite Collection";
    }

    @Override
    public boolean isPausible() {
        return true;
    }

    public void addTestSuiteExecution(TestSuiteExecution testSuiteExecution) {
        this.testSuiteExecutions.add(testSuiteExecution);
        testSuiteExecution.setParent(this);
    }

    public int countFailedAndErrorTestCaseExecutions() {
        int totalFailedAndError = 0;
        for (TestSuiteExecution tsExec : this.testSuiteExecutions) {
            for (TestSuiteExecutionAttempt tsExecAttempt : tsExec.getAttempts()) {
                totalFailedAndError += tsExecAttempt.getDescendantTestCaseStats().countFailedAndError();
            }
        }
        return totalFailedAndError;
    }

    public TestSuiteExecutionAttempt getFirstTestSuiteExecutionAttempt() {
        if (this.testSuiteExecutions.size() == 0) {
            return null;
        }
        return this.testSuiteExecutions.get(0).getFirstAttempt();
    }

    public TestSuiteExecutionAttempt getLastTestSuiteExecutionAttempt() {
        if (this.testSuiteExecutions.size() == 0) {
            return null;
        }
        return this.testSuiteExecutions.get(this.testSuiteExecutions.size() - 1).getLastAttempt();
    }

    public String getTestSuiteCollectionId() {
        return this.testSuiteCollectionId;
    }

    public TestSuiteCollectionEntity getTestSuiteCollection() {
        return this.testSuiteCollection;
    }

    public List<TestSuiteExecution> getTestSuiteExecutions() {
        return this.testSuiteExecutions;
    }

    public String getExecutionSessionId() {
        return this.tscExecutionSettings.getExecutionSessionId();
    }

    public TSCExecutionSettings getTscExecutionSettings() {
        return this.tscExecutionSettings;
    }

    public String getExecutionUUID() {
        return this.executionUUID;
    }
}

