/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.model.steps.testsuite;

import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.ExecutionTestResult;
import com.katalon.execution.model.settings.ExecutionSettings;
import com.katalon.execution.model.settings.TestSuiteRerunSettings;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.TestResultStatistics;
import com.katalon.execution.model.steps.testsuite.BaseTestSuiteExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecutionAttempt;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class TestSuiteExecution
extends BaseTestSuiteExecution {
    private final Optional<Integer> indexInCollection;
    private List<TestSuiteExecutionAttempt> attempts = new ArrayList<TestSuiteExecutionAttempt>();

    public TestSuiteExecution(ExecutionSettings executionSettings, Optional<Integer> indexInCollection) {
        super(executionSettings);
        this.indexInCollection = indexInCollection;
    }

    @Override
    public int getTestCaseCount() {
        return this.descendantTestCaseStats.getTotalCount();
    }

    @Override
    public int getExecutedTestCaseCount() {
        return this.descendantTestCaseStats.getExecutedTestCaseCount();
    }

    @Override
    public void onPlanChanged() {
        TestSuiteExecutionAttempt firstAttempt = this.getFirstAttempt();
        if (firstAttempt != null) {
            this.descendantTestCaseStats.setTotalCount(firstAttempt.getTestCaseCount());
        }
        if (this.attempts.size() <= 1) {
            return;
        }
        TestSuiteRerunSettings.RetryStrategy retryStrategy = this.executionSettings.getTestSuiteRerunSettings().getRetryStrategy();
        if (retryStrategy == TestSuiteRerunSettings.RetryStrategy.FAILED_EXECUTIONS) {
            this.descendantTestCaseStats.removeErrorOrFailedCases();
        } else {
            this.descendantTestCaseStats.reset();
        }
    }

    @Override
    public void onPlanTerminated() {
        if (this.executionJobStatus.isFinal() && this.testResult.isPresent()) {
            return;
        }
        TestSuiteExecutionAttempt lastAttempt = this.getLastAttempt();
        if (lastAttempt != null) {
            lastAttempt.onPlanTerminated();
        }
        this.recalculateDescendantTestCaseStats(lastAttempt);
        Optional<ExecutionTestResult> newAggregatedTestResult = this.descendantTestCaseStats.determineAggregatedResult();
        if (newAggregatedTestResult.isPresent()) {
            this.updateTestResultAndJobStatus(newAggregatedTestResult.get(), ExecutionJobStatus.TERMINATED);
        }
    }

    @Override
    public void onLaunchEnded() {
        EntityExecution parentEntityExecution;
        if (this.executionJobStatus.isFinal() && this.testResult.isPresent()) {
            return;
        }
        TestSuiteExecutionAttempt lastAttempt = this.getLastAttempt();
        if (lastAttempt != null) {
            lastAttempt.onLaunchEnded();
        }
        this.recalculateDescendantTestCaseStats(lastAttempt);
        Optional<ExecutionTestResult> newAggregatedTestResult = this.descendantTestCaseStats.determineAggregatedResult();
        if (newAggregatedTestResult.isPresent()) {
            this.updateTestResultAndJobStatus(newAggregatedTestResult.get(), ExecutionJobStatus.FAILED);
        }
        if ((parentEntityExecution = this.getParentEntityExecution()) != null) {
            parentEntityExecution.onDescendantTestCaseResultChange(ExecutionJobStatus.FAILED);
        }
    }

    private void recalculateDescendantTestCaseStats(TestSuiteExecutionAttempt lastAttempt) {
        int nSuccessful = this.descendantTestCaseStats.getTotalCount() - lastAttempt.getTestCaseCount();
        TestResultStatistics successfulStats = new TestResultStatistics();
        successfulStats.setTotalCount(nSuccessful);
        successfulStats.getTestResultCount().put(ExecutionTestResult.PASSED, nSuccessful);
        this.descendantTestCaseStats.recalculateFromOtherStats(List.of(lastAttempt.getDescendantTestCaseStats(), successfulStats));
    }

    public void addNewAttempt(TestSuiteExecutionAttempt newAttempt) {
        newAttempt.setParent(this);
        newAttempt.setAttemptIndex(this.attempts.size());
        this.attempts.add(newAttempt);
    }

    public TestSuiteExecutionAttempt getFirstAttempt() {
        if (this.attempts.size() == 0) {
            return null;
        }
        return this.attempts.get(0);
    }

    public TestSuiteExecutionAttempt getLastAttempt() {
        if (this.attempts.size() == 0) {
            return null;
        }
        return this.attempts.get(this.attempts.size() - 1);
    }

    public boolean isPartOfCollection() {
        return this.getParentEntityExecution() != null;
    }

    @Override
    public void onDescendantTestCaseResultChange(Optional<ExecutionTestResult> oldTestResult, ExecutionTestResult newTestResult) {
        EntityExecution parentEntityExecution;
        this.descendantTestCaseStats.recordChange(oldTestResult, newTestResult);
        if (this.shouldRetryTestSuite()) {
            return;
        }
        if (this.getLastAttempt().getTestResult().isPresent()) {
            this.updateTestResultAndJobStatus(this.getLastAttempt().getTestResult().get(), ExecutionJobStatus.COMPLETED);
        }
        if ((parentEntityExecution = this.getParentEntityExecution()) != null) {
            parentEntityExecution.onDescendantTestCaseResultChange(oldTestResult, newTestResult);
        }
    }

    @Override
    public void onDescendantTestCaseResultChange(ExecutionJobStatus reason) {
        EntityExecution parentEntityExecution;
        this.recalculateDescendantTestCaseStats(this.getLastAttempt());
        Optional<ExecutionTestResult> newAggregatedTestResult = this.descendantTestCaseStats.determineAggregatedResult();
        if (newAggregatedTestResult.isPresent()) {
            this.updateTestResultAndJobStatus(newAggregatedTestResult.get(), reason);
        }
        if ((parentEntityExecution = this.getParentEntityExecution()) != null) {
            parentEntityExecution.onDescendantTestCaseResultChange(reason);
        }
    }

    @Override
    public void onChildExecutionEnded(EntityExecution childExecution) {
        if (this.shouldRetryTestSuite()) {
            return;
        }
        TestSuiteExecutionAttempt lastAttempt = this.getLastAttempt();
        if (lastAttempt.getTestResult().isEmpty()) {
            return;
        }
        if (!lastAttempt.getTestResult().get().isErrorOrFailed()) {
            this.clearFailedReasonAndPropagateUp();
            return;
        }
        for (TestSuiteExecutionAttempt attempt : this.attempts) {
            if (!attempt.getTestFailedReason().isPresent()) continue;
            this.updateTestFailedReasonAndPropagateUp(attempt.getTestFailedReason().orElse(null));
            return;
        }
    }

    public boolean shouldRetryTestSuite() {
        TestSuiteExecutionAttempt lastAttempt = this.getLastAttempt();
        if (!lastAttempt.isErrorOrFailed()) {
            return false;
        }
        int maxRetries = this.executionSettings.getTestSuiteRerunSettings().getMaxRetryCount();
        TestSuiteRerunSettings.RetryStrategy retryStrategy = this.executionSettings.getTestSuiteRerunSettings().getRetryStrategy();
        if (retryStrategy == TestSuiteRerunSettings.RetryStrategy.IMMEDIATELY) {
            return false;
        }
        return this.attempts.size() < maxRetries + 1;
    }

    public int countFailedAndErrorTestCaseExecutions() {
        int totalFailedAndError = 0;
        for (TestSuiteExecutionAttempt tsExecAttempt : this.attempts) {
            totalFailedAndError += tsExecAttempt.getDescendantTestCaseStats().countFailedAndError();
        }
        return totalFailedAndError;
    }

    public List<TestSuiteExecutionAttempt> getAttempts() {
        return this.attempts;
    }

    public Optional<Integer> getIndexInCollection() {
        return this.indexInCollection;
    }
}

