/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.model.steps.testsuite;

import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.ExecutionTestResult;
import com.katalon.execution.model.logrecord.LogRecord;
import com.katalon.execution.model.logrecord.TestSuiteLogRecord;
import com.katalon.execution.model.settings.ExecutionSettings;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.TestResultStatistics;
import com.katalon.execution.model.steps.testcase.BaseTestCaseExecution;
import com.katalon.execution.model.steps.testcase.TestCaseBindingExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecution;
import com.katalon.execution.model.steps.testsuite.BaseTestSuiteExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecution;
import com.kms.katalon.core.testcase.TestCaseBinding;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class TestSuiteExecutionAttempt
extends BaseTestSuiteExecution {
    private int attemptIndex;
    private final String executionUUID;
    private BindingLevel bindingLevel = BindingLevel.NO_BINDING;
    private List<BaseTestCaseExecution> testCaseExecutions = new ArrayList<BaseTestCaseExecution>();
    private List<TestCaseBinding> testCaseBindings = new ArrayList<TestCaseBinding>();
    private List<LogRecord> logRecords = new ArrayList<LogRecord>();

    public TestSuiteExecutionAttempt(ExecutionSettings executionSettings, String executionUUID) {
        super(executionSettings);
        this.executionUUID = executionUUID != null && !executionUUID.isEmpty() ? executionUUID : UUID.randomUUID().toString();
    }

    public void addTestCase(TestCaseEntity testCaseEntity) {
        UUID testCaseExecutionId = UUID.randomUUID();
        String testCaseId = testCaseEntity.getIdForDisplay();
        TestCaseBinding testCaseBinding = new TestCaseBinding(testCaseId, testCaseId, new HashMap());
        testCaseBinding.setTestCaseExecutionId(testCaseExecutionId);
        this.testCaseBindings.add(testCaseBinding);
        TestCaseExecution testCaseExecution = new TestCaseExecution(testCaseEntity, this.executionSettings, testCaseExecutionId);
        testCaseExecution.setParent(this);
        this.testCaseExecutions.add(testCaseExecution);
    }

    public void addTestCaseBinding(TestCaseEntity testCaseEntity, List<TestCaseBinding> testCaseBindings, BindingLevel bindingLevel) {
        TestCaseBindingExecution testCaseBindingExecution = new TestCaseBindingExecution(testCaseEntity, this.executionSettings);
        for (TestCaseBinding testCaseBinding : testCaseBindings) {
            testCaseBindingExecution.addIterationWithBinding(testCaseEntity, testCaseBinding);
        }
        this.testCaseExecutions.add(testCaseBindingExecution);
        testCaseBindingExecution.setParent(this);
        this.testCaseBindings.addAll(testCaseBindings);
        this.bindingLevel = bindingLevel;
    }

    @Override
    public int getTestCaseCount() {
        return this.descendantTestCaseStats.getTotalCount();
    }

    @Override
    public int getExecutedTestCaseCount() {
        return this.descendantTestCaseStats.getExecutedTestCaseCount();
    }

    @Override
    public void onPlanChanged() {
        for (BaseTestCaseExecution baseTestCaseExecution : this.testCaseExecutions) {
            baseTestCaseExecution.onPlanChanged();
        }
        int totalTestCases = this.testCaseExecutions.stream().mapToInt(tc -> tc.getTestCaseCount()).sum();
        this.descendantTestCaseStats.setTotalCount(totalTestCases);
    }

    public TestSuiteLogRecord getTestSuiteLogRecord() {
        return this.logRecords.stream().filter(record -> record instanceof TestSuiteLogRecord).findFirst().orElse(null);
    }

    @Override
    public void onPlanTerminated() {
        if (this.executionJobStatus.isFinal() && this.testResult.isPresent()) {
            return;
        }
        for (BaseTestCaseExecution testCaseExecution : this.testCaseExecutions) {
            testCaseExecution.onPlanTerminated();
        }
        this.recalculateDescendantTestCaseStats();
        Optional<ExecutionTestResult> newAggregatedTestResult = this.descendantTestCaseStats.determineAggregatedResult();
        if (newAggregatedTestResult.isPresent()) {
            this.updateTestResultAndJobStatus(newAggregatedTestResult.get(), ExecutionJobStatus.TERMINATED);
        }
    }

    @Override
    public void onLaunchEnded() {
        EntityExecution parentEntityExecution;
        if (this.executionJobStatus.isFinal() && this.testResult.isPresent()) {
            return;
        }
        for (BaseTestCaseExecution testCaseExecution : this.testCaseExecutions) {
            testCaseExecution.onLaunchEnded();
        }
        this.recalculateDescendantTestCaseStats();
        Optional<ExecutionTestResult> newAggregatedTestResult = this.descendantTestCaseStats.determineAggregatedResult();
        if (newAggregatedTestResult.isPresent()) {
            this.updateTestResultAndJobStatus(newAggregatedTestResult.get(), ExecutionJobStatus.FAILED);
        }
        if ((parentEntityExecution = this.getParentEntityExecution()) != null) {
            parentEntityExecution.onDescendantTestCaseResultChange(ExecutionJobStatus.FAILED);
        }
    }

    private void recalculateDescendantTestCaseStats() {
        List<TestResultStatistics> childStats = this.testCaseExecutions.stream().map(EntityExecution::getDescendantTestCaseStats).collect(Collectors.toList());
        this.descendantTestCaseStats.recalculateFromOtherStats(childStats);
    }

    @Override
    public void onDescendantTestCaseResultChange(Optional<ExecutionTestResult> oldTestResult, ExecutionTestResult newTestResult) {
        EntityExecution parentEntityExecution;
        this.descendantTestCaseStats.recordChange(oldTestResult, newTestResult);
        Optional<ExecutionTestResult> newAggregatedTestResult = this.descendantTestCaseStats.determineAggregatedResult();
        if (newAggregatedTestResult.isPresent()) {
            this.updateTestResultAndJobStatus(newAggregatedTestResult.get(), ExecutionJobStatus.COMPLETED);
        }
        if ((parentEntityExecution = this.getParentEntityExecution()) != null) {
            parentEntityExecution.onDescendantTestCaseResultChange(oldTestResult, newTestResult);
        }
    }

    @Override
    public void onDescendantTestCaseResultChange(ExecutionJobStatus reason) {
        EntityExecution parentEntityExecution;
        this.recalculateDescendantTestCaseStats();
        Optional<ExecutionTestResult> newAggregatedTestResult = this.descendantTestCaseStats.determineAggregatedResult();
        if (newAggregatedTestResult.isPresent()) {
            this.updateTestResultAndJobStatus(newAggregatedTestResult.get(), reason);
        }
        if ((parentEntityExecution = this.getParentEntityExecution()) != null) {
            parentEntityExecution.onDescendantTestCaseResultChange(reason);
        }
    }

    @Override
    public void onChildExecutionEnded(EntityExecution childExecution) {
    }

    public void addLogRecord(LogRecord logRecord) {
        this.logRecords.add(logRecord);
    }

    public String buildScriptFileName() {
        TestSuiteExecution tsExecution;
        Object name = "S";
        EntityExecution entityExecution = this.getParentEntityExecution();
        if (entityExecution instanceof TestSuiteExecution && (tsExecution = (TestSuiteExecution)entityExecution).getIndexInCollection().isPresent()) {
            name = (String)name + String.valueOf(tsExecution.getIndexInCollection().get());
            name = (String)name + "_";
        }
        name = (String)name + this.attemptIndex;
        name = (String)name + ".groovy";
        return name;
    }

    public List<BaseTestCaseExecution> getTestCaseExecutions() {
        return this.testCaseExecutions;
    }

    public void setTestCaseExecutions(List<BaseTestCaseExecution> testCaseExecutions) {
        this.testCaseExecutions = testCaseExecutions;
    }

    public int getAttemptIndex() {
        return this.attemptIndex;
    }

    public void setAttemptIndex(int attemptIndex) {
        this.attemptIndex = attemptIndex;
    }

    public List<TestCaseBinding> getTestCaseBindings() {
        return this.testCaseBindings;
    }

    public List<LogRecord> getLogRecords() {
        return this.logRecords;
    }

    public BindingLevel getBindingLevel() {
        return this.bindingLevel;
    }

    public String getExecutionUUID() {
        return this.executionUUID;
    }

    public static enum BindingLevel {
        NO_BINDING,
        TEST_SUITE_LEVEL,
        TEST_CASE_LEVEL;

    }
}

