/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.model;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.model.RequireModuleOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.groovy.core.util.ArrayUtils;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.launching.JavaRuntime;

public class GroovyRuntime {
    public static final String DSLD_CONTAINER_ID = "GROOVY_DSL_SUPPORT";

    public static void addGroovyRuntime(IProject project) {
        GroovyCore.trace("GroovyRuntime.addGroovyRuntime(IProject)");
        try {
            if (project != null && project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature") && !project.hasNature("org.eclipse.jdt.groovy.core.groovyNature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                if (!GroovyRuntime.findClasspathEntry(javaProject, cpe -> DSLD_CONTAINER_ID.equals(cpe.getPath().segment(0))).isPresent()) {
                    GroovyRuntime.appendClasspathEntry(javaProject, JavaCore.newContainerEntry((IPath)new Path(DSLD_CONTAINER_ID)));
                }
                GroovyRuntime.addGroovyClasspathContainer(javaProject);
                GroovyRuntime.addGroovyNature(project);
            }
        }
        catch (Exception e) {
            GroovyCore.logException("Failed to add groovy runtime support", e);
        }
    }

    public static void addGroovyNature(IProject project) throws CoreException {
        GroovyCore.trace("GroovyRuntime.addGroovyNature(IProject)");
        IProjectDescription description = project.getDescription();
        description.setNatureIds((String[])ArrayUtils.add((Object[])description.getNatureIds(), (int)0, (Object)"org.eclipse.jdt.groovy.core.groovyNature"));
        project.setDescription(description, null);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IType type = javaProject.findType(ClassHelper.GROOVY_OBJECT_TYPE.getName());
        if (type != null && type.exists()) {
            RequireModuleOperation.requireModule(javaProject, type);
        }
    }

    public static void removeGroovyNature(IProject project) throws CoreException {
        GroovyCore.trace("GroovyRuntime.removeGroovyNature(IProject)");
        IProjectDescription description = project.getDescription();
        if (description.hasNature("org.eclipse.jdt.groovy.core.groovyNature")) {
            description.setNatureIds((String[])ArrayUtils.removeElement((Object[])description.getNatureIds(), (Object)"org.eclipse.jdt.groovy.core.groovyNature"));
            project.setDescription(description, null);
        }
    }

    public static void addGroovyClasspathContainer(IJavaProject javaProject) {
        GroovyRuntime.addGroovyClasspathContainer(javaProject, false);
    }

    public static void addGroovyClasspathContainer(IJavaProject javaProject, boolean isMinimal) {
        try {
            if (GroovyRuntime.hasGroovyClasspathContainer(javaProject)) {
                GroovyRuntime.removeGroovyClasspathContainer(javaProject);
            }
            GroovyRuntime.appendClasspathEntry(javaProject, GroovyRuntime.newGroovyClasspathContainerEntry(isMinimal, JavaRuntime.isModularProject((IJavaProject)javaProject), null));
        }
        catch (CoreException e) {
            GroovyCore.logException("Failed to add groovy classpath container:" + e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public static boolean hasGroovyClasspathContainer(IJavaProject javaProject) throws JavaModelException {
        return GroovyRuntime.findClasspathEntry(javaProject, cpe -> "GROOVY_SUPPORT".equals(cpe.getPath().segment(0))).isPresent();
    }

    public static void removeGroovyClasspathContainer(IJavaProject javaProject) throws JavaModelException {
        GroovyRuntime.findClasspathEntry(javaProject, cpe -> "GROOVY_SUPPORT".equals(cpe.getPath().segment(0))).ifPresent(cpe -> GroovyRuntime.removeClasspathEntry(javaProject, cpe));
    }

    public static IClasspathEntry newGroovyClasspathContainerEntry(boolean isMinimal, boolean isModular, Boolean userLibs) {
        Path containerPath = new Path("GROOVY_SUPPORT");
        if (isMinimal) {
            containerPath = containerPath.append("minimal");
        } else if (Boolean.TRUE.equals(userLibs)) {
            containerPath = containerPath.append("user-libs=true");
        } else if (Boolean.FALSE.equals(userLibs)) {
            containerPath = containerPath.append("user-libs=false");
        }
        IClasspathAttribute[] attributes = ClasspathEntry.NO_EXTRA_ATTRIBUTES;
        if (isModular) {
            attributes = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"module", (String)"true")};
        }
        return JavaCore.newContainerEntry((IPath)containerPath, (IAccessRule[])ClasspathEntry.NO_ACCESS_RULES, (IClasspathAttribute[])attributes, (boolean)false);
    }

    public static void appendClasspathEntry(IJavaProject javaProject, IClasspathEntry entry) throws JavaModelException {
        javaProject.setRawClasspath((IClasspathEntry[])ArrayUtils.add((Object[])javaProject.getRawClasspath(), (Object)entry), null);
    }

    public static void prependClasspathEntry(IJavaProject javaProject, IClasspathEntry entry) throws JavaModelException {
        javaProject.setRawClasspath((IClasspathEntry[])ArrayUtils.add((Object[])javaProject.getRawClasspath(), (int)0, (Object)entry), null);
    }

    public static void removeClasspathEntry(IJavaProject javaProject, IClasspathEntry entry) {
        try {
            javaProject.setRawClasspath((IClasspathEntry[])ArrayUtils.removeElement((Object[])javaProject.getRawClasspath(), (Object)entry), null);
        }
        catch (JavaModelException e) {
            GroovyCore.logException("Failed to remove classpath container: " + String.valueOf(entry), e);
        }
    }

    public static Optional<IClasspathEntry> findClasspathEntry(IJavaProject javaProject, Predicate<IClasspathEntry> p) throws JavaModelException {
        return JavaProject.hasJavaNature((IProject)javaProject.getProject()) ? Arrays.stream(javaProject.getRawClasspath()).filter(p).findFirst() : Optional.empty();
    }
}

