/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.util;

import java.io.Serializable;

public class Token
implements Serializable {
    private static final long serialVersionUID = 384520235046067298L;
    private final int type;
    public final String text;
    public final int startOffset;
    public final int endOffset;

    public Token(Type type, int startOffset, int endOffset, String text) {
        this.type = type.ordinal();
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.text = text;
    }

    public Type getType() {
        return Type.values()[this.type];
    }

    public boolean isType(Type t) {
        return t == this.getType();
    }

    public boolean isDotAccess() {
        switch (this.getType()) {
            case DOT: 
            case SAFE_DEREF: 
            case SPREAD: 
            case FIELD_ACCESS: 
            case METHOD_POINTER: {
                return true;
            }
        }
        return false;
    }

    public boolean isValidBeforeDot() {
        switch (this.getType()) {
            case IDENT: 
            case QUOTED_STRING: 
            case PAREN_BLOCK: 
            case BRACE_BLOCK: 
            case BRACK_BLOCK: {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object that) {
        return that == null || !(that instanceof Token) ? false : ((Token)that).type == this.type;
    }

    public int hashCode() {
        return Integer.hashCode(this.type);
    }

    public String toString() {
        return String.valueOf((Object)this.getType()) + "[" + this.startOffset + ":" + this.endOffset + "] - " + this.text;
    }

    public static enum Type {
        EOF,
        IDENT,
        DOT,
        SEMI,
        QUOTED_STRING,
        PAREN_BLOCK,
        BRACE_BLOCK,
        BRACK_BLOCK,
        LINE_COMMENT,
        BLOCK_COMMENT,
        LINE_BREAK,
        DOUBLE_DOT,
        SAFE_DEREF,
        SPREAD,
        FIELD_ACCESS,
        METHOD_POINTER;

    }
}

