/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.testcloud.core.model;

import com.katalon.mobile.core.constants.StringConstants;
import com.katalon.mobile.core.enums.MobileDeviceAvailability;
import com.katalon.mobile.core.interfaces.IMobileDevice;
import com.kms.katalon.testcloud.core.model.TestCloudCapability;
import com.kms.katalon.testcloud.core.model.TestCloudDevice;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TestCloudMobileDevice
implements IMobileDevice {
    private static final String TESTCLOUD_DEVICE_ID = "deviceId";
    private static final String TESTCLOUD_DEVICE_MANUFACTURER = "deviceManufacturer";
    private static final String TESTCLOUD_DEVICE_MODEL = "deviceModel";
    private static final String TESTCLOUD_DEVICE_NAME = "deviceName";
    private static final String TESTCLOUD_DEVICE_OS = "deviceOs";
    private static final String TESTCLOUD_DEVICE_OS_VERSION = "deviceOsVersion";
    private static final String TESTCLOUD_IS_TABLET = "isTablet";
    private static final String TESTCLOUD_IS_USING_TUNNEL = "isUsingTunnel";
    private static final String TESTCLOUD_DEVICE_AVAILABILITY = "availability";
    private Map<String, String> properties = new HashMap<String, String>();

    public TestCloudMobileDevice(Map<String, String> properties) {
        this.properties = properties;
    }

    public String getDeviceId() {
        return this.properties.get(TESTCLOUD_DEVICE_ID);
    }

    public String getDeviceManufacturer() {
        return this.properties.get(TESTCLOUD_DEVICE_MANUFACTURER);
    }

    public String getDeviceModel() {
        return this.properties.get(TESTCLOUD_DEVICE_MODEL);
    }

    public String getDeviceName() {
        return this.properties.get(TESTCLOUD_DEVICE_NAME);
    }

    public String getDeviceOs() {
        return this.properties.get(TESTCLOUD_DEVICE_OS);
    }

    public String getDeviceOsVersion() {
        return this.properties.get(TESTCLOUD_DEVICE_OS_VERSION);
    }

    public boolean isRealDevice() {
        return true;
    }

    public Map<String, Object> getDeviceSystemProperties() {
        HashMap<String, Object> systemProperties = new HashMap<String, Object>();
        systemProperties.put(StringConstants.CONF_EXECUTED_DEVICE_ID, this.getDeviceId());
        systemProperties.put(StringConstants.CONF_EXECUTED_DEVICE_NAME, this.getDeviceName());
        systemProperties.put(StringConstants.CONF_EXECUTED_DEVICE_MANUFACTURER, this.getDeviceManufacturer());
        systemProperties.put(StringConstants.CONF_EXECUTED_DEVICE_MODEL, this.getDeviceModel());
        systemProperties.put(StringConstants.CONF_EXECUTED_DEVICE_OS, this.getDeviceOs());
        systemProperties.put(StringConstants.CONF_EXECUTED_DEVICE_OS_VERSON, this.getDeviceOsVersion());
        return systemProperties;
    }

    public boolean isUsingTunnel() {
        String value = this.properties.get(TESTCLOUD_IS_USING_TUNNEL);
        return value != null && Boolean.parseBoolean(value);
    }

    public MobileDeviceAvailability getAvailability() {
        String availabilityString = this.properties.get(TESTCLOUD_DEVICE_AVAILABILITY);
        if (StringUtils.isEmpty((CharSequence)availabilityString)) {
            return MobileDeviceAvailability.LOW;
        }
        try {
            return MobileDeviceAvailability.valueOf((String)availabilityString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return MobileDeviceAvailability.LOW;
        }
    }

    public boolean isTablet() {
        String value = this.properties.get(TESTCLOUD_IS_TABLET);
        return value != null && Boolean.parseBoolean(value);
    }

    public static TestCloudMobileDevice fromTestCloudMobileDevice(TestCloudDevice testCloudMobileDevice) {
        List<String> manufacturers;
        String deviceId;
        HashMap<String, String> properties = new HashMap<String, String>();
        TestCloudCapability testCloudCapability = testCloudMobileDevice.getCapability();
        if (testCloudCapability != null && !StringUtils.isEmpty((CharSequence)(deviceId = testCloudCapability.getDeviceId()))) {
            properties.put(TESTCLOUD_DEVICE_ID, deviceId);
        }
        if ((manufacturers = testCloudMobileDevice.getManufacturer()) != null && !manufacturers.isEmpty()) {
            String manufacturer = manufacturers.get(0);
            properties.put(TESTCLOUD_DEVICE_MANUFACTURER, manufacturer);
        }
        properties.put(TESTCLOUD_DEVICE_MODEL, testCloudMobileDevice.getDeviceFamily());
        properties.put(TESTCLOUD_DEVICE_NAME, testCloudMobileDevice.getName());
        properties.put(TESTCLOUD_DEVICE_OS, testCloudMobileDevice.getOs());
        properties.put(TESTCLOUD_DEVICE_OS_VERSION, testCloudMobileDevice.getOsVersion());
        properties.put(TESTCLOUD_IS_TABLET, Boolean.toString(testCloudMobileDevice.isTablet()));
        properties.put(TESTCLOUD_DEVICE_AVAILABILITY, testCloudMobileDevice.getCapability().getAvailability().toString());
        properties.put(TESTCLOUD_IS_USING_TUNNEL, Boolean.toString(testCloudMobileDevice.isUsingTunnel()));
        return new TestCloudMobileDevice(properties);
    }
}

