/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.explorer.custom;

import com.kms.katalon.composer.components.controls.HelpComposite;
import com.kms.katalon.composer.components.impl.providers.EntityViewerFilter;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.explorer.constants.ImageConstants;
import com.kms.katalon.composer.explorer.constants.StringConstants;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.FilterController;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AdvancedSearchDialog
extends Dialog {
    public static final int MIN_WIDTH = 500;
    private static final String DIALOG_TITLE = StringConstants.CUS_DIALOG_TITLE;
    private static final String SEARCH_LABEL = StringConstants.CUS_LBL_SEARCH;
    private static final String CLEAR_LABEL = StringConstants.CUS_LBL_CLEAR;
    private String[] searchTags;
    private Map<String, String> properties;
    private Map<String, Text> textMap;
    private String txtInput;
    private Point location;

    public AdvancedSearchDialog(Shell parentShell, String txtInput) {
        this(parentShell, txtInput, null);
    }

    public AdvancedSearchDialog(Shell parentShell, String txtInput, Point location) {
        super(parentShell);
        this.txtInput = txtInput;
        this.textMap = new LinkedHashMap<String, Text>();
        this.location = location;
        this.searchTags = FilterController.getInstance().getDefaultKeywordsForInputs().toArray(new String[0]);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)container.getLayout();
        gridLayout.numColumns = 2;
        try {
            if (this.searchTags != null) {
                this.properties = EntityViewerFilter.parseSearchedString((String[])this.searchTags, (String)this.txtInput);
                String[] stringArray = this.searchTags;
                int n = this.searchTags.length;
                int n2 = 0;
                while (n2 < n) {
                    final String tag = stringArray[n2];
                    Label tagLabel = new Label(container, 0);
                    tagLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
                    tagLabel.setText(StringUtils.capitalize((String)tag));
                    Text tagValue = new Text(container, 2048);
                    tagValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
                    this.textMap.put(tag, tagValue);
                    tagValue.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            AdvancedSearchDialog.this.properties.put(tag, ((Text)e.getSource()).getText());
                        }
                    });
                    ++n2;
                }
                this.refreshControls();
            }
        }
        catch (Exception e) {
            LoggerSingleton.getInstance().getLogger().error((Throwable)e);
        }
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Query Builder");
        newShell.setImage(ImageConstants.IMG_16_ADVANCED_SEARCH);
    }

    public String getOutput() {
        Object output = "";
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (!StringUtils.isNotEmpty((String)entry.getValue())) continue;
            output = (String)output + entry.getKey() + "=(" + entry.getValue() + ") ";
        }
        return output;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new HelpComposite(composite, DocumentationMessageConstants.ADVANCED_SEARCH){

            protected GridData createGridData() {
                return new GridData(131072, 0x1000000, true, false);
            }

            protected GridLayout createLayout() {
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginBottom = 0;
                layout.marginWidth = 0;
                return layout;
            }
        };
        super.createButtonBar(composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, SEARCH_LABEL, true);
        Button clear = this.createButton(parent, -1, CLEAR_LABEL, false);
        clear.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AdvancedSearchDialog.this.clearOptions();
            }
        });
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void clearOptions() {
        this.txtInput = "";
        this.properties.clear();
        this.refreshControls();
    }

    private void refreshControls() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, String>();
        }
        for (Map.Entry<String, Text> entry : this.textMap.entrySet()) {
            if (this.properties.containsKey(entry.getKey())) {
                entry.getValue().setText(this.properties.get(entry.getKey()));
                continue;
            }
            this.properties.put(entry.getKey(), "");
            entry.getValue().setText("");
        }
    }

    public Point getInitialSize() {
        Point preferSize = super.getInitialSize();
        return new Point(Math.max(preferSize.x, 500), preferSize.y);
    }

    public Point getInitialLocation(Point initialSize) {
        return this.location != null ? this.location : super.getInitialLocation(initialSize);
    }
}

