/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.explorer.custom;

import com.kms.katalon.composer.components.impl.control.CustomColumnViewer;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.tree.TooltipPropertyDescription;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.explorer.constants.StringConstants;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class EntityTooltip
extends ColumnViewerToolTipSupport {
    private CustomColumnViewer viewer;

    private EntityTooltip(CustomColumnViewer viewer) {
        super((ColumnViewer)viewer, 1, false);
        this.viewer = viewer;
    }

    public static EntityTooltip createFor(CustomColumnViewer viewer) {
        return new EntityTooltip(viewer);
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        return this.internalCreateViewerToolTipContentArea(event, parent);
    }

    private Composite internalCreateViewerToolTipContentArea(Event event, Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setBackground(this.getBackgroundColor(event));
        result.setBackgroundMode(2);
        GridLayout glResult = new GridLayout();
        glResult.marginHeight = 0;
        glResult.marginWidth = 0;
        glResult.verticalSpacing = 10;
        result.setLayout((Layout)glResult);
        Composite propertiesComposite = new Composite(result, 0);
        propertiesComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout glProperties = new GridLayout(2, false);
        glProperties.horizontalSpacing = 10;
        propertiesComposite.setLayout((Layout)glProperties);
        this.createPropertiesControls(propertiesComposite, this.getCell(event));
        Composite bottomComposite = new Composite(result, 0);
        GridLayout glBottom = new GridLayout();
        glBottom.verticalSpacing = 0;
        glBottom.marginHeight = 0;
        glBottom.marginWidth = 0;
        glBottom.marginBottom = 2;
        bottomComposite.setLayout((Layout)glBottom);
        bottomComposite.setLayoutData((Object)new GridData(4, 1024, true, false, 1, 1));
        Label separator = new Label(bottomComposite, 258);
        separator.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        StyledText txtSuggestion = new StyledText(bottomComposite, 64);
        txtSuggestion.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        String message = StringConstants.TOOLTIP_MESSAGE_PROPERTIES_ENTITY;
        txtSuggestion.setText(message);
        txtSuggestion.setForeground(ColorUtil.getTooltipPlaceHolderForegroundColor());
        StyleRange sr = new StyleRange(message.indexOf(StringConstants.PROPERTIES), StringConstants.PROPERTIES.length(), null, null);
        sr.fontStyle = 3;
        txtSuggestion.setStyleRange(sr);
        txtSuggestion.setLineAlignment(0, 1, 0x1000000);
        return result;
    }

    private ITreeEntity getTreeEntity(ViewerCell cell) {
        return (ITreeEntity)this.viewer.getViewerRowFromWidgetItem(cell.getItem()).getElement();
    }

    private void createPropertiesControls(Composite result, ViewerCell cell) {
        ITreeEntity treeEntity = this.getTreeEntity(cell);
        for (TooltipPropertyDescription property : treeEntity.getTooltipDescriptions()) {
            StyledText lblPropKey = new StyledText(result, 0);
            lblPropKey.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
            lblPropKey.setText(property.getKey() + ":");
            ControlUtils.setFontToBeBold((Control)lblPropKey);
            StyledText txtPropValue = new StyledText(result, 64);
            GridData gdTxtPropertyValue = new GridData(4, 128, true, false, 1, 1);
            gdTxtPropertyValue.widthHint = 250;
            txtPropValue.setLayoutData((Object)gdTxtPropertyValue);
            String value = property.getValue();
            String valueText = property.isLengthLimited() ? StringUtils.abbreviate((String)value, (int)property.getMaxValueLength()) : value;
            txtPropValue.setText(valueText);
        }
    }

    protected boolean shouldCreateToolTip(Event event) {
        ViewerCell cell = this.getCell(event);
        if (cell != null) {
            ITreeEntity treeEntity = this.getTreeEntity(cell);
            List tooltipDescriptions = treeEntity.getTooltipDescriptions();
            return tooltipDescriptions != null && !tooltipDescriptions.isEmpty();
        }
        return false;
    }

    private ViewerCell getCell(Event event) {
        return this.viewer.getCell(new Point(event.x, event.y));
    }
}

