/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.explorer.preference;

import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.constants.StringConstants;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.setting.ExplorerSettingStore;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ExplorerSettingsPage
extends PreferencePageWithHelp {
    private Composite container;
    private List<Button> buttons;
    private List<ITreeEntity> folderTreeEntities;
    private ExplorerSettingStore store;
    @Inject
    private IEventBroker eventBroker;

    public ExplorerSettingsPage() {
        this.noDefaultButton();
        this.store = new ExplorerSettingStore(ProjectController.getInstance().getCurrentProject());
        this.folderTreeEntities = this.getFolderEntities();
        this.buttons = new ArrayList<Button>();
    }

    private List<ITreeEntity> getFolderEntities() {
        List<Object> folderTreeEntities = new ArrayList<ITreeEntity>();
        try {
            ArrayList treeEntities = TreeEntityUtil.getTreeEntities((ProjectEntity)ProjectController.getInstance().getCurrentProject(), (boolean)true);
            if (treeEntities == null) {
                treeEntities = new ArrayList();
            }
            folderTreeEntities = treeEntities.stream().filter(folderEntity -> folderEntity instanceof FolderTreeEntity).collect(Collectors.toList());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.PAGE_ERROR_MSG_UNABLE_TO_READ_SETTINGS, (String)e.getMessage());
        }
        return folderTreeEntities;
    }

    protected Control createContents(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.container.setLayout((Layout)new GridLayout(1, false));
        try {
            for (ITreeEntity folderEntity : this.folderTreeEntities) {
                String entityName = folderEntity.getText();
                Button button = new Button(this.container, 32);
                button.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
                button.setText(entityName);
                this.buttons.add(button);
            }
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.PAGE_ERROR_MSG_UNABLE_TO_READ_SETTINGS, (String)e.getMessage());
            LoggerSingleton.logError((Throwable)e);
        }
        this.updateInput();
        return this.container;
    }

    private void updateInput() {
        try {
            for (Button button : this.buttons) {
                String entityName = button.getText();
                boolean isShow = this.store.isItemShow(entityName);
                button.setSelection(isShow);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.PAGE_ERROR_MSG_UNABLE_TO_READ_SETTINGS, (String)e.getMessage());
        }
    }

    public boolean performOk() {
        if (this.container == null || this.container.isDisposed()) {
            return true;
        }
        try {
            for (Button button : this.buttons) {
                String entityName = button.getText();
                boolean isShow = button.getSelection();
                this.store.setItemShow(entityName, isShow);
            }
            this.refreshExplorer();
            return true;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.PAGE_ERROR_MSG_UNABLE_TO_UPDATE_SETTINGS, (String)e.getMessage());
            return false;
        }
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.SETTING_REPORT;
    }

    private void refreshExplorer() {
        try {
            List treeEntities = TreeEntityUtil.getTreeEntities((ProjectEntity)ProjectController.getInstance().getCurrentProject(), (boolean)false);
            this.eventBroker.post("EXPLORER/RELOAD_INPUT", (Object)treeEntities);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.PAGE_ERROR_MSG_UNABLE_TO_REFESH_EXPLORER, (String)e.getMessage());
        }
    }
}

