/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.creators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.creators.IProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.proposals.AbstractGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.IGroovyProposal;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.jdt.groovy.control.EclipseSourceUnit;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.AccessorSupport;
import org.eclipse.jdt.groovy.search.VariableScope;

public abstract class AbstractProposalCreator
implements IProposalCreator {
    protected VariableScope currentScope;
    protected Set<String> favoriteStaticMembers;
    protected BiPredicate<String, String> matcher = ProposalUtils::looselyMatches;

    public void setCurrentScope(VariableScope currentScope) {
        this.currentScope = currentScope;
    }

    public void setFavoriteStaticMembers(Set<String> favoriteStaticMembers) {
        this.favoriteStaticMembers = favoriteStaticMembers;
    }

    public void setNameMatchingStrategy(BiPredicate<String, String> strategy) {
        this.matcher = strategy;
    }

    protected static FieldNode createMockField(MethodNode method) {
        String fieldName = ProposalUtils.createMockFieldName(method.getName());
        int fieldModifiers = method.getModifiers() & 0xF | (GroovyUtils.isDeprecated((ASTNode)method) ? 0x100000 : 0);
        if (!method.getName().startsWith("set") && AccessorSupport.findAccessorMethodsForPropertyName((String)fieldName, (ClassNode)method.getDeclaringClass(), (method.getParameters().length > 0 ? 1 : 0) != 0, (AccessorSupport[])new AccessorSupport[]{AccessorSupport.SETTER}).noneMatch(x -> true)) {
            fieldModifiers |= 0x10;
        }
        ClassNode fieldType = method.getName().startsWith("set") ? ((Parameter)DefaultGroovyMethods.last((Object[])method.getParameters())).getType() : method.getReturnType();
        FieldNode fieldNode = new FieldNode(fieldName, fieldModifiers, fieldType, method.getDeclaringClass(), null);
        fieldNode.setDeclaringClass(method.getDeclaringClass());
        fieldNode.setNodeMetaData((Object)"groovy.method", (Object)method);
        fieldNode.setSourcePosition((ASTNode)method);
        fieldNode.setSynthetic(true);
        return fieldNode;
    }

    protected static void demoteLowVisibilityProposals(List<IGroovyProposal> proposals, ClassNode completionType) {
        for (IGroovyProposal proposal : proposals) {
            if (!(proposal instanceof AbstractGroovyProposal)) continue;
            AbstractGroovyProposal groovyProposal = (AbstractGroovyProposal)proposal;
            int flags = groovyProposal.getAssociatedNodeFlags();
            ClassNode declaringType = groovyProposal.getAssociatedNode().getDeclaringClass();
            if (Flags.isPublic((int)flags) || declaringType.equals((Object)completionType) || Flags.isProtected((int)flags) && completionType.isDerivedFrom(declaringType)) continue;
            groovyProposal.setRelevanceMultiplier(groovyProposal.getRelevanceMultiplier() * 0.05f);
        }
    }

    protected AccessorSupport findLooselyMatchedAccessorKind(String prefix, String methodName, boolean isCategory) {
        AccessorSupport accessor = AccessorSupport.create((String)methodName, (boolean)isCategory);
        if (accessor.isAccessor()) {
            String newName = ProposalUtils.createMockFieldName(methodName);
            return this.matcher.test(prefix, newName) ? accessor : AccessorSupport.NONE;
        }
        return AccessorSupport.NONE;
    }

    protected Collection<FieldNode> getAllFields(ClassNode thisType, Set<ClassNode> exclude) {
        if (thisType.isArray()) {
            FieldNode length = new FieldNode("length", 17, ClassHelper.int_TYPE, thisType, null);
            length.setDeclaringClass(thisType);
            return Collections.singleton(length);
        }
        HashMap<String, FieldNode> allFields = new HashMap<String, FieldNode>();
        LinkedHashSet types = new LinkedHashSet();
        VariableScope.createTypeHierarchy((ClassNode)thisType, types, (boolean)false);
        types.removeAll(exclude);
        for (ClassNode type : types) {
            List traitFields;
            ArrayList fields = type.getFields();
            if (type == thisType && (traitFields = (List)type.redirect().getNodeMetaData((Object)"trait.fields")) != null) {
                fields = new ArrayList(fields);
                fields.addAll(traitFields);
            }
            for (FieldNode field : fields) {
                FieldNode existing = (FieldNode)allFields.get(field.getName());
                if (existing != null && !AbstractProposalCreator.leftIsMoreAccessible(field, existing)) continue;
                allFields.put(field.getName(), field);
            }
        }
        exclude.addAll(types);
        return allFields.values();
    }

    protected Collection<MethodNode> getAllMethods(ClassNode type, Set<ClassNode> exclude) {
        List traitMethods;
        HashMap methods = new HashMap();
        BiConsumer<MethodNode, Map> mapper = (mn, spec) -> {
            StringBuilder sb = new StringBuilder(mn.getName());
            sb.append('(');
            Parameter[] parameterArray = mn.getParameters();
            int n = parameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter p = parameterArray[n2];
                ClassNode pt = p.getOriginType();
                if (!pt.isGenericsPlaceHolder()) {
                    sb.append(pt.getName());
                } else {
                    sb.append(spec.getOrDefault(pt.getUnresolvedName(), pt).getName());
                }
                sb.append(';');
                ++n2;
            }
            methods.merge(sb.toString(), mn, (m1, m2) -> !Flags.isSynthetic((int)m1.getModifiers()) ? m1 : m2);
        };
        if (!(exclude != null && exclude.contains(type) || (traitMethods = (List)type.redirect().getNodeMetaData((Object)"trait.methods")) == null || traitMethods.isEmpty())) {
            for (MethodNode mn2 : traitMethods) {
                mapper.accept(mn2, Collections.emptyMap());
            }
        }
        LinkedHashSet<ClassNode> types = new LinkedHashSet<ClassNode>();
        VariableScope.createTypeHierarchy((ClassNode)type, types, (boolean)true);
        if (type.isInterface()) {
            types.add(ClassHelper.OBJECT_TYPE);
        }
        for (ClassNode cn : types) {
            if (exclude != null && exclude.contains(cn) || Flags.isSynthetic((int)cn.getModifiers())) continue;
            Map spec2 = GenericsUtils.createGenericsSpec((ClassNode)cn);
            for (MethodNode mn3 : cn.getMethods()) {
                mapper.accept(mn3, spec2);
            }
        }
        if (exclude != null) {
            exclude.addAll(types);
        }
        return methods.values();
    }

    protected static boolean leftIsMoreAccessible(FieldNode field, FieldNode existing) {
        return (switch (field.getModifiers() & 7) {
            case 1 -> 0;
            case 4 -> 1;
            case 2 -> 3;
            default -> 2;
        }) < (switch (existing.getModifiers() & 7) {
            case 1 -> 0;
            case 4 -> 1;
            case 2 -> 3;
            default -> 2;
        });
    }

    protected static boolean hasNoField(ClassNode declaringClass, String methodName) {
        return !"getClass".equals(methodName) && declaringClass.getField(ProposalUtils.createMockFieldName(methodName)) == null && declaringClass.getField(ProposalUtils.createCapitalMockFieldName(methodName)) == null;
    }

    protected static ClassNode tryResolveClassNode(String typeName, ModuleNode module) {
        for (ClassNode t : module.getClasses()) {
            if (!t.getName().equals(typeName)) continue;
            return t;
        }
        SourceUnit context = module.getContext();
        if (context instanceof EclipseSourceUnit) {
            ClassNode typeNode = ((EclipseSourceUnit)context).resolver.resolve(typeName);
            if (typeNode.equals((Object)ClassHelper.OBJECT_TYPE) && !typeName.equals("java.lang.Object")) {
                return null;
            }
            return typeNode;
        }
        try {
            Class t = context.getClassLoader().loadClass(typeName, true, true, true);
            ClassNode typeNode = ClassHelper.make((Class)t);
            typeNode.lazyClassInit();
            return typeNode;
        }
        catch (ClassNotFoundException | LinkageError ignore) {
            return null;
        }
    }
}

