/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.relevance.internal;

import org.codehaus.groovy.eclipse.codeassist.relevance.IRelevanceRule;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.compiler.CharOperation;

public class PackageLocalityRule
implements IRelevanceRule {
    @Override
    public int getRelevance(char[] fullyQualifiedName, IType[] contextTypes, int accessibility, int modifiers) {
        int relevance = 0;
        String qualifiedName = String.valueOf(fullyQualifiedName);
        if (PackageLocalityRule.isInSameFile(qualifiedName, contextTypes)) {
            relevance = 10;
        } else {
            IPackageFragment contextFragment = PackageLocalityRule.getContextPackageFragment(contextTypes);
            if (contextFragment != null) {
                if (contextFragment.isDefaultPackage()) {
                    if (!CharOperation.contains((char)'.', (char[])fullyQualifiedName)) {
                        relevance = 1;
                    }
                } else {
                    String[] testingSegments = qualifiedName.split("\\.");
                    String[] contextSegments = contextFragment.getElementName().split("\\.");
                    int i = 0;
                    while (i < testingSegments.length && i < contextSegments.length) {
                        if (!testingSegments[i].equals(contextSegments[i])) break;
                        ++relevance;
                        ++i;
                    }
                    if (relevance > 0 && contextSegments[0].matches("com|edu|net|org")) {
                        --relevance;
                    }
                }
            }
        }
        return relevance;
    }

    private static boolean isInSameFile(String fullyQualifiedName, IType[] contextTypes) {
        IType[] iTypeArray = contextTypes;
        int n = contextTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType contextType = iTypeArray[n2];
            if (fullyQualifiedName.endsWith(contextType.getElementName()) && fullyQualifiedName.equals(contextType.getFullyQualifiedName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static IPackageFragment getContextPackageFragment(IType[] contextTypes) {
        if (contextTypes == null) {
            return null;
        }
        IPackageFragment frag = null;
        IType[] iTypeArray = contextTypes;
        int n = contextTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            IPackageFragment next = type.getPackageFragment();
            if (frag != null && !frag.equals(next)) {
                return null;
            }
            frag = next;
            ++n2;
        }
        return frag;
    }
}

