/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.requestor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.codeassist.DocumentSourceBuffer;
import org.codehaus.groovy.eclipse.codeassist.GroovyContentAssist;
import org.codehaus.groovy.eclipse.codeassist.factories.AnnotationCollectorTypeCompletionProcessorFactory;
import org.codehaus.groovy.eclipse.codeassist.factories.AnnotationMemberValueCompletionProcessorFactory;
import org.codehaus.groovy.eclipse.codeassist.factories.ConstructorCompletionProcessorFactory;
import org.codehaus.groovy.eclipse.codeassist.factories.ExpressionCompletionProcessorFactory;
import org.codehaus.groovy.eclipse.codeassist.factories.GetSetMethodCompletionProcessorFactory;
import org.codehaus.groovy.eclipse.codeassist.factories.IGroovyCompletionProcessorFactory;
import org.codehaus.groovy.eclipse.codeassist.factories.LocalVariableCompletionProcessorFactory;
import org.codehaus.groovy.eclipse.codeassist.factories.ModifiersCompletionProcessorFactory;
import org.codehaus.groovy.eclipse.codeassist.factories.NewFieldCompletionProcessorFactory;
import org.codehaus.groovy.eclipse.codeassist.factories.NewMethodCompletionProcessorFactory;
import org.codehaus.groovy.eclipse.codeassist.factories.NewVariableCompletionProcessorFactory;
import org.codehaus.groovy.eclipse.codeassist.factories.PackageCompletionProcessorFactory;
import org.codehaus.groovy.eclipse.codeassist.factories.TypeCompletionProcessorFactory;
import org.codehaus.groovy.eclipse.codeassist.processors.IGroovyCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.processors.IProposalFilter;
import org.codehaus.groovy.eclipse.codeassist.processors.IProposalFilterExtension;
import org.codehaus.groovy.eclipse.codeassist.processors.ProposalProviderRegistry;
import org.codehaus.groovy.eclipse.codeassist.requestor.CompletionNodeFinder;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistLocation;
import org.codehaus.groovy.eclipse.core.ISourceBuffer;
import org.codehaus.groovy.eclipse.core.util.ExpressionFinder;
import org.codehaus.groovy.eclipse.core.util.ParseException;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.codehaus.jdt.groovy.model.ModuleNodeMapper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.groovy.search.ITypeResolver;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;

public class GroovyCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    private static final Map<ContentAssistLocation, List<IGroovyCompletionProcessorFactory>> LOCATION_FACTORIES;

    static {
        EnumMap<ContentAssistLocation, List<IGroovyCompletionProcessorFactory>> locationFactories = new EnumMap<ContentAssistLocation, List<IGroovyCompletionProcessorFactory>>(ContentAssistLocation.class);
        locationFactories.put(ContentAssistLocation.ANNOTATION, Collections.unmodifiableList(Arrays.asList(new TypeCompletionProcessorFactory(), new PackageCompletionProcessorFactory(), new AnnotationCollectorTypeCompletionProcessorFactory())));
        locationFactories.put(ContentAssistLocation.ANNOTATION_BODY, Collections.singletonList(new AnnotationMemberValueCompletionProcessorFactory()));
        locationFactories.put(ContentAssistLocation.CLASS_BODY, Collections.unmodifiableList(Arrays.asList(new ModifiersCompletionProcessorFactory(), new NewMethodCompletionProcessorFactory(), new GetSetMethodCompletionProcessorFactory(), new NewFieldCompletionProcessorFactory(), new TypeCompletionProcessorFactory(), new PackageCompletionProcessorFactory(), new NewVariableCompletionProcessorFactory())));
        locationFactories.put(ContentAssistLocation.CONSTRUCTOR, Collections.unmodifiableList(Arrays.asList(new TypeCompletionProcessorFactory(), new PackageCompletionProcessorFactory(), new ConstructorCompletionProcessorFactory())));
        locationFactories.put(ContentAssistLocation.EXCEPTIONS, Collections.unmodifiableList(Arrays.asList(new TypeCompletionProcessorFactory(), new PackageCompletionProcessorFactory())));
        locationFactories.put(ContentAssistLocation.EXPRESSION, Collections.unmodifiableList(Arrays.asList(new TypeCompletionProcessorFactory(), new PackageCompletionProcessorFactory(), new ExpressionCompletionProcessorFactory())));
        locationFactories.put(ContentAssistLocation.EXTENDS, Collections.unmodifiableList(Arrays.asList(new TypeCompletionProcessorFactory(), new PackageCompletionProcessorFactory())));
        locationFactories.put(ContentAssistLocation.GENERICS, Collections.unmodifiableList(Arrays.asList(new TypeCompletionProcessorFactory(), new PackageCompletionProcessorFactory())));
        locationFactories.put(ContentAssistLocation.IMPLEMENTS, Collections.unmodifiableList(Arrays.asList(new TypeCompletionProcessorFactory(), new PackageCompletionProcessorFactory())));
        locationFactories.put(ContentAssistLocation.IMPORT, Collections.unmodifiableList(Arrays.asList(new TypeCompletionProcessorFactory(), new PackageCompletionProcessorFactory(), new ExpressionCompletionProcessorFactory())));
        locationFactories.put(ContentAssistLocation.METHOD_CONTEXT, Collections.unmodifiableList(Arrays.asList(new ExpressionCompletionProcessorFactory(), new ConstructorCompletionProcessorFactory(), new TypeCompletionProcessorFactory(), new PackageCompletionProcessorFactory(), new LocalVariableCompletionProcessorFactory())));
        locationFactories.put(ContentAssistLocation.PACKAGE, Collections.singletonList(new PackageCompletionProcessorFactory()));
        locationFactories.put(ContentAssistLocation.PARAMETER, Collections.unmodifiableList(Arrays.asList(new TypeCompletionProcessorFactory(), new PackageCompletionProcessorFactory())));
        locationFactories.put(ContentAssistLocation.PERMITS, Collections.unmodifiableList(Arrays.asList(new TypeCompletionProcessorFactory(), new PackageCompletionProcessorFactory())));
        locationFactories.put(ContentAssistLocation.SCRIPT, Collections.unmodifiableList(Arrays.asList(new TypeCompletionProcessorFactory(), new PackageCompletionProcessorFactory(), new ExpressionCompletionProcessorFactory(), new LocalVariableCompletionProcessorFactory(), new ModifiersCompletionProcessorFactory(), new NewFieldCompletionProcessorFactory(), new NewMethodCompletionProcessorFactory(), new NewVariableCompletionProcessorFactory())));
        locationFactories.put(ContentAssistLocation.STATEMENT, Collections.unmodifiableList(Arrays.asList(new TypeCompletionProcessorFactory(), new PackageCompletionProcessorFactory(), new ExpressionCompletionProcessorFactory(), new ConstructorCompletionProcessorFactory(), new LocalVariableCompletionProcessorFactory(), new NewVariableCompletionProcessorFactory())));
        LOCATION_FACTORIES = Collections.unmodifiableMap(locationFactories);
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        GroovyCompilationUnit gunit;
        ModuleNodeMapper.ModuleNodeInfo moduleInfo;
        if (!(context instanceof JavaContentAssistInvocationContext)) {
            return Collections.EMPTY_LIST;
        }
        JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
        ICompilationUnit unit = javaContext.getCompilationUnit();
        if (!(unit instanceof GroovyCompilationUnit)) {
            return Collections.EMPTY_LIST;
        }
        String traceEvent = null;
        if (GroovyLogManager.manager.hasLoggers()) {
            GroovyLogManager.manager.log(TraceCategory.CONTENT_ASSIST, "Starting content assist for " + unit.getElementName());
            traceEvent = "Content assist for " + unit.getElementName();
            GroovyLogManager.manager.logStart(traceEvent);
        }
        if ((moduleInfo = (gunit = (GroovyCompilationUnit)unit).getModuleInfo(true)) == null) {
            if (traceEvent != null) {
                GroovyLogManager.manager.log(TraceCategory.CONTENT_ASSIST, "Null module node");
            }
            return Collections.EMPTY_LIST;
        }
        int offset = context.getInvocationOffset();
        IDocument document = context.getDocument();
        if (offset < 0 || offset > document.getLength()) {
            if (traceEvent != null) {
                GroovyLogManager.manager.log(TraceCategory.CONTENT_ASSIST, "Completion offset " + offset + " is out of bounds");
            }
            return Collections.EMPTY_LIST;
        }
        ContentAssistContext assistContext = this.createContentAssistContext(gunit, offset, document);
        List<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        if (assistContext != null) {
            List<IGroovyCompletionProcessorFactory> factories = LOCATION_FACTORIES.get((Object)assistContext.location);
            if (factories != null) {
                SubMonitor submon = SubMonitor.convert((IProgressMonitor)monitor, (int)factories.size());
                SearchableEnvironment environment = this.createSearchableEnvironment(javaContext);
                try {
                    for (IGroovyCompletionProcessorFactory factory : factories) {
                        IGroovyCompletionProcessor processor = factory.createProcessor(assistContext, javaContext, environment);
                        if (processor == null) continue;
                        if (processor instanceof ITypeResolver) {
                            ((ITypeResolver)processor).setResolverInformation(moduleInfo.module, moduleInfo.resolver);
                        }
                        proposals.addAll(processor.generateProposals((IProgressMonitor)submon.split(1)));
                    }
                }
                finally {
                    if (environment != null) {
                        environment.cleanup();
                    }
                }
            }
            try {
                List<IProposalFilter> filters = ProposalProviderRegistry.getRegistry().getFiltersFor(assistContext.unit);
                for (IProposalFilter filter : filters) {
                    try {
                        List<ICompletionProposal> newProposals;
                        if (!(filter instanceof IProposalFilterExtension) || (newProposals = ((IProposalFilterExtension)filter).filterExtendedProposals(proposals, assistContext, javaContext)) == null) continue;
                        proposals = newProposals;
                    }
                    catch (Exception e) {
                        GroovyContentAssist.logError("Exception when using third party proposal filter: " + filter.getClass().getCanonicalName(), e);
                    }
                }
            }
            catch (CoreException e) {
                GroovyContentAssist.logError("Exception accessing proposal provider registry", e);
            }
        }
        if (traceEvent != null) {
            GroovyLogManager.manager.logEnd(traceEvent, TraceCategory.CONTENT_ASSIST);
        }
        return proposals;
    }

    public ContentAssistContext createContentAssistContext(GroovyCompilationUnit gunit, int invocationOffset, IDocument document) {
        String fullCompletionText = this.findCompletionText(document, invocationOffset);
        String[] completionExpressions = this.findCompletionExpression(fullCompletionText);
        String completionExpression = completionExpressions == null || "@".equals(fullCompletionText) ? "" : (completionExpressions[1] == null ? completionExpressions[0] : completionExpressions[1]);
        int completionEnd = this.findCompletionEnd(document, invocationOffset);
        int supportingNodeEnd = this.findSupportingNodeEnd(gunit, invocationOffset, fullCompletionText);
        CompletionNodeFinder finder = new CompletionNodeFinder(invocationOffset, completionEnd, supportingNodeEnd, completionExpression, fullCompletionText);
        ContentAssistContext context = finder.findContentAssistContext(gunit);
        return context;
    }

    private SearchableEnvironment createSearchableEnvironment(JavaContentAssistInvocationContext javaContext) {
        try {
            return ((JavaProject)javaContext.getProject()).newSearchableNameEnvironment(javaContext.getCompilationUnit().getOwner());
        }
        catch (JavaModelException e) {
            GroovyContentAssist.logError("Exception creating searchable environment for " + String.valueOf(javaContext.getCompilationUnit()), e);
            return null;
        }
    }

    private String[] findCompletionExpression(String completionText) {
        return new ExpressionFinder().splitForCompletion(completionText);
    }

    protected String findCompletionText(IDocument doc, int offset) {
        String result;
        block3: {
            result = null;
            try {
                if (offset > 0) {
                    DocumentSourceBuffer buffer = new DocumentSourceBuffer(doc);
                    result = new ExpressionFinder().findForCompletions((ISourceBuffer)buffer, offset - 1);
                }
            }
            catch (ParseException e) {
                if (!GroovyLogManager.manager.hasLoggers()) break block3;
                GroovyLogManager.manager.logException(TraceCategory.CONTENT_ASSIST, (Throwable)e);
            }
        }
        return result != null ? result : "";
    }

    private int findCompletionEnd(IDocument doc, int offset) {
        DocumentSourceBuffer buffer = new DocumentSourceBuffer(doc);
        return new ExpressionFinder().findTokenEnd((ISourceBuffer)buffer, offset);
    }

    protected int findSupportingNodeEnd(GroovyCompilationUnit gunit, int invocationOffset, String fullCompletionText) {
        String[] completionExpressions = new ExpressionFinder().splitForCompletionNoTrim(fullCompletionText);
        if (completionExpressions[1] == null) {
            return -1;
        }
        return invocationOffset - fullCompletionText.length() + completionExpressions[0].length();
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        List<ICompletionProposal> proposals = this.computeCompletionProposals(context, monitor);
        ArrayList<IContextInformation> contexts = new ArrayList<IContextInformation>(proposals.size());
        for (ICompletionProposal proposal : proposals) {
            if (proposal.getContextInformation() == null) continue;
            contexts.add(proposal.getContextInformation());
        }
        return contexts;
    }

    public String getErrorMessage() {
        return "";
    }

    public void sessionStarted() {
    }

    public void sessionEnded() {
    }
}

