/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server;

import io.modelcontextprotocol.common.McpTransportContext;
import io.modelcontextprotocol.json.McpJsonMapper;
import io.modelcontextprotocol.json.TypeRef;
import io.modelcontextprotocol.json.schema.JsonSchemaValidator;
import io.modelcontextprotocol.server.DefaultMcpStatelessServerHandler;
import io.modelcontextprotocol.server.McpStatelessRequestHandler;
import io.modelcontextprotocol.server.McpStatelessServerFeatures;
import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpStatelessServerTransport;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.DefaultMcpUriTemplateManagerFactory;
import io.modelcontextprotocol.util.McpUriTemplateManager;
import io.modelcontextprotocol.util.McpUriTemplateManagerFactory;
import io.modelcontextprotocol.util.Utils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class McpStatelessAsyncServer {
    private static final Logger logger = LoggerFactory.getLogger(McpStatelessAsyncServer.class);
    private final McpStatelessServerTransport mcpTransportProvider;
    private final McpJsonMapper jsonMapper;
    private final McpSchema.ServerCapabilities serverCapabilities;
    private final McpSchema.Implementation serverInfo;
    private final String instructions;
    private final CopyOnWriteArrayList<McpStatelessServerFeatures.AsyncToolSpecification> tools = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<String, McpStatelessServerFeatures.AsyncResourceTemplateSpecification> resourceTemplates = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, McpStatelessServerFeatures.AsyncResourceSpecification> resources = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, McpStatelessServerFeatures.AsyncPromptSpecification> prompts = new ConcurrentHashMap();
    private final ConcurrentHashMap<McpSchema.CompleteReference, McpStatelessServerFeatures.AsyncCompletionSpecification> completions = new ConcurrentHashMap();
    private List<String> protocolVersions;
    private McpUriTemplateManagerFactory uriTemplateManagerFactory = new DefaultMcpUriTemplateManagerFactory();
    private final JsonSchemaValidator jsonSchemaValidator;
    private static final Mono<McpSchema.CompleteResult> EMPTY_COMPLETION_RESULT = Mono.just((Object)new McpSchema.CompleteResult(new McpSchema.CompleteResult.CompleteCompletion(List.of(), 0, false)));

    McpStatelessAsyncServer(McpStatelessServerTransport mcpTransport, McpJsonMapper jsonMapper, McpStatelessServerFeatures.Async features, Duration requestTimeout, McpUriTemplateManagerFactory uriTemplateManagerFactory, JsonSchemaValidator jsonSchemaValidator) {
        this.mcpTransportProvider = mcpTransport;
        this.jsonMapper = jsonMapper;
        this.serverInfo = features.serverInfo();
        this.serverCapabilities = features.serverCapabilities();
        this.instructions = features.instructions();
        this.tools.addAll(McpStatelessAsyncServer.withStructuredOutputHandling(jsonSchemaValidator, features.tools()));
        this.resources.putAll(features.resources());
        this.resourceTemplates.putAll(features.resourceTemplates());
        this.prompts.putAll(features.prompts());
        this.completions.putAll(features.completions());
        this.uriTemplateManagerFactory = uriTemplateManagerFactory;
        this.jsonSchemaValidator = jsonSchemaValidator;
        HashMap requestHandlers = new HashMap();
        requestHandlers.put("ping", (ctx, params) -> Mono.just(Map.of()));
        requestHandlers.put("initialize", this.asyncInitializeRequestHandler());
        if (this.serverCapabilities.tools() != null) {
            requestHandlers.put("tools/list", this.toolsListRequestHandler());
            requestHandlers.put("tools/call", this.toolsCallRequestHandler());
        }
        if (this.serverCapabilities.resources() != null) {
            requestHandlers.put("resources/list", this.resourcesListRequestHandler());
            requestHandlers.put("resources/read", this.resourcesReadRequestHandler());
            requestHandlers.put("resources/templates/list", this.resourceTemplateListRequestHandler());
        }
        if (this.serverCapabilities.prompts() != null) {
            requestHandlers.put("prompts/list", this.promptsListRequestHandler());
            requestHandlers.put("prompts/get", this.promptsGetRequestHandler());
        }
        if (this.serverCapabilities.completions() != null) {
            requestHandlers.put("completion/complete", this.completionCompleteRequestHandler());
        }
        this.protocolVersions = new ArrayList<String>(mcpTransport.protocolVersions());
        DefaultMcpStatelessServerHandler handler = new DefaultMcpStatelessServerHandler(requestHandlers, Map.of());
        mcpTransport.setMcpHandler(handler);
    }

    private McpStatelessRequestHandler<McpSchema.InitializeResult> asyncInitializeRequestHandler() {
        return (ctx, req) -> Mono.defer(() -> {
            McpSchema.InitializeRequest initializeRequest = this.jsonMapper.convertValue(req, McpSchema.InitializeRequest.class);
            logger.info("Client initialize request - Protocol: {}, Capabilities: {}, Info: {}", new Object[]{initializeRequest.protocolVersion(), initializeRequest.capabilities(), initializeRequest.clientInfo()});
            String serverProtocolVersion = this.protocolVersions.get(this.protocolVersions.size() - 1);
            if (this.protocolVersions.contains(initializeRequest.protocolVersion())) {
                serverProtocolVersion = initializeRequest.protocolVersion();
            } else {
                logger.warn("Client requested unsupported protocol version: {}, so the server will suggest the {} version instead", (Object)initializeRequest.protocolVersion(), (Object)serverProtocolVersion);
            }
            return Mono.just((Object)new McpSchema.InitializeResult(serverProtocolVersion, this.serverCapabilities, this.serverInfo, this.instructions));
        });
    }

    public McpSchema.ServerCapabilities getServerCapabilities() {
        return this.serverCapabilities;
    }

    public McpSchema.Implementation getServerInfo() {
        return this.serverInfo;
    }

    public Mono<Void> closeGracefully() {
        return this.mcpTransportProvider.closeGracefully();
    }

    public void close() {
        this.mcpTransportProvider.close();
    }

    private static List<McpStatelessServerFeatures.AsyncToolSpecification> withStructuredOutputHandling(JsonSchemaValidator jsonSchemaValidator, List<McpStatelessServerFeatures.AsyncToolSpecification> tools) {
        if (Utils.isEmpty(tools)) {
            return tools;
        }
        return tools.stream().map(tool -> McpStatelessAsyncServer.withStructuredOutputHandling(jsonSchemaValidator, tool)).toList();
    }

    private static McpStatelessServerFeatures.AsyncToolSpecification withStructuredOutputHandling(JsonSchemaValidator jsonSchemaValidator, McpStatelessServerFeatures.AsyncToolSpecification toolSpecification) {
        if (toolSpecification.callHandler() instanceof StructuredOutputCallToolHandler) {
            return toolSpecification;
        }
        if (toolSpecification.tool().outputSchema() == null) {
            return toolSpecification;
        }
        return new McpStatelessServerFeatures.AsyncToolSpecification(toolSpecification.tool(), new StructuredOutputCallToolHandler(jsonSchemaValidator, toolSpecification.tool().outputSchema(), toolSpecification.callHandler()));
    }

    public Mono<Void> addTool(McpStatelessServerFeatures.AsyncToolSpecification toolSpecification) {
        if (toolSpecification == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Tool specification must not be null"));
        }
        if (toolSpecification.tool() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Tool must not be null"));
        }
        if (toolSpecification.callHandler() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Tool call handler must not be null"));
        }
        if (this.serverCapabilities.tools() == null) {
            return Mono.error((Throwable)new IllegalStateException("Server must be configured with tool capabilities"));
        }
        McpStatelessServerFeatures.AsyncToolSpecification wrappedToolSpecification = McpStatelessAsyncServer.withStructuredOutputHandling(this.jsonSchemaValidator, toolSpecification);
        return Mono.defer(() -> {
            if (this.tools.removeIf(th -> th.tool().name().equals(wrappedToolSpecification.tool().name()))) {
                logger.warn("Replace existing Tool with name '{}'", (Object)wrappedToolSpecification.tool().name());
            }
            this.tools.add(wrappedToolSpecification);
            logger.debug("Added tool handler: {}", (Object)wrappedToolSpecification.tool().name());
            return Mono.empty();
        });
    }

    public Flux<McpSchema.Tool> listTools() {
        return Flux.fromIterable(this.tools).map(McpStatelessServerFeatures.AsyncToolSpecification::tool);
    }

    public Mono<Void> removeTool(String toolName) {
        if (toolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Tool name must not be null"));
        }
        if (this.serverCapabilities.tools() == null) {
            return Mono.error((Throwable)new IllegalStateException("Server must be configured with tool capabilities"));
        }
        return Mono.defer(() -> {
            if (this.tools.removeIf(toolSpecification -> toolSpecification.tool().name().equals(toolName))) {
                logger.debug("Removed tool handler: {}", (Object)toolName);
            } else {
                logger.warn("Ignore as a Tool with name '{}' not found", (Object)toolName);
            }
            return Mono.empty();
        });
    }

    private McpStatelessRequestHandler<McpSchema.ListToolsResult> toolsListRequestHandler() {
        return (ctx, params) -> {
            List<McpSchema.Tool> tools = this.tools.stream().map(McpStatelessServerFeatures.AsyncToolSpecification::tool).toList();
            return Mono.just((Object)new McpSchema.ListToolsResult(tools, null));
        };
    }

    private McpStatelessRequestHandler<McpSchema.CallToolResult> toolsCallRequestHandler() {
        return (ctx, params) -> {
            McpSchema.CallToolRequest callToolRequest = this.jsonMapper.convertValue(params, new TypeRef<McpSchema.CallToolRequest>(){});
            Optional<McpStatelessServerFeatures.AsyncToolSpecification> toolSpecification = this.tools.stream().filter(tr -> callToolRequest.name().equals(tr.tool().name())).findAny();
            if (toolSpecification.isEmpty()) {
                return Mono.error((Throwable)McpError.builder(-32602).message("Unknown tool: invalid_tool_name").data("Tool not found: " + callToolRequest.name()).build());
            }
            return toolSpecification.get().callHandler().apply(ctx, callToolRequest);
        };
    }

    public Mono<Void> addResource(McpStatelessServerFeatures.AsyncResourceSpecification resourceSpecification) {
        if (resourceSpecification == null || resourceSpecification.resource() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Resource must not be null"));
        }
        if (this.serverCapabilities.resources() == null) {
            return Mono.error((Throwable)new IllegalStateException("Server must be configured with resource capabilities"));
        }
        return Mono.defer(() -> {
            McpStatelessServerFeatures.AsyncResourceSpecification previous = this.resources.put(resourceSpecification.resource().uri(), resourceSpecification);
            if (previous != null) {
                logger.warn("Replace existing Resource with URI '{}'", (Object)resourceSpecification.resource().uri());
            } else {
                logger.debug("Added resource handler: {}", (Object)resourceSpecification.resource().uri());
            }
            return Mono.empty();
        });
    }

    public Flux<McpSchema.Resource> listResources() {
        return Flux.fromIterable(this.resources.values()).map(McpStatelessServerFeatures.AsyncResourceSpecification::resource);
    }

    public Mono<Void> removeResource(String resourceUri) {
        if (resourceUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Resource URI must not be null"));
        }
        if (this.serverCapabilities.resources() == null) {
            return Mono.error((Throwable)new IllegalStateException("Server must be configured with resource capabilities"));
        }
        return Mono.defer(() -> {
            McpStatelessServerFeatures.AsyncResourceSpecification removed = this.resources.remove(resourceUri);
            if (removed != null) {
                logger.debug("Removed resource handler: {}", (Object)resourceUri);
            } else {
                logger.warn("Resource with URI '{}' not found", (Object)resourceUri);
            }
            return Mono.empty();
        });
    }

    public Mono<Void> addResourceTemplate(McpStatelessServerFeatures.AsyncResourceTemplateSpecification resourceTemplateSpecification) {
        if (this.serverCapabilities.resources() == null) {
            return Mono.error((Throwable)new IllegalStateException("Server must be configured with resource capabilities to allow adding resource templates"));
        }
        return Mono.defer(() -> {
            McpStatelessServerFeatures.AsyncResourceTemplateSpecification previous = this.resourceTemplates.put(resourceTemplateSpecification.resourceTemplate().uriTemplate(), resourceTemplateSpecification);
            if (previous != null) {
                logger.warn("Replace existing Resource Template with URI '{}'", (Object)resourceTemplateSpecification.resourceTemplate().uriTemplate());
            } else {
                logger.debug("Added resource template handler: {}", (Object)resourceTemplateSpecification.resourceTemplate().uriTemplate());
            }
            return Mono.empty();
        });
    }

    public Flux<McpSchema.ResourceTemplate> listResourceTemplates() {
        return Flux.fromIterable(this.resourceTemplates.values()).map(McpStatelessServerFeatures.AsyncResourceTemplateSpecification::resourceTemplate);
    }

    public Mono<Void> removeResourceTemplate(String uriTemplate) {
        if (this.serverCapabilities.resources() == null) {
            return Mono.error((Throwable)new IllegalStateException("Server must be configured with resource capabilities to allow removing resource templates"));
        }
        return Mono.defer(() -> {
            McpStatelessServerFeatures.AsyncResourceTemplateSpecification removed = this.resourceTemplates.remove(uriTemplate);
            if (removed != null) {
                logger.debug("Removed resource template: {}", (Object)uriTemplate);
            } else {
                logger.warn("Ignore as a Resource Template with URI '{}' not found", (Object)uriTemplate);
            }
            return Mono.empty();
        });
    }

    private McpStatelessRequestHandler<McpSchema.ListResourcesResult> resourcesListRequestHandler() {
        return (ctx, params) -> {
            List<McpSchema.Resource> resourceList = this.resources.values().stream().map(McpStatelessServerFeatures.AsyncResourceSpecification::resource).toList();
            return Mono.just((Object)new McpSchema.ListResourcesResult(resourceList, null));
        };
    }

    private McpStatelessRequestHandler<McpSchema.ListResourceTemplatesResult> resourceTemplateListRequestHandler() {
        return (exchange, params) -> {
            List<McpSchema.ResourceTemplate> resourceList = this.resourceTemplates.values().stream().map(McpStatelessServerFeatures.AsyncResourceTemplateSpecification::resourceTemplate).toList();
            return Mono.just((Object)new McpSchema.ListResourceTemplatesResult(resourceList, null));
        };
    }

    private McpStatelessRequestHandler<McpSchema.ReadResourceResult> resourcesReadRequestHandler() {
        return (ctx, params) -> {
            McpSchema.ReadResourceRequest resourceRequest = this.jsonMapper.convertValue(params, new TypeRef<McpSchema.ReadResourceRequest>(){});
            String resourceUri = resourceRequest.uri();
            return this.findResourceSpecification(resourceUri).map(spec -> spec.readHandler().apply(ctx, resourceRequest)).orElseGet(() -> this.findResourceTemplateSpecification(resourceUri).map(spec -> spec.readHandler().apply(ctx, resourceRequest)).orElseGet(() -> Mono.error((Throwable)McpError.RESOURCE_NOT_FOUND.apply(resourceUri))));
        };
    }

    private Optional<McpStatelessServerFeatures.AsyncResourceSpecification> findResourceSpecification(String uri) {
        Optional<McpStatelessServerFeatures.AsyncResourceSpecification> result = this.resources.values().stream().filter(spec -> this.uriTemplateManagerFactory.create(spec.resource().uri()).matches(uri)).findFirst();
        return result;
    }

    private Optional<McpStatelessServerFeatures.AsyncResourceTemplateSpecification> findResourceTemplateSpecification(String uri) {
        return this.resourceTemplates.values().stream().filter(spec -> this.uriTemplateManagerFactory.create(spec.resourceTemplate().uriTemplate()).matches(uri)).findFirst();
    }

    public Mono<Void> addPrompt(McpStatelessServerFeatures.AsyncPromptSpecification promptSpecification) {
        if (promptSpecification == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Prompt specification must not be null"));
        }
        if (this.serverCapabilities.prompts() == null) {
            return Mono.error((Throwable)new IllegalStateException("Server must be configured with prompt capabilities"));
        }
        return Mono.defer(() -> {
            McpStatelessServerFeatures.AsyncPromptSpecification previous = this.prompts.put(promptSpecification.prompt().name(), promptSpecification);
            if (previous != null) {
                logger.warn("Replace existing Prompt with name '{}'", (Object)promptSpecification.prompt().name());
            } else {
                logger.debug("Added prompt handler: {}", (Object)promptSpecification.prompt().name());
            }
            return Mono.empty();
        });
    }

    public Flux<McpSchema.Prompt> listPrompts() {
        return Flux.fromIterable(this.prompts.values()).map(McpStatelessServerFeatures.AsyncPromptSpecification::prompt);
    }

    public Mono<Void> removePrompt(String promptName) {
        if (promptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Prompt name must not be null"));
        }
        if (this.serverCapabilities.prompts() == null) {
            return Mono.error((Throwable)new IllegalStateException("Server must be configured with prompt capabilities"));
        }
        return Mono.defer(() -> {
            McpStatelessServerFeatures.AsyncPromptSpecification removed = this.prompts.remove(promptName);
            if (removed != null) {
                logger.debug("Removed prompt handler: {}", (Object)promptName);
                return Mono.empty();
            }
            logger.warn("Ignore as a Prompt with name '{}' not found", (Object)promptName);
            return Mono.empty();
        });
    }

    private McpStatelessRequestHandler<McpSchema.ListPromptsResult> promptsListRequestHandler() {
        return (ctx, params) -> {
            List<McpSchema.Prompt> promptList = this.prompts.values().stream().map(McpStatelessServerFeatures.AsyncPromptSpecification::prompt).toList();
            return Mono.just((Object)new McpSchema.ListPromptsResult(promptList, null));
        };
    }

    private McpStatelessRequestHandler<McpSchema.GetPromptResult> promptsGetRequestHandler() {
        return (ctx, params) -> {
            McpSchema.GetPromptRequest promptRequest = this.jsonMapper.convertValue(params, new TypeRef<McpSchema.GetPromptRequest>(){});
            McpStatelessServerFeatures.AsyncPromptSpecification specification = this.prompts.get(promptRequest.name());
            if (specification == null) {
                return Mono.error((Throwable)McpError.builder(-32602).message("Invalid prompt name").data("Prompt not found: " + promptRequest.name()).build());
            }
            return specification.promptHandler().apply(ctx, promptRequest);
        };
    }

    private McpStatelessRequestHandler<McpSchema.CompleteResult> completionCompleteRequestHandler() {
        return (ctx, params) -> {
            McpStatelessServerFeatures.AsyncCompletionSpecification specification;
            McpSchema.CompleteReference patt28292$temp;
            McpSchema.CompleteReference patt27479$temp;
            McpSchema.CompleteRequest request = this.parseCompletionParams(params);
            if (request.ref() == null) {
                return Mono.error((Throwable)McpError.builder(-32602).message("Completion ref must not be null").build());
            }
            if (request.ref().type() == null) {
                return Mono.error((Throwable)McpError.builder(-32602).message("Completion ref type must not be null").build());
            }
            String type = request.ref().type();
            String argumentName = request.argument().name();
            if (type.equals("ref/prompt") && (patt27479$temp = request.ref()) instanceof McpSchema.PromptReference) {
                McpSchema.PromptReference promptReference = (McpSchema.PromptReference)patt27479$temp;
                McpStatelessServerFeatures.AsyncPromptSpecification promptSpec = this.prompts.get(promptReference.name());
                if (promptSpec == null) {
                    return Mono.error((Throwable)McpError.builder(-32602).message("Prompt not found: " + promptReference.name()).build());
                }
                if (!promptSpec.prompt().arguments().stream().filter(arg -> arg.name().equals(argumentName)).findFirst().isPresent()) {
                    logger.warn("Argument not found: {} in prompt: {}", (Object)argumentName, (Object)promptReference.name());
                    return EMPTY_COMPLETION_RESULT;
                }
            }
            if (type.equals("ref/resource") && (patt28292$temp = request.ref()) instanceof McpSchema.ResourceReference) {
                McpSchema.ResourceReference resourceReference = (McpSchema.ResourceReference)patt28292$temp;
                McpUriTemplateManager uriTemplateManager = this.uriTemplateManagerFactory.create(resourceReference.uri());
                if (!uriTemplateManager.isUriTemplate(resourceReference.uri())) {
                    return EMPTY_COMPLETION_RESULT;
                }
                McpStatelessServerFeatures.AsyncResourceSpecification resourceSpec = this.findResourceSpecification(resourceReference.uri()).orElse(null);
                if (resourceSpec != null) {
                    if (!this.uriTemplateManagerFactory.create(resourceSpec.resource().uri()).getVariableNames().contains(argumentName)) {
                        return Mono.error((Throwable)McpError.builder(-32602).message("Argument not found: " + argumentName + " in resource: " + resourceReference.uri()).build());
                    }
                } else {
                    McpStatelessServerFeatures.AsyncResourceTemplateSpecification templateSpec = this.findResourceTemplateSpecification(resourceReference.uri()).orElse(null);
                    if (templateSpec != null) {
                        if (!this.uriTemplateManagerFactory.create(templateSpec.resourceTemplate().uriTemplate()).getVariableNames().contains(argumentName)) {
                            return Mono.error((Throwable)McpError.builder(-32602).message("Argument not found: " + argumentName + " in resource template: " + resourceReference.uri()).build());
                        }
                    } else {
                        return Mono.error((Throwable)McpError.RESOURCE_NOT_FOUND.apply(resourceReference.uri()));
                    }
                }
            }
            if ((specification = this.completions.get(request.ref())) == null) {
                return Mono.error((Throwable)McpError.builder(-32602).message("AsyncCompletionSpecification not found: " + String.valueOf(request.ref())).build());
            }
            return specification.completionHandler().apply(ctx, request);
        };
    }

    private McpSchema.CompleteRequest parseCompletionParams(Object object) {
        String refType;
        Map params = (Map)object;
        Map refMap = (Map)params.get("ref");
        Map argMap = (Map)params.get("argument");
        Record ref = switch (refType = (String)refMap.get("type")) {
            case "ref/prompt" -> new McpSchema.PromptReference(refType, (String)refMap.get("name"), refMap.get("title") != null ? (String)refMap.get("title") : null);
            case "ref/resource" -> new McpSchema.ResourceReference(refType, (String)refMap.get("uri"));
            default -> throw new IllegalArgumentException("Invalid ref type: " + refType);
        };
        String argName = (String)argMap.get("name");
        String argValue = (String)argMap.get("value");
        McpSchema.CompleteRequest.CompleteArgument argument = new McpSchema.CompleteRequest.CompleteArgument(argName, argValue);
        return new McpSchema.CompleteRequest((McpSchema.CompleteReference)((Object)ref), argument);
    }

    void setProtocolVersions(List<String> protocolVersions) {
        this.protocolVersions = protocolVersions;
    }

    private static class StructuredOutputCallToolHandler
    implements BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> {
        private final BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> delegateHandler;
        private final JsonSchemaValidator jsonSchemaValidator;
        private final Map<String, Object> outputSchema;

        public StructuredOutputCallToolHandler(JsonSchemaValidator jsonSchemaValidator, Map<String, Object> outputSchema, BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> delegateHandler) {
            Assert.notNull(jsonSchemaValidator, "JsonSchemaValidator must not be null");
            Assert.notNull(delegateHandler, "Delegate call tool result handler must not be null");
            this.delegateHandler = delegateHandler;
            this.outputSchema = outputSchema;
            this.jsonSchemaValidator = jsonSchemaValidator;
        }

        @Override
        public Mono<McpSchema.CallToolResult> apply(McpTransportContext transportContext, McpSchema.CallToolRequest request) {
            return this.delegateHandler.apply(transportContext, request).map(result -> {
                if (Boolean.TRUE.equals(result.isError())) {
                    return result;
                }
                if (this.outputSchema == null) {
                    if (result.structuredContent() != null) {
                        logger.warn("Tool call with no outputSchema is not expected to have a result with structured content, but got: {}", result.structuredContent());
                    }
                    return result;
                }
                if (result.structuredContent() == null) {
                    String content = "Response missing structured content which is expected when calling tool with non-empty outputSchema";
                    logger.warn(content);
                    return McpSchema.CallToolResult.builder().content(List.of(new McpSchema.TextContent(content))).isError(true).build();
                }
                JsonSchemaValidator.ValidationResponse validation = this.jsonSchemaValidator.validate(this.outputSchema, result.structuredContent());
                if (!validation.valid()) {
                    logger.warn("Tool call result validation failed: {}", (Object)validation.errorMessage());
                    return McpSchema.CallToolResult.builder().content(List.of(new McpSchema.TextContent(validation.errorMessage()))).isError(true).build();
                }
                if (Utils.isEmpty(result.content())) {
                    return McpSchema.CallToolResult.builder().content(List.of(new McpSchema.TextContent(validation.jsonStructuredOutput()))).isError(result.isError()).structuredContent(result.structuredContent()).build();
                }
                return result;
            });
        }
    }
}

