/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.mobile.helper;

import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.mobile.constants.StringConstants;
import com.kms.katalon.core.mobile.driver.AppiumSessionCollector;
import com.kms.katalon.core.mobile.enums.Direction;
import com.kms.katalon.core.mobile.exception.MobileException;
import com.kms.katalon.core.mobile.exception.WebElementNotFoundException;
import com.kms.katalon.core.mobile.helper.DeviceScreenInfo;
import com.kms.katalon.core.mobile.helper.DeviceViewPortRect;
import com.kms.katalon.core.mobile.helper.MobileCommonHelper;
import com.kms.katalon.core.mobile.helper.StatusBarSize;
import com.kms.katalon.core.mobile.keyword.internal.MobileDriverFactory;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.util.internal.JsonUtil;
import io.appium.java_client.AppiumBy;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.ios.IOSDriver;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

public final class IOSHelper {
    private static final KeywordLogger logger = KeywordLogger.getInstance(IOSHelper.class);
    private static final List<String> IOS_SCROLLABLE_CLASSES = Arrays.asList("XCUIElementTypeScrollView", "XCUIElementTypeTable", "XCUIElementTypeCollectionView", "XCUIElementTypeWebView");

    private IOSHelper() {
    }

    public static int getStatusBarHeight(AppiumDriver driver) {
        int statusBarHeight = 0;
        IOSDriver iosDriver = (IOSDriver)driver;
        try {
            DeviceScreenInfo deviceScreenInfo = IOSHelper.getDeviceScreenInfo((AppiumDriver)iosDriver);
            StatusBarSize statusBarSize = deviceScreenInfo.getStatusBarSize();
            statusBarHeight = (int)((float)statusBarSize.getHeight() * deviceScreenInfo.getScale());
        }
        catch (Exception e) {
            logger.logInfo(StringConstants.KW_LOG_FAILED_GET_DEVICE_SCREEN_INFO + " " + e.getMessage());
            try {
                Dimension screenSize = driver.manage().window().getSize();
                DeviceViewPortRect deviceViewPortRect = IOSHelper.getDeviceViewPortRect((AppiumDriver)iosDriver);
                int scale = deviceViewPortRect.getWidth() / screenSize.getWidth();
                statusBarHeight = deviceViewPortRect.getTop() / scale;
            }
            catch (Exception ex) {
                logger.logInfo(StringConstants.KW_LOG_FAILED_GET_DEVICE_VIEWPORT_RECT + " " + ex.getMessage());
                logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_FAILED_GET_OS_STATUSBAR, "Screenshot"));
            }
        }
        return statusBarHeight;
    }

    public static float getScaleFactor(AppiumDriver driver) {
        float scaleFactor = 1.0f;
        try {
            DeviceScreenInfo deviceScreenInfo = IOSHelper.getDeviceScreenInfo(driver);
            scaleFactor = deviceScreenInfo.getScale();
        }
        catch (Exception e) {
            logger.logInfo(StringConstants.KW_LOG_FAILED_GET_DEVICE_SCREEN_INFO + " " + e.getMessage());
            try {
                Dimension screenSize = driver.manage().window().getSize();
                DeviceViewPortRect deviceViewPortRect = IOSHelper.getDeviceViewPortRect(driver);
                scaleFactor = deviceViewPortRect.getWidth() / screenSize.getWidth();
            }
            catch (Exception exception) {
                logger.logInfo(StringConstants.KW_LOG_FAILED_GET_DEVICE_VIEWPORT_RECT + " " + e.getMessage());
                logger.logInfo(StringConstants.KW_LOG_FAILED_GET_SCALE_FACTOR);
            }
        }
        return scaleFactor;
    }

    public static String getActiveAppBundleIdFromSession(AppiumDriver driver) {
        return (String)AppiumSessionCollector.getSession(driver).getProperties().get("iosBundleId");
    }

    public static WebElement scrollToTextVertical(TestObject testObject, String text, int timeoutInSeconds) throws WebElementNotFoundException {
        return IOSHelper.scrollToText(testObject, text, Direction.VERTICAL, timeoutInSeconds);
    }

    public static WebElement scrollToTextHorizontal(TestObject testObject, String text, int timeoutInSeconds) throws WebElementNotFoundException {
        return IOSHelper.scrollToText(testObject, text, Direction.HORIZONTAL, timeoutInSeconds);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WebElement scrollToText(TestObject testObject, String text, Direction direction, int timeoutInSeconds) throws WebElementNotFoundException {
        block29: {
            block28: {
                block27: {
                    endTime = System.currentTimeMillis() + (long)timeoutInSeconds * 1000L;
                    driver = (IOSDriver)MobileDriverFactory.getDriver();
                    originalImplicitWait = driver.manage().timeouts().getImplicitWaitTimeout();
                    scrollableElement = null;
                    if (testObject != null) {
                        try {
                            scrollableElement = MobileCommonHelper.findElement((AppiumDriver)driver, testObject, 0);
                        }
                        catch (Exception v0) {}
                    }
                    if (scrollableElement == null) {
                        scrollableElement = IOSHelper.findScrollableElement((AppiumDriver)driver);
                    }
                    if (scrollableElement == null) throw new WebElementNotFoundException("Scrollable element not found");
                    if (!IOSHelper.IOS_SCROLLABLE_CLASSES.contains(scrollableElement.getAttribute("type"))) {
                        throw new WebElementNotFoundException("Scrollable element not found");
                    }
                    targetElement = null;
                    try {
                        targetElement = IOSHelper.findElementContainingText((AppiumDriver)driver, text);
                        if (targetElement != null) {
                            var17_9 = targetElement;
                            return var17_9;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Exception v1) lbl-1000:
                    // 2 sources

                    {
                        remainingTime = endTime - System.currentTimeMillis();
                        if (remainingTime > 0L) break block27;
                        IOSHelper.logger.logWarning("Timeout.");
                        return null;
                    }
                }
                lastPos = 0;
                firstCell = IOSHelper.findFirstCell(scrollableElement);
                v2 = lastPos = Direction.VERTICAL.equals((Object)direction) != false ? firstCell.getLocation().getY() : firstCell.getLocation().getX();
                while (true) {
                    if ((remainingTime = endTime - System.currentTimeMillis()) <= 0L) {
                        throw new TimeoutException();
                    }
                    if (Direction.VERTICAL.equals((Object)direction)) {
                        IOSHelper.scrollUp((AppiumDriver)driver, scrollableElement);
                    } else {
                        IOSHelper.scrollLeft((AppiumDriver)driver, scrollableElement);
                    }
                    firstCell = IOSHelper.findFirstCell(scrollableElement);
                    v3 = currentPos = Direction.VERTICAL.equals((Object)direction) != false ? firstCell.getLocation().getY() : firstCell.getLocation().getX();
                    if (currentPos >= 0 && currentPos == lastPos) {
                        IOSHelper.logger.logInfo(String.format("Reached %s", new Object[]{Direction.VERTICAL.equals((Object)direction) != false ? "top" : "left"}));
                        lastCell = IOSHelper.findLastCell(scrollableElement);
                        if (Direction.VERTICAL.equals((Object)direction)) {
                            break;
                        }
                        break block28;
                    }
                    lastPos = currentPos;
                }
                v4 = lastCell.getLocation().getY();
                break block29;
            }
            v4 = lastPos = lastCell.getLocation().getX();
        }
        while (true) {
            if ((remainingTime = endTime - System.currentTimeMillis()) <= 0L) {
                throw new TimeoutException();
            }
            try {
                targetElement = IOSHelper.findElementContainingText((AppiumDriver)driver, text);
                if (targetElement != null) {
                    return targetElement;
                }
                ** GOTO lbl-1000
            }
            catch (Exception v5) {
                if (Direction.VERTICAL.equals((Object)direction)) {
                    IOSHelper.scrollDown((AppiumDriver)driver, scrollableElement);
                } else {
                    IOSHelper.scrollRight((AppiumDriver)driver, scrollableElement);
                }
                lastCell = IOSHelper.findLastCell(scrollableElement);
                v6 = currentPos = Direction.VERTICAL.equals((Object)direction) != false ? lastCell.getLocation().getY() : lastCell.getLocation().getX();
                if (currentPos == lastPos) {
                    IOSHelper.logger.logInfo(String.format("Reached %s", new Object[]{Direction.VERTICAL.equals((Object)direction) != false ? "bottom" : "right"}));
                    throw new WebElementNotFoundException(String.format("Element with text '%s' not found", new Object[]{text}));
                }
                lastPos = currentPos;
                continue;
            }
            break;
        }
        finally {
            driver.manage().timeouts().implicitlyWait(originalImplicitWait);
        }
    }

    private static WebElement findFirstCell(WebElement scrollableElement) {
        return scrollableElement.findElement(By.xpath((String)".//XCUIElementTypeCell[1]"));
    }

    private static WebElement findLastCell(WebElement scrollableElement) {
        List cells = scrollableElement.findElements(By.xpath((String)".//XCUIElementTypeCell"));
        return (WebElement)cells.get(cells.size() - 1);
    }

    private static void scrollUp(AppiumDriver driver, WebElement scrollableElement) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("element", ((RemoteWebElement)scrollableElement).getId());
        args.put("direction", "up");
        driver.executeScript("mobile: scroll", new Object[]{args});
    }

    private static void scrollDown(AppiumDriver driver, WebElement scrollableElement) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("element", ((RemoteWebElement)scrollableElement).getId());
        args.put("direction", "down");
        driver.executeScript("mobile: scroll", new Object[]{args});
    }

    private static void scrollLeft(AppiumDriver driver, WebElement scrollableElement) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("element", ((RemoteWebElement)scrollableElement).getId());
        args.put("direction", "left");
        driver.executeScript("mobile: scroll", new Object[]{args});
    }

    private static void scrollRight(AppiumDriver driver, WebElement scrollableElement) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("element", ((RemoteWebElement)scrollableElement).getId());
        args.put("direction", "right");
        driver.executeScript("mobile: scroll", new Object[]{args});
    }

    private static WebElement findScrollableElement(AppiumDriver driver) {
        for (String className : IOS_SCROLLABLE_CLASSES) {
            driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(0L));
            List elements = driver.findElements(AppiumBy.iOSClassChain((String)("**/" + className)));
            for (WebElement el : elements) {
                if (!"true".equals(el.getAttribute("enabled")) || !el.isDisplayed()) continue;
                return el;
            }
        }
        return null;
    }

    private static WebElement findElementContainingText(AppiumDriver driver, String text) {
        String escapedText = text.replace("'", "\\'");
        String predicateString = String.format("(label CONTAINS[c] '%s' OR name CONTAINS[c] '%s' OR value CONTAINS[c] '%s') AND hittable == 1", escapedText, escapedText, escapedText);
        driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(0L));
        return driver.findElement(AppiumBy.iOSNsPredicateString((String)predicateString));
    }

    private static DeviceScreenInfo getDeviceScreenInfo(AppiumDriver driver) throws MobileException {
        IOSDriver iosDriver = (IOSDriver)driver;
        Object info = iosDriver.executeScript("mobile: deviceScreenInfo", new Object[0]);
        if (info == null) {
            throw new MobileException("The raw data is null.");
        }
        DeviceScreenInfo deviceScreenInfo = (DeviceScreenInfo)JsonUtil.fromJson((String)info.toString(), DeviceScreenInfo.class);
        if (deviceScreenInfo == null) {
            throw new MobileException("Failed to parse the raw data to object.");
        }
        return deviceScreenInfo;
    }

    private static DeviceViewPortRect getDeviceViewPortRect(AppiumDriver driver) throws MobileException {
        IOSDriver iosDriver = (IOSDriver)driver;
        Object rect = iosDriver.executeScript("mobile: viewportRect", new Object[0]);
        if (rect == null) {
            throw new MobileException("The raw data is null.");
        }
        DeviceViewPortRect deviceViewPortRect = (DeviceViewPortRect)JsonUtil.fromJson((String)rect.toString(), DeviceViewPortRect.class);
        if (deviceViewPortRect == null) {
            throw new MobileException("Failed to parse the raw data to object.");
        }
        return deviceViewPortRect;
    }

    public static boolean isElementInViewport(AppiumDriver driver, WebElement element) {
        block3: {
            try {
                if (element != null) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        Dimension screenSize = driver.manage().window().getSize();
        int screenHeight = screenSize.getHeight();
        int screenWidth = screenSize.getWidth();
        Rectangle rect = element.getRect();
        int elemTop = rect.getY();
        int elemBottom = elemTop + rect.getHeight();
        int elemLeft = rect.getX();
        int elemRight = elemLeft + rect.getWidth();
        return elemTop >= 0 && elemBottom <= screenHeight && elemLeft >= 0 && elemRight <= screenWidth;
    }
}

