/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.mobile.helper;

import com.katalon.selfhealing.execution.healers.LLMTestObjectHealer;
import com.katalon.selfhealing.execution.healers.MobileStandardTestObjectMapper;
import com.katalon.selfhealing.execution.healers.SelfHealingPipeline;
import com.kms.katalon.core.aut.MobileAUT;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.enums.mobile.LocatorStrategy;
import com.kms.katalon.core.enums.mobile.MobilePlatform;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.keyword.internal.KeywordExecutionContext;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.mobile.common.FindElementsResult;
import com.kms.katalon.core.mobile.common.MobileXPathBuilder;
import com.kms.katalon.core.mobile.common.internal.SelfHealingController;
import com.kms.katalon.core.mobile.constants.StringConstants;
import com.kms.katalon.core.mobile.driver.AppiumDriverSession;
import com.kms.katalon.core.mobile.driver.AppiumSessionCollector;
import com.kms.katalon.core.mobile.helper.AndroidHelper;
import com.kms.katalon.core.mobile.helper.IOSHelper;
import com.kms.katalon.core.mobile.keyword.internal.MobileDriverFactory;
import com.kms.katalon.core.mobile.keyword.internal.MobileLocatorFinder;
import com.kms.katalon.core.mobile.keyword.internal.MobileSearchEngine;
import com.kms.katalon.core.selfhealing.TestObjectLocatorHealer;
import com.kms.katalon.core.testobject.BrokenTestObject;
import com.kms.katalon.core.testobject.MobileTestObject;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.util.ConsoleCommandBuilder;
import com.kms.katalon.core.util.internal.ProcessUtil;
import io.appium.java_client.AppiumBy;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.InputSource;
import org.openqa.selenium.interactions.Interaction;
import org.openqa.selenium.interactions.Pause;
import org.openqa.selenium.interactions.PointerInput;
import org.openqa.selenium.interactions.Sequence;

public class MobileCommonHelper {
    private static final KeywordLogger logger = KeywordLogger.getInstance(MobileCommonHelper.class);
    private static final String ATTRIBUTE_NAME_FOR_ANDROID_RESOURCE_ID = "resourceId";
    private static final String ATTRIBUTE_NAME_FOR_ANDROID_CONTENT_DESC = "name";
    public static final String PROPERTY_NAME_DEVICE_PIXEL_RATIO = "devicePixelRatio";
    public static final String PROPERTY_NAME_OS_STATUS_BAR_HEIGHT = "osStatusBarHeight";
    public static final String PROPERTY_NAME_STATUS_BAR_HEIGHT = "statusBarHeight";
    public static final String PROPERTY_NAME_SCALE_FACTOR = "scaleFactor";
    public static final String PROPERTY_NAME_IOS_BUNDLE_ID = "iosBundleId";
    public static final int DEFAULT_TAP_DURATION = 50;
    public static final int DEFAULT_SWIPE_DURATION = 500;
    public static final int DEFAULT_PINCH_DURATION = 1000;
    public static final int DEFAULT_LONG_TAP_DURATION = 2000;
    public static final double MAX_FILE_SIZE_MB = 4.5;
    public static final String[] SUPPORTED_IMAGE_TYPES = new String[]{"png", "jpg", "jpeg"};
    public static final EnumSet<LocatorStrategy> VALID_LOCATOR_STRATEGIES_FOR_AI = EnumSet.of(LocatorStrategy.ID, new LocatorStrategy[]{LocatorStrategy.NAME, LocatorStrategy.ANDROID_UI_AUTOMATOR, LocatorStrategy.XPATH, LocatorStrategy.ANDROID_VIEWTAG, LocatorStrategy.IOS_CLASS_CHAIN, LocatorStrategy.IOS_PREDICATE_STRING, LocatorStrategy.CLASS_NAME});
    public static Map<String, String> deviceModels = new HashMap<String, String>();
    public static Map<String, String> airPlaneButtonCoords;

    static {
        deviceModels.put("iPhone3,1", "iPhone 4");
        deviceModels.put("iPhone3,3", "iPhone 4");
        deviceModels.put("iPhone4,1", "iPhone 4S");
        deviceModels.put("iPhone5,1", "iPhone 5");
        deviceModels.put("iPhone5,2", "iPhone 5");
        deviceModels.put("iPhone5,3", "iPhone 5c");
        deviceModels.put("iPhone5,4", "iPhone 5c");
        deviceModels.put("iPhone6,1", "iPhone 5s");
        deviceModels.put("iPhone6,2", "iPhone 5s");
        deviceModels.put("iPhone7,1", "iPhone 6 Plus");
        deviceModels.put("iPhone7,2", "iPhone 6");
        deviceModels.put("iPad1,1", "iPad");
        deviceModels.put("iPad2,1", "iPad 2");
        deviceModels.put("iPad2,2", "iPad 2");
        deviceModels.put("iPad2,3", "iPad 2");
        deviceModels.put("iPad2,4", "iPad 2");
        deviceModels.put("iPad2,5", "iPad mini");
        deviceModels.put("iPad2,6", "iPad mini");
        deviceModels.put("iPad2,7", "iPad mini");
        deviceModels.put("iPad3,1", "iPad 3");
        deviceModels.put("iPad3,2", "iPad 3");
        deviceModels.put("iPad3,3", "iPad 3");
        deviceModels.put("iPad3,4", "iPad 4");
        deviceModels.put("iPad3,5", "iPad 4");
        deviceModels.put("iPad3,6", "iPad 4");
        deviceModels.put("iPad4,1", "iPad Air");
        deviceModels.put("iPad4,2", "iPad Air");
        deviceModels.put("iPad4,3", "iPad Air");
        deviceModels.put("iPad4,4", "iPad mini 2");
        deviceModels.put("iPad4,5", "iPad mini 2");
        deviceModels.put("iPad4,6", "iPad mini 2");
        deviceModels.put("iPad4,7", "iPad mini 3");
        deviceModels.put("iPad4,8", "iPad mini 3");
        deviceModels.put("iPad4,9", "iPad mini 3");
        deviceModels.put("iPad5,3", "iPad Air 2");
        deviceModels.put("iPad5,4", "iPad Air 2");
        airPlaneButtonCoords = new HashMap<String, String>();
        airPlaneButtonCoords.put("iPhone 5s", "40;195");
        airPlaneButtonCoords.put("iPhone 5", "40;195");
        airPlaneButtonCoords.put("iPad 2", "260;905");
        airPlaneButtonCoords.put("iPad 3", "260;905");
        airPlaneButtonCoords.put("iPad 4", "260;905");
        airPlaneButtonCoords.put("iPad Air", "260;905");
        airPlaneButtonCoords.put("iPad Air 2", "260;905");
        airPlaneButtonCoords.put("iPhone 6", "50;290");
        airPlaneButtonCoords.put("iPhone 6 Plus", "59;359");
        airPlaneButtonCoords.put("iPad mini", "265;905");
        airPlaneButtonCoords.put("iPad mini 2", "265;905");
        airPlaneButtonCoords.put("iPad mini 3", "265;905");
    }

    public static boolean canUseImageBasedTesting() {
        return RunConfiguration.canUseMobileImageBasedTesting();
    }

    public static int checkTimeout(int timeout) {
        logger.logDebug(com.kms.katalon.core.constants.StringConstants.COMM_LOG_INFO_CHECKING_TIMEOUT);
        if (timeout <= 0) {
            int defaultElementTimeout = RunConfiguration.getElementTimeoutForMobile();
            logger.logWarning(MessageFormat.format(com.kms.katalon.core.constants.StringConstants.COMM_LOG_WARNING_INVALID_TIMEOUT, timeout, defaultElementTimeout));
            return defaultElementTimeout;
        }
        return timeout;
    }

    public static void checkXAndY(Number x, Number y) {
        logger.logDebug(StringConstants.COMM_LOG_INFO_CHECKING_X);
        if (x == null) {
            throw new StepFailedException(MessageFormat.format(StringConstants.KW_MSG_FAILED_PARAM_X_CANNOT_BE_NULL, "x"));
        }
        logger.logDebug(StringConstants.COMM_LOG_INFO_CHECKING_Y);
        if (y == null) {
            throw new StepFailedException(MessageFormat.format(StringConstants.KW_MSG_FAILED_PARAM_X_CANNOT_BE_NULL, "y"));
        }
    }

    public static void doubleTap(AppiumDriver driver, Point point) {
        if (driver instanceof AndroidDriver) {
            PointerInput finger = new PointerInput(PointerInput.Kind.TOUCH, "finger");
            Sequence doubleTap = new Sequence((InputSource)finger, 0);
            doubleTap.addAction(finger.createPointerMove(Duration.ZERO, PointerInput.Origin.viewport(), point));
            doubleTap.addAction(finger.createPointerDown(PointerInput.MouseButton.LEFT.asArg()));
            doubleTap.addAction(finger.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
            doubleTap.addAction((Interaction)new Pause((InputSource)finger, Duration.ofMillis(100L)));
            doubleTap.addAction(finger.createPointerDown(PointerInput.MouseButton.LEFT.asArg()));
            doubleTap.addAction(finger.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
            driver.perform(List.of(doubleTap));
        } else if (driver instanceof IOSDriver) {
            HashMap<String, Integer> args = new HashMap<String, Integer>();
            args.put("x", point.x);
            args.put("y", point.y);
            driver.executeScript("mobile: doubleTap", new Object[]{args});
        }
    }

    public static WebElement findElement(AppiumDriver driver, TestObject testObject, int timeOut) throws Exception {
        WebElement cachedWebElement = testObject.getCachedWebElement();
        if (cachedWebElement != null) {
            logger.logDebug("Using cached element");
            return cachedWebElement;
        }
        logger.logDebug("Finding element from Test Object's properties");
        List<WebElement> elements = MobileCommonHelper.findElements(driver, testObject, timeOut);
        if (elements != null && elements.size() > 0) {
            return elements.get(0);
        }
        return null;
    }

    public static WebElement findElementByIosClassChain(IOSDriver iosDriver, String type, String name) {
        String locator = "**/%s[`name == '%s'`]";
        return iosDriver.findElement(AppiumBy.iOSClassChain((String)String.format(locator, type, name)));
    }

    public static WebElement findElementByIosClassChain(IOSDriver iosDriver, String type, String name, String label) {
        String locator = "**/%s[`name == '%s' OR label = '%s'`]";
        return iosDriver.findElement(AppiumBy.iOSClassChain((String)String.format(locator, type, name, label)));
    }

    public static List<WebElement> findElements(AppiumDriver driver, TestObject testObject, int timeout) throws Exception {
        if (!(testObject instanceof MobileTestObject)) {
            logger.logWarning("The input TestObject is not a MobileTestObject. Self-Healing is not supported");
            driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(timeout));
            MobileSearchEngine searchEngine = new MobileSearchEngine(driver, testObject);
            return searchEngine.findWebElements(false);
        }
        MobileTestObject mobileTestObject = (MobileTestObject)testObject;
        if (mobileTestObject.getLocatorStrategy() == null) {
            mobileTestObject.setLocatorStrategy(LocatorStrategy.ATTRIBUTES);
        }
        if (mobileTestObject.getLocatorCollection().isEmpty()) {
            List locatorStrategies = LocatorStrategy.getLocatorStrategies((MobilePlatform)mobileTestObject.getPlatform());
            locatorStrategies.forEach(locatorStrategy -> {
                String locator = "";
                locator = MobileLocatorFinder.findLocator((TestObject)mobileTestObject, locatorStrategy);
                mobileTestObject.setLocatorValue(locatorStrategy, locator);
            });
        }
        timeout = MobileCommonHelper.checkTimeout(timeout);
        boolean shouldApplySelfHealing = RunConfiguration.shouldApplySelfHealingForMobile();
        if (shouldApplySelfHealing) {
            return MobileCommonHelper.findElementsWithSelfHealing(driver, mobileTestObject, timeout);
        }
        List<WebElement> foundElements = new ArrayList<WebElement>();
        FindElementsResult findResult = MobileCommonHelper.findElementsByDefaultLocator(driver, (TestObject)mobileTestObject, timeout);
        if (findResult != null) {
            foundElements = findResult.getElements();
        }
        return foundElements;
    }

    public static FindElementsResult findElementsByDefaultLocator(AppiumDriver driver, TestObject testObject, int timeout) throws Exception {
        return MobileCommonHelper.findElementsByLocatorStrategy(driver, testObject, timeout, ((MobileTestObject)testObject).getLocatorStrategy());
    }

    public static FindElementsResult findElementsByLocatorStrategy(AppiumDriver driver, TestObject testObject, int timeout, LocatorStrategy locatorStrategy) throws Exception {
        long endTime = System.currentTimeMillis() + (long)timeout * 1000L;
        Duration defaultImplicitlyWait = driver.manage().timeouts().getImplicitWaitTimeout();
        try {
            MobileSearchEngine searchEngine = new MobileSearchEngine(driver, testObject);
            List<WebElement> webElements = new ArrayList<WebElement>();
            while (webElements.size() == 0) {
                driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(0L));
                webElements = searchEngine.findElementsByMobileLocator(locatorStrategy);
                if (System.currentTimeMillis() >= endTime) break;
                if (webElements != null && !webElements.isEmpty()) continue;
                Thread.sleep(200L);
            }
            MobileTestObject mobileTestObject = (MobileTestObject)testObject;
            String locator = (String)mobileTestObject.getLocatorCollection().get(locatorStrategy);
            FindElementsResult findElementsResult = FindElementsResult.from(webElements, locator, locatorStrategy);
            return findElementsResult;
        }
        finally {
            driver.manage().timeouts().implicitlyWait(defaultImplicitlyWait);
        }
    }

    private static List<WebElement> findElementsWithSelfHealing(AppiumDriver driver, MobileTestObject testObject, int timeout) throws Exception {
        boolean isSelfHealingEnabled;
        Exception defaultException = null;
        try {
            List<Object> foundElements = new ArrayList();
            FindElementsResult findResult = MobileCommonHelper.findElementsByDefaultLocator(driver, (TestObject)testObject, timeout);
            if (findResult != null) {
                foundElements = findResult.getElements();
            }
            if (foundElements != null && !foundElements.isEmpty()) {
                return foundElements;
            }
        }
        catch (Exception exception) {
            defaultException = exception;
        }
        if (defaultException != null && !(defaultException instanceof NoSuchElementException)) {
            throw defaultException;
        }
        SelfHealingPipeline.SelfHealingParams selfHealingParams = new SelfHealingPipeline.SelfHealingParams();
        boolean isMobilePlatform = KeywordExecutionContext.isRunningMobile();
        String runningKeyword = KeywordExecutionContext.getRunningKeyword();
        List excludedKeywords = RunConfiguration.getExcludedMobileKeywordsFromSelfHealing();
        boolean bl = isSelfHealingEnabled = isMobilePlatform && !excludedKeywords.contains(runningKeyword) && RunConfiguration.shouldApplySelfHealing() != false;
        if (!isSelfHealingEnabled) {
            return null;
        }
        selfHealingParams.useBasicSelfHealing = true;
        selfHealingParams.useAISelfHealing = RunConfiguration.getMobileAISelfHealingEnabled();
        selfHealingParams.aiSelfHealingInputSources = RunConfiguration.getMobileAISelfHealingInputSources();
        selfHealingParams.currentAction = runningKeyword;
        selfHealingParams.aut = new MobileAUT((WebDriver)driver);
        selfHealingParams.testObject = testObject;
        selfHealingParams.standardTestObjectMapper = originalTestObject -> {
            if (originalTestObject == null) {
                throw new IllegalArgumentException("TestObject cannot be null");
            }
            if (!(originalTestObject instanceof MobileTestObject)) {
                throw new IllegalArgumentException("Expected MobileTestObject but got " + originalTestObject.getClass().getName());
            }
            return new MobileStandardTestObjectMapper().map((TestObject)((MobileTestObject)originalTestObject));
        };
        selfHealingParams.basicSelfHealer = tempTestObject -> {
            List<WebElement> foundElements = MobileCommonHelper.findElementsWithAlternativeLocators(driver, (TestObject)testObject, 0);
            return foundElements;
        };
        selfHealingParams.elementsFinder = foundLocator -> {
            MobileTestObject tempTestObject = new MobileTestObject("self-healing-temp-test-object-id");
            LocatorStrategy locatorType = LocatorStrategy.valueOf((String)foundLocator.type);
            tempTestObject.setLocatorStrategy(locatorType);
            tempTestObject.setLocatorValue(locatorType, foundLocator.value);
            FindElementsResult result = MobileCommonHelper.findElementsByDefaultLocator(driver, (TestObject)tempTestObject, 0);
            return result.getElements();
        };
        SelfHealingPipeline selfHealingPipeline = new SelfHealingPipeline();
        selfHealingPipeline.registerPhase(context -> {
            List foundElements = ((SelfHealingPipeline.SelfHealingContext)context.data).results.foundElements;
            TestObjectLocatorHealer.FoundLocator foundLocator = ((SelfHealingPipeline.SelfHealingContext)context.data).results.foundLocator;
            if (foundElements == null || foundElements.isEmpty()) {
                return;
            }
            WebElement firstElement = (WebElement)foundElements.get(0);
            FindElementsResult healingResult = FindElementsResult.from(firstElement, foundLocator.value, LocatorStrategy.valueOf((String)foundLocator.type), null);
            MobileCommonHelper.registerHealingObject(healingResult, (TestObject)testObject);
        });
        LLMTestObjectHealer.LLMCustomPrompts customPrompts = new LLMTestObjectHealer.LLMCustomPrompts();
        List prioritizedLocatorStrategies = RunConfiguration.getPrioritizedLocatorStrategies((MobilePlatform)testObject.getPlatform());
        List enabledPrioritizedLocatorStrategies = prioritizedLocatorStrategies.stream().filter(entry -> (Boolean)entry.getRight() != false && VALID_LOCATOR_STRATEGIES_FOR_AI.contains(entry.getLeft())).map(entry -> (LocatorStrategy)entry.getLeft()).collect(Collectors.toList());
        customPrompts.outputRules = MessageFormat.format("- Prefer the locator follow this order: {0}\n", StringUtils.join(enabledPrioritizedLocatorStrategies, (String)", "));
        customPrompts.locatorTypes = "\"" + StringUtils.join(VALID_LOCATOR_STRATEGIES_FOR_AI, (String)"\" | \"") + "\"";
        selfHealingParams.customPrompts = customPrompts;
        SelfHealingPipeline.SelfHealingContext context2 = selfHealingPipeline.execute(selfHealingParams);
        return context2.results.foundElements;
    }

    private static List<WebElement> findElementsWithAlternativeLocators(AppiumDriver driver, TestObject testObject, int timeout) throws Exception {
        SelfHealingController.setLogger(logger);
        try {
            boolean isMobilePlatform = KeywordExecutionContext.isRunningMobile();
            String runningKeyword = KeywordExecutionContext.getRunningKeyword();
            List excludeKeywords = RunConfiguration.getExcludedMobileKeywordsFromSelfHealing();
            if (!isMobilePlatform || excludeKeywords.contains(runningKeyword)) {
                return Collections.emptyList();
            }
            MobileTestObject mto = (MobileTestObject)testObject;
            SelfHealingController.logWarning(MessageFormat.format(StringConstants.KW_LOG_INFO_DEFAULT_LOCATOR_FAILED_TRY_SELF_HEALING, testObject.getObjectId(), mto.getLocatorStrategy(), mto.getLocatorCollection().get(mto.getLocatorStrategy())));
            FindElementsResult substituteFindElementsResult = null;
            List<TestObject> healingCandidates = SelfHealingController.findHealedTestObjects(testObject);
            for (TestObject healingCandidate : healingCandidates) {
                if (healingCandidate == null) continue;
                MobileTestObject mobileTestObject = (MobileTestObject)healingCandidate;
                LocatorStrategy locatorStrategy = mobileTestObject.getLocatorStrategy();
                String locator = (String)mobileTestObject.getLocatorCollection().get(locatorStrategy);
                if (StringUtils.isEmpty((CharSequence)locator)) {
                    SelfHealingController.logWarning(MessageFormat.format(StringConstants.KW_LOG_INFO_EMPTY_LOCATOR, locatorStrategy.getName()));
                    continue;
                }
                SelfHealingController.logInfo(MessageFormat.format(StringConstants.KW_LOG_INFO_FINDING_ELEMENT_WITH_LOCATOR, locatorStrategy.getName(), locator));
                List<Object> foundElements = new ArrayList();
                FindElementsResult findResult = MobileCommonHelper.findElementsByDefaultLocator(driver, (TestObject)mobileTestObject, 0);
                if (findResult != null) {
                    foundElements = findResult.getElements();
                }
                if (foundElements == null || foundElements.isEmpty()) continue;
                SelfHealingController.logInfo(MessageFormat.format(StringConstants.KW_LOG_INFO_FOUND_ELEMENT, foundElements.size(), locatorStrategy.getName(), locator));
                if (foundElements.size() > 1) {
                    if (substituteFindElementsResult == null) {
                        substituteFindElementsResult = findResult;
                    }
                    SelfHealingController.logWarning(MessageFormat.format(StringConstants.KW_LOG_INFO_FOUND_MULTI_ELEMENTS, locatorStrategy.getName(), locator));
                    continue;
                }
                MobileCommonHelper.registerHealingObject(findResult, testObject);
                return foundElements;
            }
            if (substituteFindElementsResult != null) {
                MobileCommonHelper.registerHealingObject(substituteFindElementsResult, testObject);
                return substituteFindElementsResult.getElements();
            }
            List prioritizedLocatorStrategies = RunConfiguration.getPrioritizedLocatorStrategies((MobilePlatform)((MobileTestObject)testObject).getPlatform());
            LocatorStrategy locatorStrategy = ((MobileTestObject)testObject).getLocatorStrategy();
            for (Pair prioritizedLocatorStrategy : prioritizedLocatorStrategies) {
                LocatorStrategy currentLocatorStrategy;
                boolean isEnabled = (Boolean)prioritizedLocatorStrategy.getRight();
                if (!isEnabled || (currentLocatorStrategy = (LocatorStrategy)prioritizedLocatorStrategy.getLeft()) == locatorStrategy) continue;
                try {
                    String proposedLocator = (String)((MobileTestObject)testObject).getLocatorCollection().get(currentLocatorStrategy);
                    if (StringUtils.isEmpty((CharSequence)proposedLocator)) {
                        SelfHealingController.logWarning(MessageFormat.format(StringConstants.KW_LOG_INFO_EMPTY_LOCATOR, currentLocatorStrategy.getName()));
                        continue;
                    }
                    SelfHealingController.logInfo(MessageFormat.format(StringConstants.KW_LOG_INFO_FINDING_ELEMENT_WITH_LOCATOR, currentLocatorStrategy.getName(), proposedLocator));
                    List<Object> foundElements = new ArrayList();
                    FindElementsResult findResult = MobileCommonHelper.findElementsByLocatorStrategy(driver, testObject, 0, currentLocatorStrategy);
                    if (findResult != null) {
                        foundElements = findResult.getElements();
                    }
                    if (findResult == null || foundElements.isEmpty()) continue;
                    SelfHealingController.logInfo(MessageFormat.format(StringConstants.KW_LOG_INFO_FOUND_ELEMENT, foundElements.size(), currentLocatorStrategy.getName(), proposedLocator));
                    if (foundElements.size() > 1) {
                        if (substituteFindElementsResult == null) {
                            substituteFindElementsResult = findResult;
                        }
                        SelfHealingController.logWarning(MessageFormat.format(StringConstants.KW_LOG_INFO_FOUND_MULTI_ELEMENTS, currentLocatorStrategy.getName(), proposedLocator));
                        continue;
                    }
                    MobileCommonHelper.registerHealingObject(findResult, testObject);
                    return foundElements;
                }
                catch (Exception exception) {
                    SelfHealingController.logWarning(exception.getMessage(), exception);
                }
            }
            if (substituteFindElementsResult != null) {
                MobileCommonHelper.registerHealingObject(substituteFindElementsResult, testObject);
                return substituteFindElementsResult.getElements();
            }
        }
        catch (Exception exception) {
            SelfHealingController.logWarning(exception.getMessage(), exception);
        }
        return Collections.emptyList();
    }

    public static long getAndroidPackageSize(String deviceId, String appId, String adbFolder) {
        try {
            String command = MessageFormat.format("adb -s {0} shell \"stat -c %s $(pm path {1} | grep base.apk | cut -d : -f 2)\"", deviceId, appId);
            List packageSize = ConsoleCommandBuilder.create((String)command).path(adbFolder).execSync();
            return Long.valueOf((String)packageSize.get(0));
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static String getAttributeLocatorValue(TestObject testObject) {
        if (testObject == null || testObject.getProperties().isEmpty()) {
            return null;
        }
        MobileXPathBuilder xpathBuilder = new MobileXPathBuilder(testObject.getActiveProperties());
        return xpathBuilder.build();
    }

    public static String getAttributeValue(WebElement element, String attributeName) {
        switch (attributeName.toString()) {
            case "height": {
                return String.valueOf(element.getSize().height);
            }
            case "width": {
                return String.valueOf(element.getSize().width);
            }
            case "x": {
                return String.valueOf(element.getLocation().x);
            }
            case "y": {
                return String.valueOf(element.getLocation().y);
            }
            case "resource-id": {
                if (MobileDriverFactory.getDriver() instanceof AndroidDriver) {
                    return element.getAttribute(ATTRIBUTE_NAME_FOR_ANDROID_RESOURCE_ID);
                }
                return null;
            }
            case "content-desc": {
                if (MobileDriverFactory.getDriver() instanceof AndroidDriver) {
                    return element.getAttribute(ATTRIBUTE_NAME_FOR_ANDROID_CONTENT_DESC);
                }
                return null;
            }
        }
        try {
            return element.getAttribute(attributeName);
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public static String getBundleId(String packagePath, String aaptFolder) {
        return MobileCommonHelper.grepBundleInfo(packagePath, aaptFolder, "package: name='(.*?)'");
    }

    public static String getBundleVersion(String packagePath, String aaptFolder) {
        return MobileCommonHelper.grepBundleInfo(packagePath, aaptFolder, "versionName='(.*?)'");
    }

    public static String getInstalledAppVersion(String deviceId, String appId, String adbFolder) {
        return MobileCommonHelper.grepInstalledAppInfo(deviceId, appId, adbFolder, "versionName=(.*?)(\\s|$)");
    }

    public static int getMajorVersion(String version) {
        return Integer.parseInt(version.split("\\.")[0]);
    }

    public static float getScaleFactor(AppiumDriver driver) {
        float scaleFactor = 1.0f;
        if (driver instanceof IOSDriver) {
            scaleFactor = IOSHelper.getScaleFactor(driver);
        }
        return scaleFactor;
    }

    public static int getStatusBarHeight(AppiumDriver driver) {
        int statusBar = 0;
        if (driver instanceof AndroidDriver) {
            statusBar = AndroidHelper.getStatusBarHeight(driver);
        }
        if (driver instanceof IOSDriver) {
            statusBar = IOSHelper.getStatusBarHeight(driver);
        }
        return statusBar;
    }

    public static String grepBundleInfo(String packagePath, String aaptFolder, String infoPattern) {
        try {
            String command = MessageFormat.format("aapt dump badging \"{0}\"", packagePath);
            List infoLines = ConsoleCommandBuilder.create((String)command).path(aaptFolder).execSync();
            Pattern idPattern = Pattern.compile(infoPattern);
            for (String lineI : infoLines) {
                Matcher idMatcher = idPattern.matcher(lineI);
                if (!idMatcher.find()) continue;
                return idMatcher.group(1);
            }
            return null;
        }
        catch (IOException | InterruptedException exception) {
            return null;
        }
    }

    public static String grepInstalledAppInfo(String deviceId, String appId, String adbFolder, String infoPattern) {
        try {
            String command = MessageFormat.format("adb -s {0} shell dumpsys package \"{1}\"", deviceId, appId);
            List infoLines = ConsoleCommandBuilder.create((String)command).path(adbFolder).execSync();
            Pattern idPattern = Pattern.compile(infoPattern);
            for (String lineI : infoLines) {
                Matcher idMatcher = idPattern.matcher(lineI);
                if (!idMatcher.find()) continue;
                return idMatcher.group(1);
            }
            return null;
        }
        catch (IOException | InterruptedException exception) {
            return null;
        }
    }

    public static void holdAndSwipe(AppiumDriver driver, Point start, Point end, Duration duration) {
        Sequence swipe = MobileCommonHelper.holdAndSwipeSequence("finger", start, end, duration);
        driver.perform(List.of(swipe));
    }

    public static Sequence holdAndSwipeSequence(String fingerId, Point start, Point end, Duration duration) {
        PointerInput finger = new PointerInput(PointerInput.Kind.TOUCH, fingerId);
        Sequence swipe = new Sequence((InputSource)finger, 1);
        swipe.addAction(finger.createPointerMove(Duration.ofMillis(0L), PointerInput.Origin.viewport(), start));
        swipe.addAction(finger.createPointerDown(PointerInput.MouseButton.LEFT.asArg()));
        swipe.addAction((Interaction)new Pause((InputSource)finger, Duration.ofMillis(2000L)));
        swipe.addAction(finger.createPointerMove(duration, PointerInput.Origin.viewport(), end));
        swipe.addAction(finger.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
        return swipe;
    }

    public static boolean inAndroidAppInstalled(String deviceId, String appId, String adbFolder) throws IOException, InterruptedException {
        List result = ConsoleCommandBuilder.create((String)MessageFormat.format("adb -s \"{0}\" shell pm path \"{1}\"", deviceId, appId)).path(adbFolder).execSync();
        return ProcessUtil.includes((List)result, (String)appId);
    }

    public static void injectImage(AppiumDriver driver, String imageFilePath) throws StepFailedException {
        File file = new File(imageFilePath);
        if (!file.exists()) {
            throw new StepFailedException(MessageFormat.format(StringConstants.KW_MSG_FILE_NOT_FOUND, imageFilePath));
        }
        long fileSizeInByte = file.length();
        if ((double)fileSizeInByte > 4718592.0) {
            throw new StepFailedException(MessageFormat.format(StringConstants.KW_MSG_FILE_SIZE_IS_EXCEEDING, 4.5));
        }
        if (!MobileCommonHelper.isSupportedFileType(file)) {
            throw new StepFailedException(StringConstants.KW_MSG_FILE_TYPE_IS_NOT_SUPPORTED);
        }
        try {
            byte[] byteArray = Files.readAllBytes(file.toPath());
            String encodedImage = Base64.getEncoder().encodeToString(byteArray);
            driver.executeScript("image-injection=" + encodedImage, new Object[0]);
        }
        catch (Exception e) {
            logger.logWarning(e.getMessage());
            throw new StepFailedException(StringConstants.KW_LOG_FAILED_INJECT_IMAGE);
        }
    }

    public static boolean isIPad(String deviceModel) {
        return deviceModel.contains("iPad");
    }

    public static boolean isIPhoneXOrLater(String deviceModel) {
        if (!deviceModel.contains("iPhone")) {
            return false;
        }
        String[] versionNumbers = deviceModel.replace("iPhone", "").split(",");
        int majorVersion = Integer.parseInt(versionNumbers[0]);
        int minorVersion = Integer.parseInt(versionNumbers[1]);
        return majorVersion >= 11 || majorVersion == 10 && (minorVersion == 3 || minorVersion == 6);
    }

    public static boolean isSameApp(String packagePath, String deviceId, String appId, String adbFolder, String aaptFolder) {
        return MobileCommonHelper.isSameVersion(packagePath, deviceId, appId, adbFolder, aaptFolder) && MobileCommonHelper.isSameSize(packagePath, deviceId, appId, adbFolder);
    }

    public static boolean isSameSize(String packagePath, String deviceId, String appId, String adbFolder) {
        long installedPackageSize = MobileCommonHelper.getAndroidPackageSize(deviceId, appId, adbFolder);
        try {
            return Files.size(new File(packagePath).toPath()) == installedPackageSize;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isSameVersion(String packagePath, String deviceId, String appId, String adbFolder, String aaptFolder) {
        String bundleVersion = MobileCommonHelper.getBundleVersion(packagePath, aaptFolder);
        String installedAppVersion = MobileCommonHelper.getInstalledAppVersion(deviceId, appId, adbFolder);
        return StringUtils.equals((CharSequence)bundleVersion, (CharSequence)installedAppVersion);
    }

    private static boolean isSupportedFileType(File file) {
        String fileName = file.getName();
        String fileExtension = fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase();
        return Arrays.asList(SUPPORTED_IMAGE_TYPES).contains(fileExtension);
    }

    public static void pinch(AppiumDriver driver, Point start1, Point start2, Point end1, Point end2) {
        MobileCommonHelper.pinch(driver, start1, start2, end1, end2, Duration.ofMillis(1000L));
    }

    public static void pinch(AppiumDriver driver, Point start1, Point start2, Point end1, Point end2, Duration duration) {
        Sequence swipe1 = MobileCommonHelper.swipeSequence("finger1", start1, end1, duration);
        Sequence swipe2 = MobileCommonHelper.swipeSequence("finger2", start2, end2, duration);
        driver.perform(List.of(swipe1, swipe2));
    }

    private static void registerHealingObject(FindElementsResult findResult, TestObject testObject) {
        if (testObject == null || StringUtils.isEmpty((CharSequence)testObject.getObjectId())) {
            return;
        }
        BrokenTestObject brokenTestObject = SelfHealingController.registerBrokenTestObject(findResult, testObject);
        LocatorStrategy brokenLocatorStrategy = LocatorStrategy.valueOf((String)brokenTestObject.getBrokenLocatorMethod());
        LocatorStrategy proposedLocatorStrategy = LocatorStrategy.valueOf((String)brokenTestObject.getProposedLocatorMethod());
        SelfHealingController.logWarning(MessageFormat.format(StringConstants.KW_LOG_INFO_PROPOSE_ALTERNATE_LOCATOR, testObject.getObjectId(), brokenLocatorStrategy.getName(), brokenTestObject.getBrokenLocator(), proposedLocatorStrategy.getName(), brokenTestObject.getProposedLocator()));
        KeywordExecutionContext.setHasHealedSomeObjects((boolean)true);
    }

    public static void setCommonAppiumSessionProperties(AppiumDriver driver) {
        AppiumDriverSession session = AppiumSessionCollector.getSession(driver);
        session.getProperties().put(PROPERTY_NAME_STATUS_BAR_HEIGHT, MobileCommonHelper.getStatusBarHeight(driver));
        session.getProperties().put(PROPERTY_NAME_SCALE_FACTOR, Float.valueOf(MobileCommonHelper.getScaleFactor(driver)));
    }

    public static void swipe(AppiumDriver driver, Point start, Point end) {
        MobileCommonHelper.swipe(driver, start, end, Duration.ofMillis(500L));
    }

    public static void swipe(AppiumDriver driver, Point start, Point end, Duration duration) {
        Sequence swipe = MobileCommonHelper.swipeSequence("finger", start, end, duration);
        driver.perform(List.of(swipe));
    }

    public static Sequence swipeSequence(String fingerId, Point start, Point end, Duration duration) {
        PointerInput finger = new PointerInput(PointerInput.Kind.TOUCH, fingerId);
        Sequence swipe = new Sequence((InputSource)finger, 1);
        swipe.addAction(finger.createPointerMove(Duration.ofMillis(0L), PointerInput.Origin.viewport(), start));
        swipe.addAction(finger.createPointerDown(PointerInput.MouseButton.LEFT.asArg()));
        swipe.addAction((Interaction)new Pause((InputSource)finger, Duration.ofMillis(50L)));
        swipe.addAction(finger.createPointerMove(duration, PointerInput.Origin.viewport(), end));
        swipe.addAction(finger.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
        return swipe;
    }

    public static void tap(AppiumDriver driver, Point point) {
        if (driver instanceof AndroidDriver) {
            PointerInput finger = new PointerInput(PointerInput.Kind.TOUCH, "finger");
            Sequence tap = new Sequence((InputSource)finger, 0);
            tap.addAction(finger.createPointerMove(Duration.ofMillis(0L), PointerInput.Origin.viewport(), point));
            tap.addAction(finger.createPointerDown(PointerInput.MouseButton.LEFT.asArg()));
            tap.addAction(finger.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
            driver.perform(List.of(tap));
        } else if (driver instanceof IOSDriver) {
            HashMap<String, Integer> args = new HashMap<String, Integer>();
            args.put("x", point.x);
            args.put("y", point.y);
            driver.executeScript("mobile: tap", new Object[]{args});
        }
    }

    public static void touchAndHold(AppiumDriver driver, Point point, Duration duration) {
        if (driver instanceof AndroidDriver) {
            PointerInput finger = new PointerInput(PointerInput.Kind.TOUCH, "finger");
            Sequence tap = new Sequence((InputSource)finger, 0);
            tap.addAction(finger.createPointerMove(Duration.ofMillis(0L), PointerInput.Origin.viewport(), point));
            tap.addAction(finger.createPointerDown(PointerInput.MouseButton.LEFT.asArg()));
            tap.addAction((Interaction)new Pause((InputSource)finger, duration));
            tap.addAction(finger.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
            driver.perform(List.of(tap));
        } else if (driver instanceof IOSDriver) {
            HashMap<String, Number> args = new HashMap<String, Number>();
            args.put("duration", duration.getSeconds());
            args.put("x", point.x);
            args.put("y", point.y);
            driver.executeScript("mobile: touchAndHold", new Object[]{args});
        }
    }

    public static void uninstallAndroidApp(String deviceId, String appId, String adbFolder) throws IOException, InterruptedException {
        ConsoleCommandBuilder.create((String)MessageFormat.format("adb -s \"{0}\" uninstall \"{1}\"", deviceId, appId)).path(adbFolder).execSync();
    }
}

