/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ClassNodeWrapper;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.GenericsType;

public class GenericsTypeWrapper
extends ASTNodeWrapper {
    protected ClassNodeWrapper[] upperBounds;
    protected ClassNodeWrapper lowerBound;
    protected ClassNodeWrapper type;
    protected String name;

    public GenericsTypeWrapper(GenericsType genericsType, ASTNodeWrapper parentNodeWrapper) {
        super((ASTNode)genericsType, parentNodeWrapper);
        this.name = genericsType.getName();
        if (genericsType.getUpperBounds() != null) {
            this.upperBounds = new ClassNodeWrapper[genericsType.getUpperBounds().length];
            int index = 0;
            while (index < this.upperBounds.length) {
                this.upperBounds[index] = ClassNodeWrapper.getClassWrapper(genericsType.getUpperBounds()[index], this);
                ++index;
            }
        }
        if (genericsType.getLowerBound() != null) {
            this.lowerBound = ClassNodeWrapper.getClassWrapper(genericsType.getLowerBound(), this);
        }
        this.type = ClassNodeWrapper.getClassWrapper(genericsType.getType(), this);
    }

    public GenericsTypeWrapper(GenericsTypeWrapper genericsTypeWrapper, ASTNodeWrapper parentNodeWrapper) {
        super(genericsTypeWrapper, parentNodeWrapper);
        this.name = genericsTypeWrapper.getName();
        if (genericsTypeWrapper.getUpperBounds() != null) {
            this.upperBounds = new ClassNodeWrapper[genericsTypeWrapper.getUpperBounds().length];
            int index = 0;
            while (index < this.upperBounds.length) {
                this.upperBounds[index] = new ClassNodeWrapper(genericsTypeWrapper.getUpperBounds()[index], (ASTNodeWrapper)this);
                ++index;
            }
        }
        if (genericsTypeWrapper.getLowerBound() != null) {
            this.lowerBound = new ClassNodeWrapper(genericsTypeWrapper.getLowerBound(), (ASTNodeWrapper)this);
        }
        this.type = new ClassNodeWrapper(genericsTypeWrapper.getType(), (ASTNodeWrapper)this);
    }

    @Override
    public String getText() {
        return "";
    }

    @Override
    public boolean hasAstChildren() {
        return true;
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        return Collections.emptyList();
    }

    public ClassNodeWrapper[] getUpperBounds() {
        return this.upperBounds;
    }

    public ClassNodeWrapper getLowerBound() {
        return this.lowerBound;
    }

    public ClassNodeWrapper getType() {
        return this.type;
    }

    public void setType(ClassNodeWrapper type) {
        if (type == null) {
            return;
        }
        type.setParent(this);
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public GenericsTypeWrapper clone() {
        return new GenericsTypeWrapper(this, this.getParent());
    }
}

