/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.selenium.driver;

import com.kms.katalon.selenium.constant.SeleniumConstants;
import com.kms.katalon.selenium.driver.IDelayableDriver;
import com.kms.katalon.selenium.driver.ISmartExtensionWebDriver;
import com.kms.katalon.selenium.driver.SmartExtensionState;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.BiDiException;
import org.openqa.selenium.bidi.Connection;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;

public class CRemoteWebDriver
extends RemoteWebDriver
implements IDelayableDriver,
HasBiDi,
ISmartExtensionWebDriver {
    private static final Logger LOG = Logger.getLogger(CRemoteWebDriver.class.getName());
    private int actionDelayInMilliseconds;
    private Optional<BiDi> biDi = Optional.empty();
    private Optional<URI> biDiUri = Optional.empty();
    private final SmartExtensionState smartExtensionState;

    public CRemoteWebDriver(URL remoteAddress, Capabilities capabilities, int actionDelay) {
        super(remoteAddress, capabilities);
        this.setActionDelayInMilliseconds(actionDelay);
        this.initializeBiDi(this.getCapabilities());
        this.smartExtensionState = new SmartExtensionState();
    }

    public CRemoteWebDriver(CommandExecutor executor, Capabilities capabilities, int actionDelay) {
        super(executor, capabilities);
        this.setActionDelayInMilliseconds(actionDelay);
        this.initializeBiDi(this.getCapabilities());
        this.smartExtensionState = new SmartExtensionState();
    }

    private void setActionDelayInMilliseconds(int actionDelay) {
        this.actionDelayInMilliseconds = actionDelay;
    }

    private void initializeBiDi(Capabilities capabilities) {
        Optional<String> webSocketUrl = Optional.ofNullable((String)capabilities.getCapability("webSocketUrl"));
        this.biDiUri = webSocketUrl.map(uri -> {
            try {
                return new URI((String)uri);
            }
            catch (URISyntaxException e) {
                LOG.warning("URISyntaxException while initializeBiDi" + e.getMessage());
                return null;
            }
        });
        this.biDi = this.openBiDiConnection(this.biDiUri);
    }

    private Optional<BiDi> openBiDiConnection(Optional<URI> biDiUri) {
        if (biDiUri.isEmpty()) {
            return Optional.empty();
        }
        URI wsUri = biDiUri.orElseThrow(() -> new BiDiException("Check if this browser version supports BiDi and if the 'webSocketUrl: true' capability is set."));
        HttpClient.Factory clientFactory = HttpClient.Factory.createDefault();
        ClientConfig wsConfig = ClientConfig.defaultConfig().readTimeout(Duration.ofSeconds(SeleniumConstants.DEFAULT_READ_TIMEOUT_SECONDS)).baseUri(wsUri);
        HttpClient wsClient = clientFactory.createClient(wsConfig);
        Connection biDiConnection = new Connection(wsClient, wsUri.toString());
        return Optional.of(new BiDi(biDiConnection));
    }

    protected Response execute(String driverCommand, Map<String, ?> parameters) {
        return super.execute(driverCommand, parameters);
    }

    @Override
    public int getActionDelay() {
        return this.actionDelayInMilliseconds;
    }

    public Optional<BiDi> maybeGetBiDi() {
        return this.biDi;
    }

    @Override
    public SmartExtensionState getSmartExtensionState() {
        return this.smartExtensionState;
    }
}

