/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.selenium.filter;

import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumAcceptEncodingFilter
implements Filter {
    private static String ACCEPT_ENCODING_HEADER_NAME = "Accept-Encoding";
    private static Logger logger = LoggerFactory.getLogger(SeleniumAcceptEncodingFilter.class);

    public HttpHandler apply(HttpHandler next) {
        return req -> {
            try {
                String existingAcceptEncoding = req.getHeader(ACCEPT_ENCODING_HEADER_NAME);
                if (StringUtils.isEmpty((CharSequence)existingAcceptEncoding)) {
                    req.addHeader(ACCEPT_ENCODING_HEADER_NAME, "gzip, deflate");
                }
            }
            catch (Exception e) {
                logger.warn("Exception while apply SeleniumAcceptEncodingFilter", (Throwable)e);
            }
            return next.execute(req);
        };
    }
}

