/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.selenium.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumCreateSessionResponseFilter
implements Filter {
    private static Logger logger = LoggerFactory.getLogger(SeleniumCreateSessionResponseFilter.class);

    public HttpHandler apply(HttpHandler next) {
        return req -> {
            HttpResponse response = next.execute(req);
            if (response != null && HttpMethod.POST == req.getMethod() && req.getUri().endsWith("/session")) {
                try {
                    ObjectMapper objectMapper = new ObjectMapper();
                    String content = Contents.utf8String((Contents.Supplier)response.getContent());
                    Map map = (Map)objectMapper.readValue(content, Map.class);
                    Map value = (Map)map.get("value");
                    if (value != null && value.get("sessionId") == null && map.get("sessionId") != null) {
                        String sessionId = (String)map.get("sessionId");
                        value.put("sessionId", sessionId);
                        content = objectMapper.writeValueAsString((Object)map);
                        response.setContent(Contents.utf8String((CharSequence)content));
                    }
                }
                catch (Exception e) {
                    logger.error("Exception while trying to back-fill sessionId", (Throwable)e);
                }
            }
            return response;
        };
    }
}

