/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.selenium.validator;

import com.kms.katalon.selenium.exception.W3CCapabilityViolationException;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.AcceptedW3CCapabilityKeys;
import org.openqa.selenium.Capabilities;

public class W3CCapabilitiesValidator {
    private static AcceptedW3CCapabilityKeys acceptedW3CCapabilityKeys = new AcceptedW3CCapabilityKeys();

    public static void validate(Capabilities capabilities) throws W3CCapabilityViolationException {
        if (capabilities == null || capabilities.asMap().isEmpty()) {
            return;
        }
        List<String> uncompatibleCapabilityKeys = capabilities.asMap().keySet().stream().filter(key -> !acceptedW3CCapabilityKeys.test(key)).collect(Collectors.toList());
        if (!uncompatibleCapabilityKeys.isEmpty()) {
            throw new W3CCapabilityViolationException(uncompatibleCapabilityKeys);
        }
    }
}

